/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse.builders;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.E_Add;
import com.hp.hpl.jena.sparql.expr.E_Aggregator;
import com.hp.hpl.jena.sparql.expr.E_Bound;
import com.hp.hpl.jena.sparql.expr.E_Datatype;
import com.hp.hpl.jena.sparql.expr.E_Divide;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.E_Function;
import com.hp.hpl.jena.sparql.expr.E_GreaterThan;
import com.hp.hpl.jena.sparql.expr.E_GreaterThanOrEqual;
import com.hp.hpl.jena.sparql.expr.E_IsBlank;
import com.hp.hpl.jena.sparql.expr.E_IsIRI;
import com.hp.hpl.jena.sparql.expr.E_IsLiteral;
import com.hp.hpl.jena.sparql.expr.E_IsURI;
import com.hp.hpl.jena.sparql.expr.E_Lang;
import com.hp.hpl.jena.sparql.expr.E_LangMatches;
import com.hp.hpl.jena.sparql.expr.E_LessThan;
import com.hp.hpl.jena.sparql.expr.E_LessThanOrEqual;
import com.hp.hpl.jena.sparql.expr.E_LogicalAnd;
import com.hp.hpl.jena.sparql.expr.E_LogicalNot;
import com.hp.hpl.jena.sparql.expr.E_LogicalOr;
import com.hp.hpl.jena.sparql.expr.E_Multiply;
import com.hp.hpl.jena.sparql.expr.E_NotEquals;
import com.hp.hpl.jena.sparql.expr.E_Regex;
import com.hp.hpl.jena.sparql.expr.E_SameTerm;
import com.hp.hpl.jena.sparql.expr.E_Str;
import com.hp.hpl.jena.sparql.expr.E_Subtract;
import com.hp.hpl.jena.sparql.expr.E_UnaryMinus;
import com.hp.hpl.jena.sparql.expr.E_UnaryPlus;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.AggCount;
import com.hp.hpl.jena.sparql.expr.aggregate.AggCountDistinct;
import com.hp.hpl.jena.sparql.expr.aggregate.AggCountVar;
import com.hp.hpl.jena.sparql.expr.aggregate.AggCountVarDistinct;
import com.hp.hpl.jena.sparql.expr.aggregate.AggSum;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregateFactory;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemList;
import com.hp.hpl.jena.sparql.sse.builders.BuilderLib;
import com.hp.hpl.jena.sparql.sse.builders.BuilderNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BuilderExpr {
    protected Map dispatch = new HashMap();
    protected final Build buildRegex = new Build(){

        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, 4, list, "Regex: wanted 2 or 3 arguments");
            Expr expr = BuilderExpr.buildExpr(list.get(1));
            Expr pattern = BuilderExpr.buildExpr(list.get(2));
            Expr flags = null;
            if (list.size() != 3) {
                flags = BuilderExpr.buildExpr(list.get(3));
            }
            return new E_Regex(expr, pattern, flags);
        }
    };
    protected final Build buildPlus = new Build(){

        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, 3, list, "+: wanted 1 or 2 arguments");
            if (list.size() == 2) {
                Expr ex = BuilderExpr.buildExpr(list.get(1));
                return new E_UnaryPlus(ex);
            }
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_Add(left, right);
        }
    };
    protected final Build buildMinus = new Build(){

        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, 3, list, "-: wanted 1 or 2 arguments");
            if (list.size() == 2) {
                Expr ex = BuilderExpr.buildExpr(list.get(1));
                return new E_UnaryMinus(ex);
            }
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_Subtract(left, right);
        }
    };
    protected final Build buildEQ = new Build(){

        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, list, "=: wanted 2 arguments: got :" + list.size());
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_Equals(left, right);
        }
    };
    protected final Build buildNE = new Build(){

        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, list, "!=: wanted 2 arguments: got :" + list.size());
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_NotEquals(left, right);
        }
    };
    protected final Build buildGT = new Build(){

        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, list, ">: wanted 2 arguments: got :" + list.size());
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_GreaterThan(left, right);
        }
    };
    protected final Build buildLT = new Build(){

        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, list, "<: wanted 2 arguments: got :" + list.size());
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_LessThan(left, right);
        }
    };
    protected final Build buildLE = new Build(){

        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, list, "<=: wanted 2 arguments: got :" + list.size());
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_LessThanOrEqual(left, right);
        }
    };
    protected final Build buildGE = new Build(){

        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, list, ">=: wanted 2 arguments: got :" + list.size());
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_GreaterThanOrEqual(left, right);
        }
    };
    protected final Build buildOr = new Build(){

        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, list, "||: wanted 2 arguments: got :" + list.size());
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_LogicalOr(left, right);
        }
    };
    protected final Build buildAnd = new Build(){

        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, list, "&&: wanted 2 arguments: got :" + list.size());
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_LogicalAnd(left, right);
        }
    };
    protected final Build buildMult = new Build(){

        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, list, "*: wanted 2 arguments: got :" + list.size());
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_Multiply(left, right);
        }
    };
    protected final Build buildDiv = new Build(){

        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, list, "/: wanted 2 arguments: got :" + list.size());
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_Divide(left, right);
        }
    };
    protected final Build buildNot = new Build(){

        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "!: wanted 1 arguments: got :" + list.size());
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_LogicalNot(ex);
        }
    };
    protected final Build buildStr = new Build(){

        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "str: wanted 1 arguments: got :" + list.size());
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_Str(ex);
        }
    };
    protected final Build buildLang = new Build(){

        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "lang: wanted 1 arguments: got :" + list.size());
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_Lang(ex);
        }
    };
    protected final Build buildLangMatches = new Build(){

        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, list, "langmatches: wanted 2 arguments: got :" + list.size());
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_LangMatches(left, right);
        }
    };
    protected final Build buildSameTerm = new Build(){

        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, list, "sameterm: wanted 2 arguments: got :" + list.size());
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_SameTerm(left, right);
        }
    };
    protected final Build buildDatatype = new Build(){

        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "datatype: wanted 1 arguments: got :" + list.size());
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_Datatype(ex);
        }
    };
    protected final Build buildBound = new Build(){

        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "bound: wanted 1 arguments: got :" + list.size());
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_Bound(ex);
        }
    };
    protected final Build buildIRI = new Build(){

        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "isIRI: wanted 1 arguments: got :" + list.size());
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_IsIRI(ex);
        }
    };
    protected final Build buildURI = new Build(){

        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "isURI: wanted 1 arguments: got :" + list.size());
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_IsURI(ex);
        }
    };
    protected final Build buildIsBlank = new Build(){

        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "isBlank: wanted 1 arguments: got :" + list.size());
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_IsBlank(ex);
        }
    };
    protected final Build buildIsLiteral = new Build(){

        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "isLiteral: wanted 1 arguments: got :" + list.size());
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_IsLiteral(ex);
        }
    };
    protected final Build buildCount = new Build(){

        public Expr make(ItemList list) {
            ItemList x = list.cdr();
            boolean distinct = false;
            if (x.size() > 0 && x.car().isSymbol("distinct")) {
                distinct = true;
                x = x.cdr();
            }
            AggregateFactory agg = null;
            if (x.size() > 1) {
                BuilderLib.broken(list, "Broken syntax: " + list.shortString());
            }
            if (x.size() == 0) {
                agg = !distinct ? AggCount.get() : AggCountDistinct.get();
            } else {
                Var v = BuilderNode.buildVar(x.get(0));
                agg = !distinct ? new AggCountVar(v) : new AggCountVarDistinct(v);
            }
            return new E_Aggregator((Var)null, agg.create());
        }
    };
    protected final Build buildSum = new Build(){

        public Expr make(ItemList list) {
            ItemList x = list.cdr();
            if (x.size() != 1) {
                BuilderLib.broken(list, "Broken syntax: " + list.shortString());
            }
            Expr expr = BuilderExpr.buildExpr(x.get(0));
            AggSum agg = new AggSum(expr);
            return new E_Aggregator((Var)null, agg.create());
        }
    };

    public static ExprList buildExprOrExprList(Item item) {
        if (item.isTagged("exprlist")) {
            return BuilderExpr.buildExprList(item);
        }
        Expr expr = BuilderExpr.buildExpr(item);
        ExprList exprList = new ExprList(expr);
        return exprList;
    }

    public static ExprList buildExprList(Item item) {
        if (!item.isTagged("exprlist")) {
            BuilderLib.broken(item, "Not tagged exprlist");
        }
        ItemList list = item.getList();
        list = list.cdr();
        ExprList exprList = new ExprList();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Item elt = (Item)iter.next();
            Expr expr = BuilderExpr.buildExpr(elt);
            exprList.add(expr);
        }
        return exprList;
    }

    public static ExprList buildExprListUntagged(ItemList list) {
        return BuilderExpr.buildExprListUntagged(list, 0);
    }

    private static ExprList buildExprListUntagged(ItemList list, int idx) {
        ExprList exprList = new ExprList();
        for (int i = idx; i < list.size(); ++i) {
            Item item = list.get(i);
            exprList.add(BuilderExpr.buildExpr(item));
        }
        return exprList;
    }

    public static Expr buildExpr(Item item) {
        BuilderExpr bob = new BuilderExpr();
        return bob.buildItem(item);
    }

    public static VarExprList buildNamedExprList(ItemList list) {
        VarExprList x = new VarExprList();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Item item = (Item)iter.next();
            if (item.isNode()) {
                Var v = BuilderNode.buildVar(item);
                x.add(v);
                continue;
            }
            if (!item.isList() || item.getList().size() != 2) {
                BuilderLib.broken(item, "Not a var or var/expression pair");
            }
            Var var = BuilderNode.buildVar(item.getList().get(0));
            Expr expr = BuilderExpr.buildExpr(item.getList().get(1));
            if (expr instanceof E_Aggregator) {
                ((E_Aggregator)expr).setVar(var);
            }
            x.add(var, expr);
        }
        return x;
    }

    public Expr buildItem(Item item) {
        Object expr = null;
        if (item.isList()) {
            Item head;
            ItemList list = item.getList();
            if (list.size() == 0) {
                BuilderLib.broken(item, "Empty list for expression");
            }
            if ((head = list.get(0)).isNode()) {
                if (head.getNode().isVariable() && list.size() == 1) {
                    return new ExprVar(Var.alloc(head.getNode()));
                }
                return BuilderExpr.buildFunctionCall(list);
            }
            if (head.isList()) {
                BuilderLib.broken(item, "Head is a list");
            } else if (head.isSymbol()) {
                if (item.isTagged("expr")) {
                    BuilderLib.checkLength(2, list, "Wrong length: " + item.shortString());
                    item = list.get(1);
                    return this.buildItem(item);
                }
                return this.buildKnownFunction(list);
            }
            throw new ARQInternalErrorException();
        }
        if (item.isNode()) {
            if (Var.isVar(item.getNode())) {
                return new ExprVar(Var.alloc(item.getNode()));
            }
            return NodeValue.makeNode(item.getNode());
        }
        if (item.isSymbolIgnoreCase("true")) {
            return NodeValue.TRUE;
        }
        if (item.isSymbolIgnoreCase("false")) {
            return NodeValue.FALSE;
        }
        BuilderLib.broken(item, "Not a list or a node or recognized symbol: " + item);
        return null;
    }

    public BuilderExpr() {
        this.dispatch.put("regex", this.buildRegex);
        this.dispatch.put("=", this.buildEQ);
        this.dispatch.put("!=", this.buildNE);
        this.dispatch.put(">", this.buildGT);
        this.dispatch.put("<", this.buildLT);
        this.dispatch.put("<=", this.buildLE);
        this.dispatch.put(">=", this.buildGE);
        this.dispatch.put("||", this.buildOr);
        this.dispatch.put("or", this.buildOr);
        this.dispatch.put("&&", this.buildAnd);
        this.dispatch.put("and", this.buildAnd);
        this.dispatch.put("+", this.buildPlus);
        this.dispatch.put("-", this.buildMinus);
        this.dispatch.put("*", this.buildMult);
        this.dispatch.put("/", this.buildDiv);
        this.dispatch.put("not", this.buildNot);
        this.dispatch.put("!", this.buildNot);
        this.dispatch.put("str", this.buildStr);
        this.dispatch.put("lang", this.buildLang);
        this.dispatch.put("langmatches", this.buildLangMatches);
        this.dispatch.put("sameterm", this.buildSameTerm);
        this.dispatch.put("datatype", this.buildDatatype);
        this.dispatch.put("bound", this.buildBound);
        this.dispatch.put("isIRI", this.buildIRI);
        this.dispatch.put("isURI", this.buildURI);
        this.dispatch.put("isBlank", this.buildIsBlank);
        this.dispatch.put("isLiteral", this.buildIsLiteral);
        this.dispatch.put("count", this.buildCount);
        this.dispatch.put("sum", this.buildSum);
    }

    protected Build findBuild(String str2) {
        Iterator iter = this.dispatch.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!str2.equalsIgnoreCase(key)) continue;
            return (Build)this.dispatch.get(key);
        }
        return null;
    }

    protected Expr buildKnownFunction(ItemList list) {
        Build b;
        Item item;
        String tag;
        if (list.size() == 0) {
            BuilderLib.broken(list, "Empty list for expression");
        }
        if ((tag = (item = list.get(0)).getSymbol()) == null) {
            BuilderLib.broken(item, "Null tag");
        }
        if ((b = this.findBuild(tag)) == null) {
            BuilderLib.broken(item, "No known symbol for " + tag);
        }
        return b.make(list);
    }

    protected static Expr buildFunctionCall(ItemList list) {
        Item head = list.get(0);
        Node node = head.getNode();
        if (node.isBlank()) {
            BuilderLib.broken(head, "Blank node for function call!");
        }
        if (node.isLiteral()) {
            BuilderLib.broken(head, "Literal node for function call!");
        }
        ExprList args = BuilderExpr.buildExprListUntagged(list, 1);
        return new E_Function(node.getURI(), args);
    }

    public static interface Build {
        public Expr make(ItemList var1);
    }
}

