/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.binding;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.util.iterator.ConcatenatedIterator;
import java.util.Iterator;

public abstract class BindingBase
implements Binding {
    static boolean CHECKING = true;
    static boolean UNIQUE_NAMES_CHECK = true;
    protected Binding parent;

    protected BindingBase(Binding _parent) {
        this.parent = _parent;
    }

    public Binding getParent() {
        return this.parent;
    }

    public final void add(Var var, Node node) {
        if (node == null) {
            ALog.warn(this, "Binding.add: null value - ignored");
            return;
        }
        this.checkAdd(var, node);
        this.add1(var, node);
    }

    protected abstract void add1(Var var1, Node var2);

    public void addAll(Binding other) {
        Iterator iter = other.vars();
        while (iter.hasNext()) {
            Var v = (Var)iter.next();
            Node n = other.get(v);
            this.add(v, n);
        }
    }

    public final Iterator vars() {
        Iterator iter = this.vars1();
        if (this.parent != null) {
            iter = new ConcatenatedIterator(this.parent.vars(), iter);
        }
        return iter;
    }

    protected abstract Iterator vars1();

    public final int size() {
        int x = this.size1();
        if (this.parent != null) {
            x += this.parent.size();
        }
        return x;
    }

    protected abstract int size1();

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Var var) {
        if (this.contains1(var)) {
            return true;
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.contains(var);
    }

    protected abstract boolean contains1(Var var1);

    public final Node get(Var var) {
        Node node = this.get1(var);
        if (node != null) {
            return node;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.get(var);
    }

    protected abstract Node get1(Var var1);

    public String toString() {
        String tmp;
        StringBuffer sbuff = new StringBuffer();
        this.format1(sbuff);
        if (this.parent != null && (tmp = this.parent.toString()) != null && tmp.length() != 0) {
            sbuff.append(" -> ");
            sbuff.append(tmp);
        }
        return sbuff.toString();
    }

    public void format1(StringBuffer sbuff) {
        String sep = "";
        Iterator iter = this.vars1();
        while (iter.hasNext()) {
            Object obj = iter.next();
            Var var = (Var)obj;
            sbuff.append(sep);
            sep = " ";
            this.format(sbuff, var);
        }
    }

    protected void format(StringBuffer sbuff, Var var) {
        Node node = this.get(var);
        String tmp = FmtUtils.stringForObject(node);
        sbuff.append("( ?" + var.getVarName() + " = " + tmp + " )");
    }

    public String toString1() {
        StringBuffer sbuff = new StringBuffer();
        this.format1(sbuff);
        return sbuff.toString();
    }

    private void checkAdd(Var var, Node node) {
        if (!CHECKING) {
            return;
        }
        if (node == null) {
            throw new ARQInternalErrorException("check(" + var + ", " + node + "): null node value");
        }
        if (UNIQUE_NAMES_CHECK && this.contains(var)) {
            throw new ARQInternalErrorException("Attempt to reassign '" + var + "' from '" + FmtUtils.stringForNode(this.get(var)) + "' to '" + FmtUtils.stringForNode(node) + "'");
        }
        this.checkAdd1(var, node);
    }

    protected abstract void checkAdd1(Var var1, Node var2);

    public int hashCode() {
        return BindingBase.hashCode(this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Binding)) {
            return false;
        }
        Binding binding = (Binding)other;
        return BindingBase.equals(this, binding);
    }

    public static int hashCode(Binding bind) {
        int hash = 192;
        Iterator iter = bind.vars();
        while (iter.hasNext()) {
            Var var = (Var)iter.next();
            Node node = bind.get(var);
            hash ^= var.hashCode();
            hash ^= node.hashCode();
        }
        return hash;
    }

    public static boolean equals(Binding bind1, Binding bind2) {
        if (bind1 == bind2) {
            return true;
        }
        if (bind1.size() != bind2.size()) {
            return false;
        }
        Iterator iter1 = bind1.vars();
        while (iter1.hasNext()) {
            Var var = (Var)iter1.next();
            Node node1 = bind1.get(var);
            Node node2 = bind2.get(var);
            if (node1 == null && node2 == null) continue;
            if (node1 == null) {
                return false;
            }
            if (node2 == null) {
                return false;
            }
            if (node1.equals(node2)) continue;
            return false;
        }
        return true;
    }
}

