/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.mp.ObjectBuf;
import edu.rit.mp.buf.ObjectItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.CommStatus;
import edu.rit.pj.LongSchedule;
import edu.rit.pj.WorkerForLoop;
import edu.rit.pj.WorkerTeam;
import edu.rit.util.LongRange;
import edu.rit.util.Range;
import java.io.IOException;

public abstract class WorkerLongStrideForLoop
extends WorkerForLoop {
    public LongSchedule schedule() {
        return LongSchedule.runtime();
    }

    public void start() throws Exception {
    }

    public void sendTaskInput(LongRange longRange, Comm comm, int n, int n2) throws IOException {
    }

    public void receiveTaskInput(LongRange longRange, Comm comm, int n, int n2) throws IOException {
    }

    public abstract void run(long var1, long var3, long var5) throws Exception;

    public void sendTaskOutput(LongRange longRange, Comm comm, int n, int n2) throws IOException {
    }

    public void receiveTaskOutput(LongRange longRange, Comm comm, int n, int n2) throws IOException {
    }

    public void finish() throws Exception {
    }

    public int tagOffset() {
        return Integer.MIN_VALUE;
    }

    void masterExecute(LongRange longRange) throws IOException {
        LongSchedule longSchedule = this.schedule();
        if (longSchedule.isFixedSchedule()) {
            this.masterExecuteFixed(longRange, longSchedule);
        } else {
            this.masterExecuteNonFixed(longRange, longSchedule);
        }
    }

    void masterExecuteFixed(LongRange longRange, LongSchedule longSchedule) throws IOException {
        LongRange longRange2;
        int n;
        int n2 = this.myTeam.count;
        Comm comm = this.myTeam.comm;
        longSchedule.start(n2, longRange);
        for (n = 0; n < n2; ++n) {
            longRange2 = longSchedule.next(n);
            if (longRange2 == null) continue;
            this.sendTaskInput(longRange2, comm, this.myTeam.workerRank(n), this.tagFor(n));
        }
        longSchedule.start(n2, longRange);
        for (n = 0; n < n2; ++n) {
            longRange2 = longSchedule.next(n);
            if (longRange2 == null) continue;
            this.receiveTaskOutput(longRange2, comm, this.myTeam.workerRank(n), this.tagFor(n));
        }
    }

    void masterExecuteNonFixed(LongRange longRange, LongSchedule longSchedule) throws IOException {
        int n;
        int n2;
        LongRange longRange2;
        int n3 = this.myTeam.count;
        longSchedule.start(n3, longRange);
        int n4 = n3;
        ObjectItemBuf objectItemBuf = ObjectBuf.buffer();
        Range range = new Range(this.tagFor(0), this.tagFor(n3 - 1));
        Comm comm = this.myTeam.comm;
        for (int i = 0; i < n3; ++i) {
            longRange2 = longSchedule.next(i);
            objectItemBuf.item = longRange2;
            objectItemBuf.reset();
            n2 = this.myTeam.workerRank(i);
            n = this.tagFor(i);
            comm.send(n2, n, objectItemBuf);
            if (longRange2 == null) {
                --n4;
                continue;
            }
            this.sendTaskInput(longRange2, comm, n2, n);
        }
        while (n4 > 0) {
            CommStatus commStatus = comm.receive(null, range, objectItemBuf);
            longRange2 = (LongRange)objectItemBuf.item;
            n2 = commStatus.fromRank;
            n = commStatus.tag;
            int n5 = this.workerFor(n);
            this.receiveTaskOutput(longRange2, comm, n2, n);
            longRange2 = longSchedule.next(n5);
            objectItemBuf.item = longRange2;
            objectItemBuf.reset();
            comm.send(n2, n, objectItemBuf);
            if (longRange2 == null) {
                --n4;
                continue;
            }
            this.sendTaskInput(longRange2, comm, n2, n);
        }
    }

    void workerExecute(int n, LongRange longRange) throws Exception {
        LongSchedule longSchedule = this.schedule();
        if (longSchedule.isFixedSchedule()) {
            longSchedule.start(this.myTeam.count, longRange);
            this.workerExecuteFixed(longSchedule.next(n), n);
        } else {
            this.workerExecuteNonFixed(n);
        }
    }

    void workerExecuteFixed(LongRange longRange, int n) throws Exception {
        this.start();
        if (longRange != null) {
            Comm comm = this.myTeam.comm;
            int n2 = this.myTeam.masterRank();
            int n3 = this.tagFor(n);
            this.receiveTaskInput(longRange, comm, n2, n3);
            this.run(longRange.lb(), longRange.ub(), longRange.stride());
            this.sendTaskOutput(longRange, comm, n2, n3);
        }
        this.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void workerExecuteNonFixed(int n) throws Exception {
        Comm comm = this.myTeam.comm;
        int n2 = this.myTeam.masterRank();
        int n3 = this.tagFor(n);
        this.start();
        ObjectItemBuf objectItemBuf = ObjectBuf.buffer();
        while (true) {
            comm.receive((Integer)n2, n3, objectItemBuf);
            LongRange longRange = (LongRange)objectItemBuf.item;
            if (longRange == null) break;
            this.receiveTaskInput(longRange, comm, n2, n3);
            this.run(longRange.lb(), longRange.ub(), longRange.stride());
            WorkerTeam workerTeam = this.myTeam;
            synchronized (workerTeam) {
                comm.send(n2, n3, objectItemBuf);
                this.sendTaskOutput(longRange, comm, n2, n3);
            }
        }
        this.finish();
    }

    private int tagFor(int n) {
        return n + this.tagOffset();
    }

    private int workerFor(int n) {
        return n - this.tagOffset();
    }
}

