/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric;

import edu.rit.numeric.Series;
import edu.rit.numeric.Statistics;
import edu.rit.numeric.XYSeries;
import java.io.PrintStream;
import java.io.PrintWriter;

public abstract class XYZSeries {
    public abstract int length();

    public boolean isEmpty() {
        return this.length() == 0;
    }

    public abstract double x(int var1);

    public abstract double y(int var1);

    public abstract double z(int var1);

    public double minX() {
        int n = this.length();
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            d = Math.min(d, this.x(i));
        }
        return d;
    }

    public double maxX() {
        int n = this.length();
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            d = Math.max(d, this.x(i));
        }
        return d;
    }

    public double minY() {
        int n = this.length();
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            d = Math.min(d, this.y(i));
        }
        return d;
    }

    public double maxY() {
        int n = this.length();
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            d = Math.max(d, this.y(i));
        }
        return d;
    }

    public double minZ() {
        int n = this.length();
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            d = Math.min(d, this.z(i));
        }
        return d;
    }

    public double maxZ() {
        int n = this.length();
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            d = Math.max(d, this.z(i));
        }
        return d;
    }

    public Regression linearRegression() {
        int n = this.length();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d4 = this.z(i);
            double d5 = d4 * d4;
            d += this.x(i) / d5;
            d2 += this.y(i) / d5;
            d3 += 1.0 / d5;
        }
        double d6 = d / d3;
        double d7 = 0.0;
        double d8 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d9 = this.z(i);
            double d10 = (this.x(i) - d6) / d9;
            d7 += d10 * this.y(i) / d9;
            d8 += d10 * d10;
        }
        double d11 = (d2 - d * (d7 /= d8)) / d3;
        double d12 = (1.0 + d * d / d3 / d8) / d3;
        double d13 = 1.0 / d8;
        double d14 = -d / d3 / d8;
        double d15 = d14 / Math.sqrt(d12) / Math.sqrt(d13);
        double d16 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d17 = (this.y(i) - d11 - d7 * this.x(i)) / this.z(i);
            d16 += d17 * d17;
        }
        double d18 = Statistics.chiSquarePvalue(n - 2, d16);
        return new Regression(d11, d7, d12, d13, d14, d15, d16, d18);
    }

    public Series xSeries() {
        return new XSeriesView(this);
    }

    public Series ySeries() {
        return new YSeriesView(this);
    }

    public Series zSeries() {
        return new ZSeriesView(this);
    }

    public XYSeries xySeries() {
        return new XYSeriesView(this);
    }

    public void print() {
        this.print(System.out);
    }

    public void print(PrintStream printStream) {
        int n = this.length();
        for (int i = 0; i < n; ++i) {
            printStream.print(i);
            printStream.print('\t');
            printStream.print(this.x(i));
            printStream.print('\t');
            printStream.print(this.y(i));
            printStream.print('\t');
            printStream.println(this.z(i));
        }
    }

    public void print(PrintWriter printWriter) {
        int n = this.length();
        for (int i = 0; i < n; ++i) {
            printWriter.print(i);
            printWriter.print('\t');
            printWriter.print(this.x(i));
            printWriter.print('\t');
            printWriter.print(this.y(i));
            printWriter.print('\t');
            printWriter.println(this.z(i));
        }
    }

    private static class XYSeriesView
    extends XYSeries {
        private XYZSeries outer;

        public XYSeriesView(XYZSeries xYZSeries) {
            this.outer = xYZSeries;
        }

        public int length() {
            return this.outer.length();
        }

        public double x(int n) {
            return this.outer.x(n);
        }

        public double y(int n) {
            return this.outer.y(n);
        }
    }

    private static class ZSeriesView
    extends Series {
        private XYZSeries outer;

        public ZSeriesView(XYZSeries xYZSeries) {
            this.outer = xYZSeries;
        }

        public int length() {
            return this.outer.length();
        }

        public double x(int n) {
            return this.outer.z(n);
        }
    }

    private static class YSeriesView
    extends Series {
        private XYZSeries outer;

        public YSeriesView(XYZSeries xYZSeries) {
            this.outer = xYZSeries;
        }

        public int length() {
            return this.outer.length();
        }

        public double x(int n) {
            return this.outer.y(n);
        }
    }

    private static class XSeriesView
    extends Series {
        private XYZSeries outer;

        public XSeriesView(XYZSeries xYZSeries) {
            this.outer = xYZSeries;
        }

        public int length() {
            return this.outer.length();
        }

        public double x(int n) {
            return this.outer.x(n);
        }
    }

    public static class Regression {
        public final double a;
        public final double b;
        public final double var_a;
        public final double var_b;
        public final double cov_ab;
        public final double r_ab;
        public final double chi2;
        public final double significance;

        private Regression(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
            this.a = d;
            this.b = d2;
            this.var_a = d3;
            this.var_b = d4;
            this.cov_ab = d5;
            this.r_ab = d6;
            this.chi2 = d7;
            this.significance = d8;
        }
    }
}

