/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric;

import edu.rit.numeric.Function;
import edu.rit.numeric.XYSeries;

public class TransformedXYSeries
extends XYSeries {
    private XYSeries mySeries;
    private Function myXFunction;
    private Function myYFunction;

    public TransformedXYSeries(XYSeries xYSeries, Function function, Function function2) {
        if (xYSeries == null) {
            throw new NullPointerException("TransformedXYSeries(): theSeries is null");
        }
        this.mySeries = xYSeries;
        this.myXFunction = function;
        this.myYFunction = function2;
    }

    public int length() {
        return this.mySeries.length();
    }

    public double x(int n) {
        double d = this.mySeries.x(n);
        if (this.myXFunction != null) {
            d = this.myXFunction.f(d);
        }
        return d;
    }

    public double y(int n) {
        double d = this.mySeries.y(n);
        if (this.myYFunction != null) {
            d = this.myYFunction.f(d);
        }
        return d;
    }
}

