/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.DoubleBuf;
import edu.rit.mp.buf.DoubleArrayReductionBuf;
import edu.rit.pj.reduction.DoubleOp;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Arrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public class DoubleArrayBuf
extends DoubleBuf {
    double[] myArray;
    Range myRange;
    int myArrayOffset;
    int myStride;

    public DoubleArrayBuf(double[] dArray, Range range) {
        super(range.length());
        this.myArray = dArray;
        this.myRange = range;
        this.myArrayOffset = range.lb();
        this.myStride = range.stride();
    }

    public double get(int n) {
        return this.myArray[this.myArrayOffset + n * this.myStride];
    }

    public void put(int n, double d) {
        this.myArray[this.myArrayOffset + n * this.myStride] = d;
    }

    public void copy(Buf buf) {
        if (buf != this) {
            if (buf instanceof DoubleArrayBuf) {
                DoubleArrayBuf doubleArrayBuf = (DoubleArrayBuf)buf;
                Arrays.copy(doubleArrayBuf.myArray, doubleArrayBuf.myRange, this.myArray, this.myRange);
            } else {
                DoubleBuf.defaultCopy((DoubleBuf)buf, this);
            }
        }
    }

    public Buf getReductionBuf(Op op) {
        return new DoubleArrayReductionBuf(this.myArray, this.myRange, (DoubleOp)op);
    }

    protected int sendItems(int n, ByteBuffer byteBuffer) {
        int n2 = n;
        int n3 = this.myArrayOffset + n * this.myStride;
        while (n2 < this.myLength && byteBuffer.remaining() >= 8) {
            byteBuffer.putDouble(this.myArray[n3]);
            ++n2;
            n3 += this.myStride;
        }
        return n2 - n;
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        int n3 = n;
        int n4 = this.myArrayOffset + n * this.myStride;
        int n5 = Math.min(n + n2, this.myLength);
        while (n3 < n5 && byteBuffer.remaining() >= 8) {
            this.myArray[n4] = byteBuffer.getDouble();
            ++n3;
            n4 += this.myStride;
        }
        return n3 - n;
    }
}

