/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.ByteBuf;
import edu.rit.mp.buf.ByteMatrixBuf;
import edu.rit.pj.reduction.ByteOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.ReduceArrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

class ByteMatrixReductionBuf
extends ByteMatrixBuf {
    ByteOp myOp;

    public ByteMatrixReductionBuf(byte[][] byArray, Range range, Range range2, ByteOp byteOp) {
        super(byArray, range, range2);
        if (byteOp == null) {
            throw new NullPointerException("ByteMatrixReductionBuf(): op is null");
        }
        this.myOp = byteOp;
    }

    public void put(int n, byte by) {
        int n2 = n / this.myColCount * this.myRowStride + this.myLowerRow;
        int n3 = n % this.myColCount * this.myColStride + this.myLowerCol;
        this.myMatrix[n2][n3] = this.myOp.op(this.myMatrix[n2][n3], by);
    }

    public void copy(Buf buf) {
        if (buf != this) {
            if (buf instanceof ByteMatrixBuf) {
                ByteMatrixBuf byteMatrixBuf = (ByteMatrixBuf)buf;
                ReduceArrays.reduce(byteMatrixBuf.myMatrix, byteMatrixBuf.myRowRange, byteMatrixBuf.myColRange, this.myMatrix, this.myRowRange, this.myColRange, this.myOp);
            } else {
                ByteBuf.defaultCopy((ByteBuf)buf, this);
            }
        }
    }

    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        n2 = Math.min(n2, byteBuffer.remaining());
        int n3 = 0;
        int n4 = this.i2r(n);
        int n5 = n4 * this.myRowStride + this.myLowerRow;
        int n6 = this.i2c(n);
        int n7 = n6 * this.myColStride + this.myLowerCol;
        int n8 = Math.min(this.myColCount - n6, n2);
        while (n4 < this.myRowCount && n8 > 0) {
            byte[] byArray = this.myMatrix[n5];
            for (n6 = 0; n6 < n8; ++n6) {
                byArray[n7] = this.myOp.op(byArray[n7], byteBuffer.get());
                n7 += this.myColStride;
            }
            n3 += n8;
            ++n4;
            n5 += this.myRowStride;
            n7 = this.myLowerCol;
            n8 = Math.min(this.myColCount, n2 -= n8);
        }
        return n3;
    }
}

