/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.util;

import edu.rit.util.Range;
import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Arrays {
    private Arrays() {
    }

    public static <T, ST extends T> void allocate(T[] TArray, Class<ST> clazz) throws InstantiationException, IllegalAccessException {
        Arrays.allocate(TArray, new Range(0, TArray.length - 1), clazz);
    }

    public static <T, ST extends T> void allocate(T[] TArray, Range range, Class<ST> clazz) throws InstantiationException, IllegalAccessException {
        int n = range.lb();
        int n2 = range.ub();
        int n3 = range.stride();
        if (0 > n || n2 >= TArray.length) {
            throw new IndexOutOfBoundsException("Arrays.allocate(): array indexes = 0.." + (TArray.length - 1) + ", range = " + range);
        }
        for (int i = n; i <= n2; i += n3) {
            TArray[i] = clazz.newInstance();
        }
    }

    public static void allocate(boolean[][] blArray, int n) {
        Arrays.allocate(blArray, new Range(0, blArray.length - 1), n);
    }

    public static void allocate(boolean[][] blArray, Range range, int n) {
        int n2 = range.lb();
        int n3 = range.ub();
        int n4 = range.stride();
        if (0 > n2 || n3 >= blArray.length) {
            throw new IndexOutOfBoundsException("Arrays.allocate(): matrix row indexes = 0.." + (blArray.length - 1) + ", row range = " + range);
        }
        for (int i = n2; i <= n3; i += n4) {
            blArray[i] = new boolean[n];
        }
    }

    public static void allocate(byte[][] byArray, int n) {
        Arrays.allocate(byArray, new Range(0, byArray.length - 1), n);
    }

    public static void allocate(byte[][] byArray, Range range, int n) {
        int n2 = range.lb();
        int n3 = range.ub();
        int n4 = range.stride();
        if (0 > n2 || n3 >= byArray.length) {
            throw new IndexOutOfBoundsException("Arrays.allocate(): matrix row indexes = 0.." + (byArray.length - 1) + ", row range = " + range);
        }
        for (int i = n2; i <= n3; i += n4) {
            byArray[i] = new byte[n];
        }
    }

    public static void allocate(char[][] cArray, int n) {
        Arrays.allocate(cArray, new Range(0, cArray.length - 1), n);
    }

    public static void allocate(char[][] cArray, Range range, int n) {
        int n2 = range.lb();
        int n3 = range.ub();
        int n4 = range.stride();
        if (0 > n2 || n3 >= cArray.length) {
            throw new IndexOutOfBoundsException("Arrays.allocate(): matrix row indexes = 0.." + (cArray.length - 1) + ", row range = " + range);
        }
        for (int i = n2; i <= n3; i += n4) {
            cArray[i] = new char[n];
        }
    }

    public static void allocate(double[][] dArray, int n) {
        Arrays.allocate(dArray, new Range(0, dArray.length - 1), n);
    }

    public static void allocate(double[][] dArray, Range range, int n) {
        int n2 = range.lb();
        int n3 = range.ub();
        int n4 = range.stride();
        if (0 > n2 || n3 >= dArray.length) {
            throw new IndexOutOfBoundsException("Arrays.allocate(): matrix row indexes = 0.." + (dArray.length - 1) + ", row range = " + range);
        }
        for (int i = n2; i <= n3; i += n4) {
            dArray[i] = new double[n];
        }
    }

    public static void allocate(float[][] fArray, int n) {
        Arrays.allocate(fArray, new Range(0, fArray.length - 1), n);
    }

    public static void allocate(float[][] fArray, Range range, int n) {
        int n2 = range.lb();
        int n3 = range.ub();
        int n4 = range.stride();
        if (0 > n2 || n3 >= fArray.length) {
            throw new IndexOutOfBoundsException("Arrays.allocate(): matrix row indexes = 0.." + (fArray.length - 1) + ", row range = " + range);
        }
        for (int i = n2; i <= n3; i += n4) {
            fArray[i] = new float[n];
        }
    }

    public static void allocate(int[][] nArray, int n) {
        Arrays.allocate(nArray, new Range(0, nArray.length - 1), n);
    }

    public static void allocate(int[][] nArray, Range range, int n) {
        int n2 = range.lb();
        int n3 = range.ub();
        int n4 = range.stride();
        if (0 > n2 || n3 >= nArray.length) {
            throw new IndexOutOfBoundsException("Arrays.allocate(): matrix row indexes = 0.." + (nArray.length - 1) + ", row range = " + range);
        }
        for (int i = n2; i <= n3; i += n4) {
            nArray[i] = new int[n];
        }
    }

    public static void allocate(long[][] lArray, int n) {
        Arrays.allocate(lArray, new Range(0, lArray.length - 1), n);
    }

    public static void allocate(long[][] lArray, Range range, int n) {
        int n2 = range.lb();
        int n3 = range.ub();
        int n4 = range.stride();
        if (0 > n2 || n3 >= lArray.length) {
            throw new IndexOutOfBoundsException("Arrays.allocate(): matrix row indexes = 0.." + (lArray.length - 1) + ", row range = " + range);
        }
        for (int i = n2; i <= n3; i += n4) {
            lArray[i] = new long[n];
        }
    }

    public static void allocate(short[][] sArray, int n) {
        Arrays.allocate(sArray, new Range(0, sArray.length - 1), n);
    }

    public static void allocate(short[][] sArray, Range range, int n) {
        int n2 = range.lb();
        int n3 = range.ub();
        int n4 = range.stride();
        if (0 > n2 || n3 >= sArray.length) {
            throw new IndexOutOfBoundsException("Arrays.allocate(): matrix row indexes = 0.." + (sArray.length - 1) + ", row range = " + range);
        }
        for (int i = n2; i <= n3; i += n4) {
            sArray[i] = new short[n];
        }
    }

    public static <T, ST extends T> void allocate(T[][] TArray, int n, Class<ST> clazz) throws InstantiationException, IllegalAccessException {
        Arrays.allocate(TArray, new Range(0, TArray.length - 1), n, new Range(0, n - 1), clazz);
    }

    public static <T, ST extends T> void allocate(T[][] TArray, Range range, int n, Class<ST> clazz) throws InstantiationException, IllegalAccessException {
        Arrays.allocate(TArray, range, n, new Range(0, n - 1), clazz);
    }

    public static <T, ST extends T> void allocate(T[][] TArray, Range range, int n, Range range2, Class<ST> clazz) throws InstantiationException, IllegalAccessException {
        int n2 = range.lb();
        int n3 = range.ub();
        int n4 = range.stride();
        if (0 > n2 || n3 >= TArray.length) {
            throw new IndexOutOfBoundsException("Arrays.allocate(): matrix row indexes = 0.." + (TArray.length - 1) + ", row range = " + range);
        }
        int n5 = range2.lb();
        int n6 = range2.ub();
        int n7 = range2.stride();
        if (0 > n5 || n6 >= n) {
            throw new IndexOutOfBoundsException("Arrays.allocate(): matrix column indexes = 0.." + (n - 1) + ", column range = " + range2);
        }
        for (int i = n2; i <= n3; i += n4) {
            Object[] objectArray = (Object[])Array.newInstance(clazz, n);
            TArray[i] = objectArray;
            for (int j = n5; j <= n6; j += n7) {
                objectArray[j] = clazz.newInstance();
            }
        }
    }

    public static <T> void deallocate(T[] TArray) {
        Arrays.deallocate(TArray, new Range(0, TArray.length - 1));
    }

    public static <T> void deallocate(T[] TArray, Range range) {
        int n = range.lb();
        int n2 = range.ub();
        int n3 = range.stride();
        if (0 > n || n2 >= TArray.length) {
            throw new IndexOutOfBoundsException("Arrays.deallocate(): array indexes = 0.." + (TArray.length - 1) + ", range = " + range);
        }
        for (int i = n; i <= n2; i += n3) {
            TArray[i] = null;
        }
    }

    public static void deallocate(boolean[][] blArray) {
        Arrays.deallocate(blArray, new Range(0, blArray.length - 1));
    }

    public static void deallocate(boolean[][] blArray, Range range) {
        int n = range.lb();
        int n2 = range.ub();
        int n3 = range.stride();
        if (0 > n || n2 >= blArray.length) {
            throw new IndexOutOfBoundsException("Arrays.deallocate(): matrix row indexes = 0.." + (blArray.length - 1) + ", row range = " + range);
        }
        for (int i = n; i <= n2; i += n3) {
            blArray[i] = null;
        }
    }

    public static void deallocate(byte[][] byArray) {
        Arrays.deallocate(byArray, new Range(0, byArray.length - 1));
    }

    public static void deallocate(byte[][] byArray, Range range) {
        int n = range.lb();
        int n2 = range.ub();
        int n3 = range.stride();
        if (0 > n || n2 >= byArray.length) {
            throw new IndexOutOfBoundsException("Arrays.deallocate(): matrix row indexes = 0.." + (byArray.length - 1) + ", row range = " + range);
        }
        for (int i = n; i <= n2; i += n3) {
            byArray[i] = null;
        }
    }

    public static void deallocate(char[][] cArray) {
        Arrays.deallocate(cArray, new Range(0, cArray.length - 1));
    }

    public static void deallocate(char[][] cArray, Range range) {
        int n = range.lb();
        int n2 = range.ub();
        int n3 = range.stride();
        if (0 > n || n2 >= cArray.length) {
            throw new IndexOutOfBoundsException("Arrays.deallocate(): matrix row indexes = 0.." + (cArray.length - 1) + ", row range = " + range);
        }
        for (int i = n; i <= n2; i += n3) {
            cArray[i] = null;
        }
    }

    public static void deallocate(double[][] dArray) {
        Arrays.deallocate(dArray, new Range(0, dArray.length - 1));
    }

    public static void deallocate(double[][] dArray, Range range) {
        int n = range.lb();
        int n2 = range.ub();
        int n3 = range.stride();
        if (0 > n || n2 >= dArray.length) {
            throw new IndexOutOfBoundsException("Arrays.deallocate(): matrix row indexes = 0.." + (dArray.length - 1) + ", row range = " + range);
        }
        for (int i = n; i <= n2; i += n3) {
            dArray[i] = null;
        }
    }

    public static void deallocate(float[][] fArray) {
        Arrays.deallocate(fArray, new Range(0, fArray.length - 1));
    }

    public static void deallocate(float[][] fArray, Range range) {
        int n = range.lb();
        int n2 = range.ub();
        int n3 = range.stride();
        if (0 > n || n2 >= fArray.length) {
            throw new IndexOutOfBoundsException("Arrays.deallocate(): matrix row indexes = 0.." + (fArray.length - 1) + ", row range = " + range);
        }
        for (int i = n; i <= n2; i += n3) {
            fArray[i] = null;
        }
    }

    public static void deallocate(int[][] nArray) {
        Arrays.deallocate(nArray, new Range(0, nArray.length - 1));
    }

    public static void deallocate(int[][] nArray, Range range) {
        int n = range.lb();
        int n2 = range.ub();
        int n3 = range.stride();
        if (0 > n || n2 >= nArray.length) {
            throw new IndexOutOfBoundsException("Arrays.deallocate(): matrix row indexes = 0.." + (nArray.length - 1) + ", row range = " + range);
        }
        for (int i = n; i <= n2; i += n3) {
            nArray[i] = null;
        }
    }

    public static void deallocate(long[][] lArray) {
        Arrays.deallocate(lArray, new Range(0, lArray.length - 1));
    }

    public static void deallocate(long[][] lArray, Range range) {
        int n = range.lb();
        int n2 = range.ub();
        int n3 = range.stride();
        if (0 > n || n2 >= lArray.length) {
            throw new IndexOutOfBoundsException("Arrays.deallocate(): matrix row indexes = 0.." + (lArray.length - 1) + ", row range = " + range);
        }
        for (int i = n; i <= n2; i += n3) {
            lArray[i] = null;
        }
    }

    public static void deallocate(short[][] sArray) {
        Arrays.deallocate(sArray, new Range(0, sArray.length - 1));
    }

    public static void deallocate(short[][] sArray, Range range) {
        int n = range.lb();
        int n2 = range.ub();
        int n3 = range.stride();
        if (0 > n || n2 >= sArray.length) {
            throw new IndexOutOfBoundsException("Arrays.deallocate(): matrix row indexes = 0.." + (sArray.length - 1) + ", row range = " + range);
        }
        for (int i = n; i <= n2; i += n3) {
            sArray[i] = null;
        }
    }

    public static <T> void deallocate(T[][] TArray) {
        Arrays.deallocate(TArray, new Range(0, TArray.length - 1));
    }

    public static <T> void deallocate(T[][] TArray, Range range) {
        int n = range.lb();
        int n2 = range.ub();
        int n3 = range.stride();
        if (0 > n || n2 >= TArray.length) {
            throw new IndexOutOfBoundsException("Arrays.deallocate(): matrix row indexes = 0.." + (TArray.length - 1) + ", row range = " + range);
        }
        for (int i = n; i <= n2; i += n3) {
            TArray[i] = null;
        }
    }

    public static <T> void deallocate(T[][] TArray, Range range, Range range2) {
        int n = range.lb();
        int n2 = range.ub();
        int n3 = range.stride();
        if (0 > n || n2 >= TArray.length) {
            throw new IndexOutOfBoundsException("Arrays.deallocate(): matrix row indexes = 0.." + (TArray.length - 1) + ", row range = " + range);
        }
        int n4 = range2.lb();
        int n5 = range2.ub();
        int n6 = range2.stride();
        for (int i = n; i <= n2; i += n3) {
            T[] TArray2 = TArray[i];
            int n7 = TArray2.length;
            if (0 > n4 || n5 >= n7) {
                throw new IndexOutOfBoundsException("Arrays.allocate(): matrix column indexes = 0.." + (n7 - 1) + ", column range = " + range2);
            }
            for (int j = n4; j <= n5; j += n6) {
                TArray2[j] = null;
            }
        }
    }

    public static void copy(boolean[] blArray, Range range, boolean[] blArray2, Range range2) {
        block7: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            block8: {
                block6: {
                    int n7 = Math.min(range.length(), range2.length());
                    if (n7 == 0) {
                        return;
                    }
                    n6 = range.lb();
                    n5 = range2.lb();
                    if (blArray == blArray2 && n6 == n5) {
                        return;
                    }
                    n4 = range.stride();
                    n3 = range2.stride();
                    if (n4 != 1 || n3 != 1) break block6;
                    System.arraycopy(blArray, n6, blArray2, n5, n7);
                    break block7;
                }
                n2 = range.ub();
                n = range2.ub();
                if (0 > n6 || n2 >= blArray.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src indexes = 0.." + (blArray.length - 1) + ", srcRange = " + range);
                }
                if (0 > n5 || n >= blArray2.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst indexes = 0.." + (blArray2.length - 1) + ", dstRange = " + range2);
                }
                if (blArray == blArray2 && n6 <= n5) break block8;
                int n8 = n6;
                int n9 = n5;
                while (n8 <= n2) {
                    blArray2[n9] = blArray[n8];
                    n8 += n4;
                    n9 += n3;
                }
                break block7;
            }
            if (n6 >= n5) break block7;
            int n10 = n2;
            int n11 = n;
            while (n10 >= n6) {
                blArray2[n11] = blArray[n10];
                n10 -= n4;
                n11 -= n3;
            }
        }
    }

    public static void copy(byte[] byArray, Range range, byte[] byArray2, Range range2) {
        block7: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            block8: {
                block6: {
                    int n7 = Math.min(range.length(), range2.length());
                    if (n7 == 0) {
                        return;
                    }
                    n6 = range.lb();
                    n5 = range2.lb();
                    if (byArray == byArray2 && n6 == n5) {
                        return;
                    }
                    n4 = range.stride();
                    n3 = range2.stride();
                    if (n4 != 1 || n3 != 1) break block6;
                    System.arraycopy(byArray, n6, byArray2, n5, n7);
                    break block7;
                }
                n2 = range.ub();
                n = range2.ub();
                if (0 > n6 || n2 >= byArray.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src indexes = 0.." + (byArray.length - 1) + ", srcRange = " + range);
                }
                if (0 > n5 || n >= byArray2.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst indexes = 0.." + (byArray2.length - 1) + ", dstRange = " + range2);
                }
                if (byArray == byArray2 && n6 <= n5) break block8;
                int n8 = n6;
                int n9 = n5;
                while (n8 <= n2) {
                    byArray2[n9] = byArray[n8];
                    n8 += n4;
                    n9 += n3;
                }
                break block7;
            }
            if (n6 >= n5) break block7;
            int n10 = n2;
            int n11 = n;
            while (n10 >= n6) {
                byArray2[n11] = byArray[n10];
                n10 -= n4;
                n11 -= n3;
            }
        }
    }

    public static void copy(char[] cArray, Range range, char[] cArray2, Range range2) {
        block7: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            block8: {
                block6: {
                    int n7 = Math.min(range.length(), range2.length());
                    if (n7 == 0) {
                        return;
                    }
                    n6 = range.lb();
                    n5 = range2.lb();
                    if (cArray == cArray2 && n6 == n5) {
                        return;
                    }
                    n4 = range.stride();
                    n3 = range2.stride();
                    if (n4 != 1 || n3 != 1) break block6;
                    System.arraycopy(cArray, n6, cArray2, n5, n7);
                    break block7;
                }
                n2 = range.ub();
                n = range2.ub();
                if (0 > n6 || n2 >= cArray.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src indexes = 0.." + (cArray.length - 1) + ", srcRange = " + range);
                }
                if (0 > n5 || n >= cArray2.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst indexes = 0.." + (cArray2.length - 1) + ", dstRange = " + range2);
                }
                if (cArray == cArray2 && n6 <= n5) break block8;
                int n8 = n6;
                int n9 = n5;
                while (n8 <= n2) {
                    cArray2[n9] = cArray[n8];
                    n8 += n4;
                    n9 += n3;
                }
                break block7;
            }
            if (n6 >= n5) break block7;
            int n10 = n2;
            int n11 = n;
            while (n10 >= n6) {
                cArray2[n11] = cArray[n10];
                n10 -= n4;
                n11 -= n3;
            }
        }
    }

    public static void copy(double[] dArray, Range range, double[] dArray2, Range range2) {
        block7: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            block8: {
                block6: {
                    int n7 = Math.min(range.length(), range2.length());
                    if (n7 == 0) {
                        return;
                    }
                    n6 = range.lb();
                    n5 = range2.lb();
                    if (dArray == dArray2 && n6 == n5) {
                        return;
                    }
                    n4 = range.stride();
                    n3 = range2.stride();
                    if (n4 != 1 || n3 != 1) break block6;
                    System.arraycopy(dArray, n6, dArray2, n5, n7);
                    break block7;
                }
                n2 = range.ub();
                n = range2.ub();
                if (0 > n6 || n2 >= dArray.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src indexes = 0.." + (dArray.length - 1) + ", srcRange = " + range);
                }
                if (0 > n5 || n >= dArray2.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst indexes = 0.." + (dArray2.length - 1) + ", dstRange = " + range2);
                }
                if (dArray == dArray2 && n6 <= n5) break block8;
                int n8 = n6;
                int n9 = n5;
                while (n8 <= n2) {
                    dArray2[n9] = dArray[n8];
                    n8 += n4;
                    n9 += n3;
                }
                break block7;
            }
            if (n6 >= n5) break block7;
            int n10 = n2;
            int n11 = n;
            while (n10 >= n6) {
                dArray2[n11] = dArray[n10];
                n10 -= n4;
                n11 -= n3;
            }
        }
    }

    public static void copy(float[] fArray, Range range, float[] fArray2, Range range2) {
        block7: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            block8: {
                block6: {
                    int n7 = Math.min(range.length(), range2.length());
                    if (n7 == 0) {
                        return;
                    }
                    n6 = range.lb();
                    n5 = range2.lb();
                    if (fArray == fArray2 && n6 == n5) {
                        return;
                    }
                    n4 = range.stride();
                    n3 = range2.stride();
                    if (n4 != 1 || n3 != 1) break block6;
                    System.arraycopy(fArray, n6, fArray2, n5, n7);
                    break block7;
                }
                n2 = range.ub();
                n = range2.ub();
                if (0 > n6 || n2 >= fArray.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src indexes = 0.." + (fArray.length - 1) + ", srcRange = " + range);
                }
                if (0 > n5 || n >= fArray2.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst indexes = 0.." + (fArray2.length - 1) + ", dstRange = " + range2);
                }
                if (fArray == fArray2 && n6 <= n5) break block8;
                int n8 = n6;
                int n9 = n5;
                while (n8 <= n2) {
                    fArray2[n9] = fArray[n8];
                    n8 += n4;
                    n9 += n3;
                }
                break block7;
            }
            if (n6 >= n5) break block7;
            int n10 = n2;
            int n11 = n;
            while (n10 >= n6) {
                fArray2[n11] = fArray[n10];
                n10 -= n4;
                n11 -= n3;
            }
        }
    }

    public static void copy(int[] nArray, Range range, int[] nArray2, Range range2) {
        block7: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            block8: {
                block6: {
                    int n7 = Math.min(range.length(), range2.length());
                    if (n7 == 0) {
                        return;
                    }
                    n6 = range.lb();
                    n5 = range2.lb();
                    if (nArray == nArray2 && n6 == n5) {
                        return;
                    }
                    n4 = range.stride();
                    n3 = range2.stride();
                    if (n4 != 1 || n3 != 1) break block6;
                    System.arraycopy(nArray, n6, nArray2, n5, n7);
                    break block7;
                }
                n2 = range.ub();
                n = range2.ub();
                if (0 > n6 || n2 >= nArray.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src indexes = 0.." + (nArray.length - 1) + ", srcRange = " + range);
                }
                if (0 > n5 || n >= nArray2.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst indexes = 0.." + (nArray2.length - 1) + ", dstRange = " + range2);
                }
                if (nArray == nArray2 && n6 <= n5) break block8;
                int n8 = n6;
                int n9 = n5;
                while (n8 <= n2) {
                    nArray2[n9] = nArray[n8];
                    n8 += n4;
                    n9 += n3;
                }
                break block7;
            }
            if (n6 >= n5) break block7;
            int n10 = n2;
            int n11 = n;
            while (n10 >= n6) {
                nArray2[n11] = nArray[n10];
                n10 -= n4;
                n11 -= n3;
            }
        }
    }

    public static void copy(long[] lArray, Range range, long[] lArray2, Range range2) {
        block7: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            block8: {
                block6: {
                    int n7 = Math.min(range.length(), range2.length());
                    if (n7 == 0) {
                        return;
                    }
                    n6 = range.lb();
                    n5 = range2.lb();
                    if (lArray == lArray2 && n6 == n5) {
                        return;
                    }
                    n4 = range.stride();
                    n3 = range2.stride();
                    if (n4 != 1 || n3 != 1) break block6;
                    System.arraycopy(lArray, n6, lArray2, n5, n7);
                    break block7;
                }
                n2 = range.ub();
                n = range2.ub();
                if (0 > n6 || n2 >= lArray.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src indexes = 0.." + (lArray.length - 1) + ", srcRange = " + range);
                }
                if (0 > n5 || n >= lArray2.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst indexes = 0.." + (lArray2.length - 1) + ", dstRange = " + range2);
                }
                if (lArray == lArray2 && n6 <= n5) break block8;
                int n8 = n6;
                int n9 = n5;
                while (n8 <= n2) {
                    lArray2[n9] = lArray[n8];
                    n8 += n4;
                    n9 += n3;
                }
                break block7;
            }
            if (n6 >= n5) break block7;
            int n10 = n2;
            int n11 = n;
            while (n10 >= n6) {
                lArray2[n11] = lArray[n10];
                n10 -= n4;
                n11 -= n3;
            }
        }
    }

    public static void copy(short[] sArray, Range range, short[] sArray2, Range range2) {
        block7: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            block8: {
                block6: {
                    int n7 = Math.min(range.length(), range2.length());
                    if (n7 == 0) {
                        return;
                    }
                    n6 = range.lb();
                    n5 = range2.lb();
                    if (sArray == sArray2 && n6 == n5) {
                        return;
                    }
                    n4 = range.stride();
                    n3 = range2.stride();
                    if (n4 != 1 || n3 != 1) break block6;
                    System.arraycopy(sArray, n6, sArray2, n5, n7);
                    break block7;
                }
                n2 = range.ub();
                n = range2.ub();
                if (0 > n6 || n2 >= sArray.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src indexes = 0.." + (sArray.length - 1) + ", srcRange = " + range);
                }
                if (0 > n5 || n >= sArray2.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst indexes = 0.." + (sArray2.length - 1) + ", dstRange = " + range2);
                }
                if (sArray == sArray2 && n6 <= n5) break block8;
                int n8 = n6;
                int n9 = n5;
                while (n8 <= n2) {
                    sArray2[n9] = sArray[n8];
                    n8 += n4;
                    n9 += n3;
                }
                break block7;
            }
            if (n6 >= n5) break block7;
            int n10 = n2;
            int n11 = n;
            while (n10 >= n6) {
                sArray2[n11] = sArray[n10];
                n10 -= n4;
                n11 -= n3;
            }
        }
    }

    public static <DT, ST extends DT> void copy(ST[] STArray, Range range, DT[] DTArray, Range range2) {
        block7: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            block8: {
                block6: {
                    int n7 = Math.min(range.length(), range2.length());
                    if (n7 == 0) {
                        return;
                    }
                    n6 = range.lb();
                    n5 = range2.lb();
                    if (STArray == DTArray && n6 == n5) {
                        return;
                    }
                    n4 = range.stride();
                    n3 = range2.stride();
                    if (n4 != 1 || n3 != 1) break block6;
                    System.arraycopy(STArray, n6, DTArray, n5, n7);
                    break block7;
                }
                n2 = range.ub();
                n = range2.ub();
                if (0 > n6 || n2 >= STArray.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src indexes = 0.." + (STArray.length - 1) + ", srcRange = " + range);
                }
                if (0 > n5 || n >= DTArray.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst indexes = 0.." + (DTArray.length - 1) + ", dstRange = " + range2);
                }
                if (STArray == DTArray && n6 <= n5) break block8;
                int n8 = n6;
                int n9 = n5;
                while (n8 <= n2) {
                    DTArray[n9] = STArray[n8];
                    n8 += n4;
                    n9 += n3;
                }
                break block7;
            }
            if (n6 >= n5) break block7;
            int n10 = n2;
            int n11 = n;
            while (n10 >= n6) {
                DTArray[n11] = STArray[n10];
                n10 -= n4;
                n11 -= n3;
            }
        }
    }

    public static void copy(boolean[][] blArray, Range range, Range range2, boolean[][] blArray2, Range range3, Range range4) {
        block6: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            block5: {
                int n7 = Math.min(range.length(), range3.length());
                if (n7 == 0) {
                    return;
                }
                n6 = range.lb();
                n5 = range3.lb();
                n4 = range.stride();
                n3 = range3.stride();
                n2 = range.ub();
                n = range3.ub();
                if (0 > n6 || n2 >= blArray.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src row indexes = 0.." + (blArray.length - 1) + ", srcRowRange = " + range);
                }
                if (0 > n5 || n >= blArray2.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst row indexes = 0.." + (blArray2.length - 1) + ", dstRowRange = " + range3);
                }
                if (blArray == blArray2 && n6 <= n5) break block5;
                int n8 = n6;
                int n9 = n5;
                while (n8 <= n2) {
                    Arrays.copy(blArray[n8], range2, blArray2[n9], range4);
                    n8 += n4;
                    n9 += n3;
                }
                break block6;
            }
            if (n6 >= n5) break block6;
            int n10 = n2;
            int n11 = n;
            while (n10 >= n6) {
                Arrays.copy(blArray[n10], range2, blArray2[n11], range4);
                n10 -= n4;
                n11 -= n3;
            }
        }
    }

    public static void copy(byte[][] byArray, Range range, Range range2, byte[][] byArray2, Range range3, Range range4) {
        block6: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            block5: {
                int n7 = Math.min(range.length(), range3.length());
                if (n7 == 0) {
                    return;
                }
                n6 = range.lb();
                n5 = range3.lb();
                n4 = range.stride();
                n3 = range3.stride();
                n2 = range.ub();
                n = range3.ub();
                if (0 > n6 || n2 >= byArray.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src row indexes = 0.." + (byArray.length - 1) + ", srcRowRange = " + range);
                }
                if (0 > n5 || n >= byArray2.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst row indexes = 0.." + (byArray2.length - 1) + ", dstRowRange = " + range3);
                }
                if (byArray == byArray2 && n6 <= n5) break block5;
                int n8 = n6;
                int n9 = n5;
                while (n8 <= n2) {
                    Arrays.copy(byArray[n8], range2, byArray2[n9], range4);
                    n8 += n4;
                    n9 += n3;
                }
                break block6;
            }
            if (n6 >= n5) break block6;
            int n10 = n2;
            int n11 = n;
            while (n10 >= n6) {
                Arrays.copy(byArray[n10], range2, byArray2[n11], range4);
                n10 -= n4;
                n11 -= n3;
            }
        }
    }

    public static void copy(char[][] cArray, Range range, Range range2, char[][] cArray2, Range range3, Range range4) {
        block6: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            block5: {
                int n7 = Math.min(range.length(), range3.length());
                if (n7 == 0) {
                    return;
                }
                n6 = range.lb();
                n5 = range3.lb();
                n4 = range.stride();
                n3 = range3.stride();
                n2 = range.ub();
                n = range3.ub();
                if (0 > n6 || n2 >= cArray.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src row indexes = 0.." + (cArray.length - 1) + ", srcRowRange = " + range);
                }
                if (0 > n5 || n >= cArray2.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst row indexes = 0.." + (cArray2.length - 1) + ", dstRowRange = " + range3);
                }
                if (cArray == cArray2 && n6 <= n5) break block5;
                int n8 = n6;
                int n9 = n5;
                while (n8 <= n2) {
                    Arrays.copy(cArray[n8], range2, cArray2[n9], range4);
                    n8 += n4;
                    n9 += n3;
                }
                break block6;
            }
            if (n6 >= n5) break block6;
            int n10 = n2;
            int n11 = n;
            while (n10 >= n6) {
                Arrays.copy(cArray[n10], range2, cArray2[n11], range4);
                n10 -= n4;
                n11 -= n3;
            }
        }
    }

    public static void copy(double[][] dArray, Range range, Range range2, double[][] dArray2, Range range3, Range range4) {
        block6: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            block5: {
                int n7 = Math.min(range.length(), range3.length());
                if (n7 == 0) {
                    return;
                }
                n6 = range.lb();
                n5 = range3.lb();
                n4 = range.stride();
                n3 = range3.stride();
                n2 = range.ub();
                n = range3.ub();
                if (0 > n6 || n2 >= dArray.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src row indexes = 0.." + (dArray.length - 1) + ", srcRowRange = " + range);
                }
                if (0 > n5 || n >= dArray2.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst row indexes = 0.." + (dArray2.length - 1) + ", dstRowRange = " + range3);
                }
                if (dArray == dArray2 && n6 <= n5) break block5;
                int n8 = n6;
                int n9 = n5;
                while (n8 <= n2) {
                    Arrays.copy(dArray[n8], range2, dArray2[n9], range4);
                    n8 += n4;
                    n9 += n3;
                }
                break block6;
            }
            if (n6 >= n5) break block6;
            int n10 = n2;
            int n11 = n;
            while (n10 >= n6) {
                Arrays.copy(dArray[n10], range2, dArray2[n11], range4);
                n10 -= n4;
                n11 -= n3;
            }
        }
    }

    public static void copy(float[][] fArray, Range range, Range range2, float[][] fArray2, Range range3, Range range4) {
        block6: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            block5: {
                int n7 = Math.min(range.length(), range3.length());
                if (n7 == 0) {
                    return;
                }
                n6 = range.lb();
                n5 = range3.lb();
                n4 = range.stride();
                n3 = range3.stride();
                n2 = range.ub();
                n = range3.ub();
                if (0 > n6 || n2 >= fArray.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src row indexes = 0.." + (fArray.length - 1) + ", srcRowRange = " + range);
                }
                if (0 > n5 || n >= fArray2.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst row indexes = 0.." + (fArray2.length - 1) + ", dstRowRange = " + range3);
                }
                if (fArray == fArray2 && n6 <= n5) break block5;
                int n8 = n6;
                int n9 = n5;
                while (n8 <= n2) {
                    Arrays.copy(fArray[n8], range2, fArray2[n9], range4);
                    n8 += n4;
                    n9 += n3;
                }
                break block6;
            }
            if (n6 >= n5) break block6;
            int n10 = n2;
            int n11 = n;
            while (n10 >= n6) {
                Arrays.copy(fArray[n10], range2, fArray2[n11], range4);
                n10 -= n4;
                n11 -= n3;
            }
        }
    }

    public static void copy(int[][] nArray, Range range, Range range2, int[][] nArray2, Range range3, Range range4) {
        block6: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            block5: {
                int n7 = Math.min(range.length(), range3.length());
                if (n7 == 0) {
                    return;
                }
                n6 = range.lb();
                n5 = range3.lb();
                n4 = range.stride();
                n3 = range3.stride();
                n2 = range.ub();
                n = range3.ub();
                if (0 > n6 || n2 >= nArray.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src row indexes = 0.." + (nArray.length - 1) + ", srcRowRange = " + range);
                }
                if (0 > n5 || n >= nArray2.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst row indexes = 0.." + (nArray2.length - 1) + ", dstRowRange = " + range3);
                }
                if (nArray == nArray2 && n6 <= n5) break block5;
                int n8 = n6;
                int n9 = n5;
                while (n8 <= n2) {
                    Arrays.copy(nArray[n8], range2, nArray2[n9], range4);
                    n8 += n4;
                    n9 += n3;
                }
                break block6;
            }
            if (n6 >= n5) break block6;
            int n10 = n2;
            int n11 = n;
            while (n10 >= n6) {
                Arrays.copy(nArray[n10], range2, nArray2[n11], range4);
                n10 -= n4;
                n11 -= n3;
            }
        }
    }

    public static void copy(long[][] lArray, Range range, Range range2, long[][] lArray2, Range range3, Range range4) {
        block6: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            block5: {
                int n7 = Math.min(range.length(), range3.length());
                if (n7 == 0) {
                    return;
                }
                n6 = range.lb();
                n5 = range3.lb();
                n4 = range.stride();
                n3 = range3.stride();
                n2 = range.ub();
                n = range3.ub();
                if (0 > n6 || n2 >= lArray.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src row indexes = 0.." + (lArray.length - 1) + ", srcRowRange = " + range);
                }
                if (0 > n5 || n >= lArray2.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst row indexes = 0.." + (lArray2.length - 1) + ", dstRowRange = " + range3);
                }
                if (lArray == lArray2 && n6 <= n5) break block5;
                int n8 = n6;
                int n9 = n5;
                while (n8 <= n2) {
                    Arrays.copy(lArray[n8], range2, lArray2[n9], range4);
                    n8 += n4;
                    n9 += n3;
                }
                break block6;
            }
            if (n6 >= n5) break block6;
            int n10 = n2;
            int n11 = n;
            while (n10 >= n6) {
                Arrays.copy(lArray[n10], range2, lArray2[n11], range4);
                n10 -= n4;
                n11 -= n3;
            }
        }
    }

    public static void copy(short[][] sArray, Range range, Range range2, short[][] sArray2, Range range3, Range range4) {
        block6: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            block5: {
                int n7 = Math.min(range.length(), range3.length());
                if (n7 == 0) {
                    return;
                }
                n6 = range.lb();
                n5 = range3.lb();
                n4 = range.stride();
                n3 = range3.stride();
                n2 = range.ub();
                n = range3.ub();
                if (0 > n6 || n2 >= sArray.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src row indexes = 0.." + (sArray.length - 1) + ", srcRowRange = " + range);
                }
                if (0 > n5 || n >= sArray2.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst row indexes = 0.." + (sArray2.length - 1) + ", dstRowRange = " + range3);
                }
                if (sArray == sArray2 && n6 <= n5) break block5;
                int n8 = n6;
                int n9 = n5;
                while (n8 <= n2) {
                    Arrays.copy(sArray[n8], range2, sArray2[n9], range4);
                    n8 += n4;
                    n9 += n3;
                }
                break block6;
            }
            if (n6 >= n5) break block6;
            int n10 = n2;
            int n11 = n;
            while (n10 >= n6) {
                Arrays.copy(sArray[n10], range2, sArray2[n11], range4);
                n10 -= n4;
                n11 -= n3;
            }
        }
    }

    public static <DT, ST extends DT> void copy(ST[][] STArray, Range range, Range range2, DT[][] DTArray, Range range3, Range range4) {
        block6: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            block5: {
                int n7 = Math.min(range.length(), range3.length());
                if (n7 == 0) {
                    return;
                }
                n6 = range.lb();
                n5 = range3.lb();
                n4 = range.stride();
                n3 = range3.stride();
                n2 = range.ub();
                n = range3.ub();
                if (0 > n6 || n2 >= STArray.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src row indexes = 0.." + (STArray.length - 1) + ", srcRowRange = " + range);
                }
                if (0 > n5 || n >= DTArray.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst row indexes = 0.." + (DTArray.length - 1) + ", dstRowRange = " + range3);
                }
                if (STArray == DTArray && n6 <= n5) break block5;
                int n8 = n6;
                int n9 = n5;
                while (n8 <= n2) {
                    Arrays.copy(STArray[n8], range2, DTArray[n9], range4);
                    n8 += n4;
                    n9 += n3;
                }
                break block6;
            }
            if (n6 >= n5) break block6;
            int n10 = n2;
            int n11 = n;
            while (n10 >= n6) {
                Arrays.copy(STArray[n10], range2, DTArray[n11], range4);
                n10 -= n4;
                n11 -= n3;
            }
        }
    }

    public static int length(boolean[] blArray) {
        return blArray == null ? 0 : blArray.length;
    }

    public static int length(byte[] byArray) {
        return byArray == null ? 0 : byArray.length;
    }

    public static int length(char[] cArray) {
        return cArray == null ? 0 : cArray.length;
    }

    public static int length(double[] dArray) {
        return dArray == null ? 0 : dArray.length;
    }

    public static int length(float[] fArray) {
        return fArray == null ? 0 : fArray.length;
    }

    public static int length(int[] nArray) {
        return nArray == null ? 0 : nArray.length;
    }

    public static int length(long[] lArray) {
        return lArray == null ? 0 : lArray.length;
    }

    public static int length(short[] sArray) {
        return sArray == null ? 0 : sArray.length;
    }

    public static <T> int length(T[] TArray) {
        return TArray == null ? 0 : TArray.length;
    }

    public static int rowLength(boolean[][] blArray) {
        return blArray == null ? 0 : blArray.length;
    }

    public static int rowLength(byte[][] byArray) {
        return byArray == null ? 0 : byArray.length;
    }

    public static int rowLength(char[][] cArray) {
        return cArray == null ? 0 : cArray.length;
    }

    public static int rowLength(double[][] dArray) {
        return dArray == null ? 0 : dArray.length;
    }

    public static int rowLength(float[][] fArray) {
        return fArray == null ? 0 : fArray.length;
    }

    public static int rowLength(int[][] nArray) {
        return nArray == null ? 0 : nArray.length;
    }

    public static int rowLength(long[][] lArray) {
        return lArray == null ? 0 : lArray.length;
    }

    public static int rowLength(short[][] sArray) {
        return sArray == null ? 0 : sArray.length;
    }

    public static <T> int rowLength(T[][] TArray) {
        return TArray == null ? 0 : TArray.length;
    }

    public static int colLength(boolean[][] blArray, int n) {
        return blArray == null ? 0 : Arrays.length(blArray[n]);
    }

    public static int colLength(byte[][] byArray, int n) {
        return byArray == null ? 0 : Arrays.length(byArray[n]);
    }

    public static int colLength(char[][] cArray, int n) {
        return cArray == null ? 0 : Arrays.length(cArray[n]);
    }

    public static int colLength(double[][] dArray, int n) {
        return dArray == null ? 0 : Arrays.length(dArray[n]);
    }

    public static int colLength(float[][] fArray, int n) {
        return fArray == null ? 0 : Arrays.length(fArray[n]);
    }

    public static int colLength(int[][] nArray, int n) {
        return nArray == null ? 0 : Arrays.length(nArray[n]);
    }

    public static int colLength(long[][] lArray, int n) {
        return lArray == null ? 0 : Arrays.length(lArray[n]);
    }

    public static int colLength(short[][] sArray, int n) {
        return sArray == null ? 0 : Arrays.length(sArray[n]);
    }

    public static <T> int colLength(T[][] TArray, int n) {
        return TArray == null ? 0 : Arrays.length(TArray[n]);
    }
}

