/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.swing;

import java.awt.Font;
import java.awt.Insets;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class Transcript
extends JScrollPane {
    public static final Font DEFAULT_FONT = new Font("monospaced", 0, 9);
    public static final int DEFAULT_MAX_LINES = 24;
    public static final int DEFAULT_VISIBLE_LINES = 24;
    public static final int DEFAULT_VISIBLE_COLUMNS = 80;
    private static final int MARGIN = 3;
    private static final int INCR = 1024;
    private JTextArea myTextArea;
    private JScrollBar myVerticalScrollBar;
    private int myMaxLines;
    private int myLineCount;
    private int myMaxBytes;
    private int myByteCount;
    private byte[] myBuffer;
    private TranscriptOutputStream myOutputStream;

    public Transcript() {
        this(DEFAULT_FONT, 24, 24, 80);
    }

    public Transcript(Font font) {
        this(font, 24, 24, 80);
    }

    public Transcript(Font font, int n) {
        this(font, n, 24, 80);
    }

    public Transcript(Font font, int n, int n2, int n3) {
        super(22, 31);
        if (font == null) {
            throw new NullPointerException();
        }
        if (n <= 0 || n2 <= 0 || n3 <= 0) {
            throw new IllegalArgumentException();
        }
        this.myTextArea = new JTextArea(n2, n3);
        this.myTextArea.setEditable(false);
        this.myTextArea.setFont(font);
        this.myTextArea.setLineWrap(true);
        this.myTextArea.setWrapStyleWord(false);
        this.myTextArea.setMargin(new Insets(3, 3, 3, 3));
        this.setViewportView(this.myTextArea);
        this.myVerticalScrollBar = this.getVerticalScrollBar();
        this.myMaxLines = n;
        this.myLineCount = 0;
        this.myMaxBytes = 1024;
        this.myByteCount = 0;
        this.myBuffer = new byte[1024];
        this.myOutputStream = new TranscriptOutputStream();
    }

    public JTextArea getTextArea() {
        return this.myTextArea;
    }

    public OutputStream getOutputStream() {
        return this.myOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        TranscriptOutputStream transcriptOutputStream = this.myOutputStream;
        synchronized (transcriptOutputStream) {
            this.myLineCount = 0;
            this.myByteCount = 0;
            this.displayBuffer();
        }
    }

    private void displayBuffer() throws IOException {
        this.myTextArea.setText(new String(this.myBuffer, 0, this.myByteCount));
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Transcript.this.myVerticalScrollBar.setValue(Transcript.this.myVerticalScrollBar.getMaximum());
                }
            });
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            iOException.initCause(exception);
            throw iOException;
        }
    }

    static /* synthetic */ byte[] access$202(Transcript transcript, byte[] byArray) {
        transcript.myBuffer = byArray;
        return byArray;
    }

    private class TranscriptOutputStream
    extends OutputStream {
        private boolean flushed = true;

        private TranscriptOutputStream() {
        }

        public synchronized void write(int n) throws IOException {
            int n2;
            if (Transcript.this.myByteCount == Transcript.this.myMaxBytes) {
                n2 = Transcript.this.myMaxBytes + 1024;
                byte[] byArray = new byte[n2];
                System.arraycopy(Transcript.this.myBuffer, 0, byArray, 0, Transcript.this.myByteCount);
                Transcript.this.myMaxBytes = n2;
                Transcript.access$202(Transcript.this, byArray);
            }
            ((Transcript)Transcript.this).myBuffer[((Transcript)Transcript.this).myByteCount++] = (byte)(n & 0xFF);
            this.flushed = false;
            if (n == 10) {
                if (Transcript.this.myLineCount < Transcript.this.myMaxLines) {
                    ++Transcript.this.myLineCount;
                } else {
                    n2 = 0;
                    while (Transcript.this.myBuffer[n2++] != 10) {
                    }
                    Transcript.this.myByteCount -= n2;
                    System.arraycopy(Transcript.this.myBuffer, n2, Transcript.this.myBuffer, 0, Transcript.this.myByteCount);
                }
                this.flush();
            }
        }

        public synchronized void flush() throws IOException {
            if (!this.flushed) {
                this.flushed = true;
                Transcript.this.displayBuffer();
            }
        }
    }
}

