/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.smp.network;

import edu.rit.io.DoubleMatrixFile;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.text.DecimalFormat;

public class FloydPrint {
    private static final DecimalFormat FMT3 = new DecimalFormat("0.000");

    private FloydPrint() {
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            FloydPrint.usage();
        }
        String string = stringArray[0];
        DoubleMatrixFile doubleMatrixFile = new DoubleMatrixFile();
        DoubleMatrixFile.Reader reader = doubleMatrixFile.prepareToRead(new BufferedInputStream(new FileInputStream(string)));
        reader.read();
        reader.close();
        int n = doubleMatrixFile.getRowCount();
        double[][] dArray = doubleMatrixFile.getMatrix();
        for (int i = 0; i < n; ++i) {
            double[] dArray2 = dArray[i];
            for (int j = 0; j < n; ++j) {
                StringBuilder stringBuilder = new StringBuilder(6);
                stringBuilder.append(FMT3.format(dArray2[j]));
                while (stringBuilder.length() < 6) {
                    stringBuilder.append(' ');
                }
                System.out.print(stringBuilder);
            }
            System.out.println();
        }
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.smp.network.FloydPrint <matrixfile>");
        System.err.println("<matrixfile> = Distance matrix file");
        System.exit(1);
    }
}

