/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.smp.fractal;

import edu.rit.color.HSB;
import edu.rit.image.PJGColorImage;
import edu.rit.image.PJGImage;
import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;

public class MandelbrotSetSmp {
    static int width;
    static int height;
    static double xcenter;
    static double ycenter;
    static double resolution;
    static int maxiter;
    static double gamma;
    static File filename;
    static int xoffset;
    static int yoffset;
    static int[][] matrix;
    static PJGColorImage image;
    static int[] huetable;

    private MandelbrotSetSmp() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        if (stringArray.length != 8) {
            MandelbrotSetSmp.usage();
        }
        width = Integer.parseInt(stringArray[0]);
        height = Integer.parseInt(stringArray[1]);
        xcenter = Double.parseDouble(stringArray[2]);
        ycenter = Double.parseDouble(stringArray[3]);
        resolution = Double.parseDouble(stringArray[4]);
        maxiter = Integer.parseInt(stringArray[5]);
        gamma = Double.parseDouble(stringArray[6]);
        filename = new File(stringArray[7]);
        xoffset = -(width - 1) / 2;
        yoffset = (height - 1) / 2;
        matrix = new int[height][width];
        image = new PJGColorImage(height, width, matrix);
        huetable = new int[maxiter + 1];
        for (int i = 0; i < maxiter; ++i) {
            MandelbrotSetSmp.huetable[i] = HSB.pack((float)Math.pow((double)i / (double)maxiter, gamma), 1.0f, 1.0f);
        }
        MandelbrotSetSmp.huetable[MandelbrotSetSmp.maxiter] = HSB.pack(1.0f, 1.0f, 0.0f);
        long l2 = System.currentTimeMillis();
        new ParallelTeam().execute(new ParallelRegion(){

            public void run() throws Exception {
                this.execute(0, height - 1, new IntegerForLoop(){

                    public void run(int n, int n2) {
                        for (int i = n; i <= n2; ++i) {
                            int[] nArray = matrix[i];
                            double d = ycenter + (double)(yoffset - i) / resolution;
                            for (int j = 0; j < width; ++j) {
                                int n3;
                                double d2 = xcenter + (double)(xoffset + j) / resolution;
                                double d3 = 0.0;
                                double d4 = 0.0;
                                double d5 = 0.0;
                                double d6 = 0.0;
                                double d7 = 0.0;
                                for (n3 = 0; n3 < maxiter && d7 <= 4.0; ++n3) {
                                    d5 = d3 * d3 - d4 * d4 + d2;
                                    d6 = 2.0 * d3 * d4 + d;
                                    d7 = d5 * d5 + d6 * d6;
                                    d3 = d5;
                                    d4 = d6;
                                }
                                nArray[j] = huetable[n3];
                            }
                        }
                    }
                });
            }
        });
        long l3 = System.currentTimeMillis();
        PJGImage.Writer writer = image.prepareToWrite(new BufferedOutputStream(new FileOutputStream(filename)));
        writer.write();
        writer.close();
        long l4 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec pre");
        System.out.println(l3 - l2 + " msec calc");
        System.out.println(l4 - l3 + " msec post");
        System.out.println(l4 - l + " msec total");
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.nt=<K> edu.rit.smp.fractal.MandelbrotSetSmp <width> <height> <xcenter> <ycenter> <resolution> <maxiter> <gamma> <filename>");
        System.err.println("<K> = Number of processors");
        System.err.println("<width> = Image width (pixels)");
        System.err.println("<height> = Image height (pixels)");
        System.err.println("<xcenter> = X coordinate of center point");
        System.err.println("<ycenter> = Y coordinate of center point");
        System.err.println("<resolution> = Pixels per unit");
        System.err.println("<maxiter> = Maximum number of iterations");
        System.err.println("<gamma> = Used to calculate pixel hues");
        System.err.println("<filename> = PJG image file name");
        System.exit(1);
    }
}

