/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.test;

import edu.rit.pj.BarrierAction;
import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerStrideForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;

public class Test03 {
    private Test03() {
    }

    public static void main(String[] stringArray) throws Throwable {
        if (stringArray.length != 4) {
            Test03.usage();
        }
        final int n = Integer.parseInt(stringArray[0]);
        final int n2 = Integer.parseInt(stringArray[1]);
        final int n3 = Integer.parseInt(stringArray[2]);
        final BarrierAction barrierAction = stringArray[3].equals("WAIT") ? BarrierAction.WAIT : (stringArray[3].equals("NO_WAIT") ? BarrierAction.NO_WAIT : null);
        new ParallelTeam().execute(new ParallelRegion(){

            public void run() throws Exception {
                System.out.println("Begin thread " + this.getThreadIndex());
                if (n3 == 1) {
                    this.execute(n, n2, new IntegerForLoop(){

                        public void run(int n, int n2) {
                            for (int i = n; i <= n2; ++i) {
                                System.out.println("i = " + i + ", thread = " + this.getThreadIndex());
                            }
                        }
                    }, barrierAction);
                } else {
                    this.execute(n, n2, n3, new IntegerStrideForLoop(){

                        public void run(int n, int n2, int n3) {
                            for (int i = n; i <= n2; i += n3) {
                                System.out.println("i = " + i + ", thread = " + this.getThreadIndex());
                            }
                        }
                    }, barrierAction);
                }
                System.out.println("End thread " + this.getThreadIndex());
            }
        });
    }

    private static void usage() {
        System.err.println("Usage: java [-Dpj.nt=<K>] [-Dpj.schedule=<schedule>] edu.rit.pj.test.Test03 <lb> <ub> <stride> <wait>");
        System.err.println("<K> = Number of parallel threads");
        System.err.println("<schedule> = Parallel for loop schedule");
        System.err.println("<lb> = Loop index lower bound, inclusive");
        System.err.println("<ub> = Loop index upper bound, inclusive");
        System.err.println("<stride> = Loop stride");
        System.err.println("<wait> = Wait option, WAIT or NO_WAIT");
        System.exit(1);
    }
}

