/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.replica;

import edu.rit.mp.ShortBuf;
import edu.rit.mp.buf.ShortItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.reduction.ShortOp;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class ReplicatedShort
extends Number {
    private ShortOp myOp;
    private AtomicInteger myValue;
    private int myTag;
    private Comm myComm;
    private Receiver myReceiver;

    public ReplicatedShort(ShortOp shortOp) {
        this(shortOp, 0, 0, Comm.world());
    }

    public ReplicatedShort(ShortOp shortOp, short s) {
        this(shortOp, s, 0, Comm.world());
    }

    public ReplicatedShort(ShortOp shortOp, short s, int n) {
        this(shortOp, s, n, Comm.world());
    }

    public ReplicatedShort(ShortOp shortOp, short s, int n, Comm comm) {
        if (shortOp == null) {
            throw new NullPointerException("ReplicatedShort(): op is null");
        }
        if (comm == null) {
            throw new NullPointerException("ReplicatedShort(): comm is null");
        }
        this.myOp = shortOp;
        this.myValue = new AtomicInteger(s);
        this.myTag = n;
        this.myComm = comm;
        this.myReceiver = new Receiver();
        this.myReceiver.setDaemon(true);
        this.myReceiver.start();
    }

    public short get() {
        return (short)this.myValue.get();
    }

    public short reduce(short s) throws IOException {
        short s2;
        short s3;
        while (!this.myValue.compareAndSet(s3 = (short)this.myValue.get(), s2 = this.myOp.op(s3, s))) {
        }
        if (s2 != s3) {
            this.myComm.floodSend(this.myTag, ShortBuf.buffer(s2));
        }
        return s2;
    }

    public String toString() {
        return Short.toString(this.get());
    }

    public int intValue() {
        return this.get();
    }

    public long longValue() {
        return this.get();
    }

    public float floatValue() {
        return this.get();
    }

    public double doubleValue() {
        return this.get();
    }

    private class Receiver
    extends Thread {
        private Receiver() {
        }

        public void run() {
            ShortItemBuf shortItemBuf = ShortBuf.buffer();
            try {
                while (true) {
                    short s;
                    short s2;
                    ReplicatedShort.this.myComm.floodReceive(ReplicatedShort.this.myTag, shortItemBuf);
                    do {
                        s2 = (short)ReplicatedShort.this.myValue.get();
                        s = ReplicatedShort.this.myOp.op(s2, shortItemBuf.item);
                    } while (!ReplicatedShort.this.myValue.compareAndSet(s2, s));
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
                return;
            }
        }
    }
}

