/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.LongOp;
import java.util.concurrent.atomic.AtomicLongArray;

public class SharedLongArray {
    private AtomicLongArray myArray;

    public SharedLongArray(int n) {
        this.myArray = new AtomicLongArray(n);
    }

    public SharedLongArray(long[] lArray) {
        this.myArray = new AtomicLongArray(lArray);
    }

    public int length() {
        return this.myArray.length();
    }

    public long get(int n) {
        return this.myArray.get(n);
    }

    public void set(int n, long l) {
        this.myArray.set(n, l);
    }

    public long getAndSet(int n, long l) {
        return this.myArray.getAndSet(n, l);
    }

    public boolean compareAndSet(int n, long l, long l2) {
        return this.myArray.compareAndSet(n, l, l2);
    }

    public boolean weakCompareAndSet(int n, long l, long l2) {
        return this.myArray.weakCompareAndSet(n, l, l2);
    }

    public long getAndIncrement(int n) {
        return this.myArray.getAndIncrement(n);
    }

    public long getAndDecrement(int n) {
        return this.myArray.getAndDecrement(n);
    }

    public long getAndAdd(int n, long l) {
        return this.myArray.getAndAdd(n, l);
    }

    public long incrementAndGet(int n) {
        return this.myArray.incrementAndGet(n);
    }

    public long decrementAndGet(int n) {
        return this.myArray.decrementAndGet(n);
    }

    public long addAndGet(int n, long l) {
        return this.myArray.addAndGet(n, l);
    }

    public long reduce(int n, long l, LongOp longOp) {
        long l2;
        long l3;
        while (!this.myArray.compareAndSet(n, l3 = this.myArray.get(n), l2 = longOp.op(l3, l))) {
        }
        return l2;
    }

    public void reduce(long[] lArray, LongOp longOp) {
        this.reduce(0, lArray, 0, this.myArray.length(), longOp);
    }

    public void reduce(int n, long[] lArray, int n2, int n3, LongOp longOp) {
        if (n3 < 0 || n < 0 || n + n3 > this.myArray.length() || n2 < 0 || n2 + n3 > lArray.length) {
            throw new IndexOutOfBoundsException();
        }
        while (n3 > 0) {
            long l;
            long l2;
            while (!this.myArray.compareAndSet(n, l2 = this.myArray.get(n), l = longOp.op(l2, lArray[n2]))) {
            }
            ++n;
            ++n2;
            --n3;
        }
    }

    public String toString() {
        return this.myArray.toString();
    }
}

