/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.IntegerOp;
import java.util.concurrent.atomic.AtomicIntegerArray;

public class SharedIntegerArray {
    private AtomicIntegerArray myArray;

    public SharedIntegerArray(int n) {
        this.myArray = new AtomicIntegerArray(n);
    }

    public SharedIntegerArray(int[] nArray) {
        this.myArray = new AtomicIntegerArray(nArray);
    }

    public int length() {
        return this.myArray.length();
    }

    public int get(int n) {
        return this.myArray.get(n);
    }

    public void set(int n, int n2) {
        this.myArray.set(n, n2);
    }

    public int getAndSet(int n, int n2) {
        return this.myArray.getAndSet(n, n2);
    }

    public boolean compareAndSet(int n, int n2, int n3) {
        return this.myArray.compareAndSet(n, n2, n3);
    }

    public boolean weakCompareAndSet(int n, int n2, int n3) {
        return this.myArray.weakCompareAndSet(n, n2, n3);
    }

    public int getAndIncrement(int n) {
        return this.myArray.getAndIncrement(n);
    }

    public int getAndDecrement(int n) {
        return this.myArray.getAndDecrement(n);
    }

    public int getAndAdd(int n, int n2) {
        return this.myArray.getAndAdd(n, n2);
    }

    public int incrementAndGet(int n) {
        return this.myArray.incrementAndGet(n);
    }

    public int decrementAndGet(int n) {
        return this.myArray.decrementAndGet(n);
    }

    public int addAndGet(int n, int n2) {
        return this.myArray.addAndGet(n, n2);
    }

    public int reduce(int n, int n2, IntegerOp integerOp) {
        int n3;
        int n4;
        while (!this.myArray.compareAndSet(n, n4 = this.myArray.get(n), n3 = integerOp.op(n4, n2))) {
        }
        return n3;
    }

    public void reduce(int[] nArray, IntegerOp integerOp) {
        this.reduce(0, nArray, 0, this.myArray.length(), integerOp);
    }

    public void reduce(int n, int[] nArray, int n2, int n3, IntegerOp integerOp) {
        if (n3 < 0 || n < 0 || n + n3 > this.myArray.length() || n2 < 0 || n2 + n3 > nArray.length) {
            throw new IndexOutOfBoundsException();
        }
        while (n3 > 0) {
            int n4;
            int n5;
            while (!this.myArray.compareAndSet(n, n5 = this.myArray.get(n), n4 = integerOp.op(n5, nArray[n2]))) {
            }
            ++n;
            ++n2;
            --n3;
        }
    }

    public String toString() {
        return this.myArray.toString();
    }
}

