/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.FloatOp;
import java.util.concurrent.atomic.AtomicIntegerArray;

public class SharedFloatArray {
    private AtomicIntegerArray myArray;

    public SharedFloatArray(int n) {
        this.myArray = new AtomicIntegerArray(n);
    }

    public SharedFloatArray(float[] fArray) {
        int n = fArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = Float.floatToIntBits(fArray[i]);
        }
        this.myArray = new AtomicIntegerArray(nArray);
    }

    public int length() {
        return this.myArray.length();
    }

    public float get(int n) {
        return Float.intBitsToFloat(this.myArray.get(n));
    }

    public void set(int n, float f) {
        this.myArray.set(n, Float.floatToIntBits(f));
    }

    public float getAndSet(int n, float f) {
        return Float.intBitsToFloat(this.myArray.getAndSet(n, Float.floatToIntBits(f)));
    }

    public boolean compareAndSet(int n, float f, float f2) {
        return this.myArray.compareAndSet(n, Float.floatToIntBits(f), Float.floatToIntBits(f2));
    }

    public boolean weakCompareAndSet(int n, float f, float f2) {
        return this.myArray.weakCompareAndSet(n, Float.floatToIntBits(f), Float.floatToIntBits(f2));
    }

    public float getAndIncrement(int n) {
        float f;
        float f2;
        int n2;
        int n3;
        while (!this.myArray.compareAndSet(n, n3 = this.myArray.get(n), n2 = Float.floatToIntBits(f2 = (f = Float.intBitsToFloat(n3)) + 1.0f))) {
        }
        return f;
    }

    public float getAndDecrement(int n) {
        float f;
        float f2;
        int n2;
        int n3;
        while (!this.myArray.compareAndSet(n, n3 = this.myArray.get(n), n2 = Float.floatToIntBits(f2 = (f = Float.intBitsToFloat(n3)) - 1.0f))) {
        }
        return f;
    }

    public float getAndAdd(int n, float f) {
        float f2;
        float f3;
        int n2;
        int n3;
        while (!this.myArray.compareAndSet(n, n3 = this.myArray.get(n), n2 = Float.floatToIntBits(f3 = (f2 = Float.intBitsToFloat(n3)) + f))) {
        }
        return f2;
    }

    public float incrementAndGet(int n) {
        float f;
        float f2;
        int n2;
        int n3;
        while (!this.myArray.compareAndSet(n, n3 = this.myArray.get(n), n2 = Float.floatToIntBits(f2 = (f = Float.intBitsToFloat(n3)) + 1.0f))) {
        }
        return f2;
    }

    public float decrementAndGet(int n) {
        float f;
        float f2;
        int n2;
        int n3;
        while (!this.myArray.compareAndSet(n, n3 = this.myArray.get(n), n2 = Float.floatToIntBits(f2 = (f = Float.intBitsToFloat(n3)) - 1.0f))) {
        }
        return f2;
    }

    public float addAndGet(int n, float f) {
        float f2;
        float f3;
        int n2;
        int n3;
        while (!this.myArray.compareAndSet(n, n3 = this.myArray.get(n), n2 = Float.floatToIntBits(f3 = (f2 = Float.intBitsToFloat(n3)) + f))) {
        }
        return f3;
    }

    public float reduce(int n, float f, FloatOp floatOp) {
        float f2;
        float f3;
        int n2;
        int n3;
        while (!this.myArray.compareAndSet(n, n3 = this.myArray.get(n), n2 = Float.floatToIntBits(f3 = floatOp.op(f2 = Float.intBitsToFloat(n3), f)))) {
        }
        return f3;
    }

    public void reduce(float[] fArray, FloatOp floatOp) {
        this.reduce(0, fArray, 0, this.myArray.length(), floatOp);
    }

    public void reduce(int n, float[] fArray, int n2, int n3, FloatOp floatOp) {
        if (n3 < 0 || n < 0 || n + n3 > this.myArray.length() || n2 < 0 || n2 + n3 > fArray.length) {
            throw new IndexOutOfBoundsException();
        }
        while (n3 > 0) {
            float f;
            float f2;
            int n4;
            int n5;
            while (!this.myArray.compareAndSet(n, n5 = this.myArray.get(n), n4 = Float.floatToIntBits(f2 = floatOp.op(f = Float.intBitsToFloat(n5), fArray[n2])))) {
            }
            ++n;
            ++n2;
            --n3;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n = this.myArray.length();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.get(i));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

