/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.pj.ItemGenerator;
import edu.rit.pj.ParallelConstruct;
import edu.rit.pj.ParallelSection;
import edu.rit.pj.Spinner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParallelIteration<T>
extends ParallelConstruct {
    ItemGenerator<T> myItemGenerator;
    int myOrderedIndex;

    public void start() throws Exception {
    }

    public abstract void run(T var1) throws Exception;

    public void finish() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ordered(ParallelSection parallelSection) throws Exception {
        if (parallelSection == null) {
            throw new IllegalStateException("ParallelIteration.ordered(): Parallel section is null");
        }
        if (this.myTeam == null) {
            throw new IllegalStateException("ParallelIteration.ordered(): No parallel team executing");
        }
        if (this.myItemGenerator.myOrderedIndex != this.myOrderedIndex) {
            Spinner spinner = new Spinner();
            while (this.myItemGenerator.myOrderedIndex != this.myOrderedIndex) {
                spinner.spin();
            }
        }
        parallelSection.myTeam = this.myTeam;
        try {
            parallelSection.run();
        }
        finally {
            parallelSection.myTeam = null;
            ++this.myOrderedIndex;
            this.myItemGenerator.myOrderedIndex = this.myOrderedIndex;
        }
    }

    public final void stopLoop() {
        if (this.myTeam == null) {
            throw new IllegalStateException("ParallelIteration.stopLoop(): No parallel team executing");
        }
        this.myItemGenerator.myBreak = true;
    }

    void commonRun(int n, T t) throws Exception {
        this.myOrderedIndex = n;
        this.run(t);
    }
}

