/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.ObjectBuf;
import edu.rit.mp.buf.ObjectMatrixReductionBuf;
import edu.rit.pj.reduction.ObjectOp;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Arrays;
import edu.rit.util.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectMatrixBuf<T>
extends ObjectBuf<T> {
    T[][] myMatrix;
    Range myRowRange;
    Range myColRange;
    int myLowerRow;
    int myRowCount;
    int myRowStride;
    int myLowerCol;
    int myColCount;
    int myColStride;

    public ObjectMatrixBuf(T[][] TArray, Range range, Range range2) {
        super(range.length() * range2.length());
        this.myMatrix = TArray;
        this.myRowRange = range;
        this.myColRange = range2;
        this.myLowerRow = range.lb();
        this.myRowCount = range.length();
        this.myRowStride = range.stride();
        this.myLowerCol = range2.lb();
        this.myColCount = range2.length();
        this.myColStride = range2.stride();
    }

    @Override
    public T get(int n) {
        return this.myMatrix[this.i2r(n) * this.myRowStride + this.myLowerRow][this.i2c(n) * this.myColStride + this.myLowerCol];
    }

    @Override
    public void put(int n, T t) {
        this.myMatrix[this.i2r((int)n) * this.myRowStride + this.myLowerRow][this.i2c((int)n) * this.myColStride + this.myLowerCol] = t;
        this.reset();
    }

    @Override
    public void copy(Buf buf) {
        if (buf != this) {
            if (buf instanceof ObjectMatrixBuf) {
                ObjectMatrixBuf objectMatrixBuf = (ObjectMatrixBuf)buf;
                Arrays.copy(objectMatrixBuf.myMatrix, objectMatrixBuf.myRowRange, objectMatrixBuf.myColRange, this.myMatrix, this.myRowRange, this.myColRange);
                this.reset();
            } else {
                ObjectBuf.defaultCopy((ObjectBuf)buf, this);
                this.reset();
            }
        }
    }

    @Override
    public Buf getReductionBuf(Op op) {
        return new ObjectMatrixReductionBuf<T>(this.myMatrix, this.myRowRange, this.myColRange, (ObjectOp)op, this);
    }

    int i2r(int n) {
        return this.myColCount == 0 ? n : n / this.myColCount;
    }

    int i2c(int n) {
        return this.myColCount == 0 ? 0 : n % this.myColCount;
    }
}

