/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.DoubleBuf;
import edu.rit.mp.buf.DoubleItemBuf;
import edu.rit.pj.reduction.DoubleOp;
import edu.rit.pj.reduction.Op;
import java.nio.ByteBuffer;

class DoubleItemReductionBuf
extends DoubleBuf {
    DoubleItemBuf myBuf;
    DoubleOp myOp;

    public DoubleItemReductionBuf(DoubleItemBuf doubleItemBuf, DoubleOp doubleOp) {
        super(1);
        if (doubleOp == null) {
            throw new NullPointerException("DoubleItemReductionBuf(): op is null");
        }
        this.myBuf = doubleItemBuf;
        this.myOp = doubleOp;
    }

    public double get(int n) {
        return this.myBuf.item;
    }

    public void put(int n, double d) {
        this.myBuf.item = this.myOp.op(this.myBuf.item, d);
    }

    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    protected int sendItems(int n, ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() >= 8) {
            byteBuffer.putDouble(this.myBuf.item);
            return 1;
        }
        return 0;
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        if (n2 >= 1 && byteBuffer.remaining() >= 8) {
            this.myBuf.item = this.myOp.op(this.myBuf.item, byteBuffer.getDouble());
            return 1;
        }
        return 0;
    }
}

