/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.ChannelGroup;
import edu.rit.mp.IORequest;
import edu.rit.mp.IORequestList;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;

public abstract class Channel {
    ChannelGroup myChannelGroup;
    IORequestList myIORequestList;
    Object myInfo;
    int myWriteState = 0;
    static final int WRITE_OPEN = 0;
    static final int WRITE_CLOSED = 1;
    int myReadState = 0;
    static final int READ_OPEN = 0;
    static final int READ_CLOSED = 1;

    Channel(ChannelGroup channelGroup) {
        this.myChannelGroup = channelGroup;
        this.myIORequestList = channelGroup.myIORequestList;
    }

    public ChannelGroup getChannelGroup() {
        return this.myChannelGroup;
    }

    public abstract int nearEndChannelGroupId();

    public abstract int farEndChannelGroupId();

    public abstract InetSocketAddress nearEndAddress();

    public abstract InetSocketAddress farEndAddress();

    public Object info() {
        return this.myInfo;
    }

    public void info(Object object) {
        this.myInfo = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ChannelGroup channelGroup = this.myChannelGroup;
        synchronized (channelGroup) {
            Channel channel = this;
            synchronized (channel) {
                this.myChannelGroup.removeChannel(this);
                this.myWriteState = 1;
                this.myReadState = 1;
                this.subclassClose();
            }
        }
    }

    protected void finalize() {
        this.close();
    }

    public String toString() {
        return this.getClass().getName() + "(near=" + this.nearEndAddress() + ",far=" + this.farEndAddress() + ")";
    }

    public void dump(PrintStream printStream, String string) {
        printStream.println(string + this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this)));
        printStream.println(string + "myChannelGroup = " + this.myChannelGroup);
        printStream.println(string + "myIORequestList = " + this.myIORequestList);
        printStream.println(string + "myInfo = " + this.myInfo);
        printStream.println(string + "myWriteState = " + (this.myWriteState == 0 ? "WRITE_OPEN" : "WRITE_CLOSED"));
        printStream.println(string + "myReadState = " + (this.myReadState == 0 ? "READ_OPEN" : "READ_CLOSED"));
        printStream.println(string + "nearEndChannelGroupId() = " + this.nearEndChannelGroupId());
        printStream.println(string + "farEndChannelGroupId() = " + this.farEndChannelGroupId());
        printStream.println(string + "nearEndAddress() = " + this.nearEndAddress());
        printStream.println(string + "farEndAddress() = " + this.farEndAddress());
    }

    void start() {
    }

    abstract void send(IORequest var1) throws IOException;

    void subclassClose() {
    }
}

