/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.hyb.monte;

import edu.rit.mp.LongBuf;
import edu.rit.mp.buf.LongItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.LongForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.reduction.LongOp;
import edu.rit.pj.reduction.SharedLong;
import edu.rit.util.LongRange;
import edu.rit.util.Random;

public class PiHyb {
    static Comm world;
    static int size;
    static int rank;
    static long seed;
    static long N;
    static long lb;
    static long ub;
    static SharedLong count;

    private PiHyb() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = -System.currentTimeMillis();
        Comm.init(stringArray);
        world = Comm.world();
        size = world.size();
        rank = world.rank();
        if (stringArray.length != 2) {
            PiHyb.usage();
        }
        seed = Long.parseLong(stringArray[0]);
        N = Long.parseLong(stringArray[1]);
        LongRange longRange = new LongRange(0L, N - 1L).subrange(size, rank);
        lb = longRange.lb();
        ub = longRange.ub();
        count = new SharedLong(0L);
        new ParallelTeam().execute(new ParallelRegion(){

            public void run() throws Exception {
                this.execute(lb, ub, new LongForLoop(){
                    Random prng_thread = Random.getInstance(seed);
                    long count_thread = 0L;
                    long pad0;
                    long pad1;
                    long pad2;
                    long pad3;
                    long pad4;
                    long pad5;
                    long pad6;
                    long pad7;
                    long pad8;
                    long pad9;
                    long pada;
                    long padb;
                    long padc;
                    long padd;
                    long pade;
                    long padf;

                    public void run(long l, long l2) {
                        this.prng_thread.setSeed(seed);
                        this.prng_thread.skip(2L * l);
                        for (long i = l; i <= l2; ++i) {
                            double d;
                            double d2 = this.prng_thread.nextDouble();
                            if (!(d2 * d2 + (d = this.prng_thread.nextDouble()) * d <= 1.0)) continue;
                            ++this.count_thread;
                        }
                    }

                    public void finish() {
                        count.addAndGet(this.count_thread);
                    }
                });
            }
        });
        LongItemBuf longItemBuf = LongBuf.buffer(count.longValue());
        world.reduce(0, longItemBuf, LongOp.SUM);
        l += System.currentTimeMillis();
        if (rank == 0) {
            System.out.println("pi = 4 * " + longItemBuf.item + " / " + N + " = " + 4.0 * (double)longItemBuf.item / (double)N);
        }
        System.out.println(l + " msec " + rank);
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.np=<Kp> -Dpj.nt=<Kt> edu.rit.hyb.monte.PiHyb <seed> <N>");
        System.err.println("<Kp> = Number of parallel processes");
        System.err.println("<Kt> = Number of parallel threads per process");
        System.err.println("<seed> = Random seed");
        System.err.println("<N> = Number of random points");
        System.exit(1);
    }
}

