/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.draw.item;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Arrow
implements Externalizable {
    public static final Arrow NONE = new Arrow(0);
    public static final Arrow SOLID = new Arrow(1);
    public static final Arrow OPEN = new Arrow(2);
    private static final long serialVersionUID = 7782719680651946887L;
    private static final Info[] theArrowInfo;
    private int myKind;

    public Arrow() {
        this(0);
    }

    private Arrow(int n) {
        this.myKind = n;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.myKind);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.myKind = objectInput.readInt();
        if (0 > this.myKind || this.myKind >= theArrowInfo.length) {
            throw new InvalidObjectException("Invalid arrow (kind = " + this.myKind + ")");
        }
    }

    public void draw(Graphics2D graphics2D, float f, double d, double d2, double d3) {
        Info info;
        Info info2 = info = 0 <= this.myKind && this.myKind < theArrowInfo.length ? theArrowInfo[this.myKind] : null;
        if (info != null && info.thePath != null) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(d, d2);
            affineTransform.rotate(d3);
            affineTransform.scale(f, f);
            Shape shape = info.thePath.createTransformedShape(affineTransform);
            if (info.isFilled) {
                graphics2D.fill(shape);
            }
            graphics2D.draw(shape);
        }
    }

    static {
        float f = (float)((1.0 + Math.sqrt(5.0)) / 2.0);
        theArrowInfo = new Info[3];
        Arrow.theArrowInfo[0] = new Info(null, false);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(-8.0f * f, -4.0f);
        generalPath.lineTo(0.0f, 0.0f);
        generalPath.lineTo(-8.0f * f, 4.0f);
        generalPath.closePath();
        Arrow.theArrowInfo[1] = new Info(generalPath, true);
        generalPath = new GeneralPath();
        generalPath.moveTo(-8.0f * f, -4.0f);
        generalPath.lineTo(0.0f, 0.0f);
        generalPath.lineTo(-8.0f * f, 4.0f);
        Arrow.theArrowInfo[2] = new Info(generalPath, false);
    }

    private static class Info {
        public GeneralPath thePath;
        public boolean isFilled;

        public Info(GeneralPath generalPath, boolean bl) {
            this.thePath = generalPath;
            this.isFilled = bl;
        }
    }
}

