/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.compbio.phyl;

import edu.rit.compbio.phyl.DnaSequence;
import edu.rit.compbio.phyl.DnaSequenceTree;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DnaSequenceList
implements Iterable<DnaSequence> {
    DnaSequence[] mySequence;
    private boolean[] isInformative;
    private int nInformative;
    private int nChanges;
    private static String[] padding = new String[]{"          ", "         ", "        ", "       ", "      ", "     ", "    ", "   ", "  ", " "};

    DnaSequenceList() {
    }

    public DnaSequenceList(DnaSequenceList dnaSequenceList) {
        int n = dnaSequenceList.mySequence.length;
        this.mySequence = new DnaSequence[n];
        for (int i = 0; i < n; ++i) {
            this.mySequence[i] = new DnaSequence(dnaSequenceList.mySequence[i]);
        }
        if (dnaSequenceList.isInformative != null) {
            this.isInformative = (boolean[])dnaSequenceList.isInformative.clone();
        }
        this.nInformative = dnaSequenceList.nInformative;
        this.nChanges = dnaSequenceList.nChanges;
    }

    public int length() {
        return this.mySequence.length;
    }

    public DnaSequence seq(int n) {
        return this.mySequence[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DnaSequenceList read(File file) throws IOException {
        Scanner scanner = new Scanner(file);
        try {
            int n;
            if (!scanner.hasNextLine()) {
                throw new IOException("DnaSequenceList.read(\"" + file + "\"): " + "Empty file");
            }
            Scanner scanner2 = new Scanner(scanner.nextLine());
            if (!scanner2.hasNextInt()) {
                throw new IOException("DnaSequenceList.read(\"" + file + "\"): " + "Number of species invalid or missing");
            }
            int n2 = scanner2.nextInt();
            if (n2 < 2) {
                throw new IOException("DnaSequenceList.read(\"" + file + "\"): " + "Number of species must be >= 2");
            }
            if (!scanner2.hasNextInt()) {
                throw new IOException("DnaSequenceList.read(\"" + file + "\"): " + "Number of sites invalid or missing");
            }
            int n3 = scanner2.nextInt();
            if (n3 < 1) {
                throw new IOException("DnaSequenceList.read(\"" + file + "\"): " + "Number of sites must be >= 1");
            }
            DnaSequenceList dnaSequenceList = new DnaSequenceList();
            dnaSequenceList.mySequence = new DnaSequence[n2];
            int[] nArray = new int[n2];
            block22: while (true) {
                n = 0;
                while (true) {
                    if (n >= n2) continue block22;
                    if (!scanner.hasNextLine()) {
                        if (n == 0 && nArray[n] != 0) break block22;
                        throw new IOException("DnaSequenceList.read(\"" + file + "\"): " + "Missing a line of sequence data for species " + (n + 1));
                    }
                    String string = scanner.nextLine();
                    if (string.trim().equals("")) {
                        --n;
                    } else {
                        if (nArray[n] == 0) {
                            if (string.length() < 10) {
                                throw new IOException("DnaSequenceList.read(\"" + file + "\"): " + "Name must be 10 characters for species " + (n + 1));
                            }
                            dnaSequenceList.mySequence[n] = new DnaSequence(n3, 0, string.substring(0, 10).trim());
                            string = string.substring(10);
                        }
                        int n4 = string.length();
                        byte[] byArray = dnaSequenceList.mySequence[n].mySites;
                        byte[] byArray2 = dnaSequenceList.mySequence[0].mySites;
                        int n5 = nArray[n];
                        block24: for (int i = 0; i < n4; ++i) {
                            switch (string.charAt(i)) {
                                case '-': 
                                case 'O': 
                                case 'o': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 0;
                                    ++n5;
                                    continue block24;
                                }
                                case 'A': 
                                case 'a': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 1;
                                    ++n5;
                                    continue block24;
                                }
                                case 'C': 
                                case 'c': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 2;
                                    ++n5;
                                    continue block24;
                                }
                                case 'M': 
                                case 'm': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 3;
                                    ++n5;
                                    continue block24;
                                }
                                case 'G': 
                                case 'g': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 4;
                                    ++n5;
                                    continue block24;
                                }
                                case 'R': 
                                case 'r': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 5;
                                    ++n5;
                                    continue block24;
                                }
                                case 'S': 
                                case 's': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 6;
                                    ++n5;
                                    continue block24;
                                }
                                case 'V': 
                                case 'v': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 7;
                                    ++n5;
                                    continue block24;
                                }
                                case 'T': 
                                case 't': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 8;
                                    ++n5;
                                    continue block24;
                                }
                                case 'W': 
                                case 'w': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 9;
                                    ++n5;
                                    continue block24;
                                }
                                case 'Y': 
                                case 'y': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 10;
                                    ++n5;
                                    continue block24;
                                }
                                case 'H': 
                                case 'h': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 11;
                                    ++n5;
                                    continue block24;
                                }
                                case 'K': 
                                case 'k': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 12;
                                    ++n5;
                                    continue block24;
                                }
                                case 'D': 
                                case 'd': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 13;
                                    ++n5;
                                    continue block24;
                                }
                                case 'B': 
                                case 'b': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 14;
                                    ++n5;
                                    continue block24;
                                }
                                case '?': 
                                case 'N': 
                                case 'X': 
                                case 'n': 
                                case 'x': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 15;
                                    ++n5;
                                    continue block24;
                                }
                                case '.': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    if (n == 0) {
                                        throw new IOException("DnaSequenceList.read(\"" + file + "\"): " + "'.' not allowed in species 1");
                                    }
                                    if (n5 >= nArray[0]) {
                                        throw new IOException("DnaSequenceList.read(\"" + file + "\"): " + "'.' in species " + (n + 1) + " has no corresponding site in species 1");
                                    }
                                    byArray[n5] = byArray2[n5];
                                    ++n5;
                                }
                            }
                        }
                        nArray[n] = n5;
                    }
                    ++n;
                }
                break;
            }
            for (n = 0; n < n2; ++n) {
                if (nArray[n] < n3) {
                    throw new IOException("DnaSequenceList.read(\"" + file + "\"): " + "Too few sites for species " + (n + 1));
                }
                if (nArray[n] <= n3) continue;
                throw new IOException("DnaSequenceList.read(\"" + file + "\"): " + "Too many sites for species " + (n + 1));
            }
            DnaSequenceList dnaSequenceList2 = dnaSequenceList;
            return dnaSequenceList2;
        }
        finally {
            scanner.close();
        }
    }

    private static void verifyCount(int n, int n2, File file, int n3) throws IOException {
        if (n >= n2) {
            throw new IOException("DnaSequenceList.read(\"" + file + "\"): " + "Too many sites for species " + (n3 + 1));
        }
    }

    public void write(File file) throws IOException {
        this.write(file, 70, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, int n, boolean bl, boolean bl2) throws IOException {
        PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
        try {
            this.write(printStream, n, bl, bl2);
        }
        finally {
            printStream.close();
        }
    }

    public void write(PrintStream printStream, int n, boolean bl, boolean bl2) throws IOException {
        if (n <= 10) {
            throw new IllegalArgumentException("DnaSequenceList.write(): sites = " + n + " illegal");
        }
        if (bl2) {
            this.computeInformativeSites();
        }
        int n2 = this.mySequence.length;
        int n3 = this.mySequence[0].myLength;
        printStream.print(n2);
        printStream.print(' ');
        printStream.print(n3);
        printStream.println();
        int n4 = 0;
        int n5 = Math.min(n - 10, n3);
        byte[] byArray = this.mySequence[0].mySites;
        while (n4 < n3) {
            for (int i = 0; i < n2; ++i) {
                byte[] byArray2 = this.mySequence[i].mySites;
                if (n4 == 0) {
                    printStream.print(DnaSequenceList.padName(this.mySequence[i].myName));
                }
                for (int j = n4; j < n5; ++j) {
                    if ((n4 == 0 || j > n4) && j % 10 == 0) {
                        printStream.print(' ');
                    }
                    if (bl && i > 0 && byArray2[j] == byArray[j]) {
                        this.printSite(printStream, j, '.', bl2);
                        continue;
                    }
                    this.printSite(printStream, j, DnaSequence.state2char[byArray2[j]], bl2);
                }
                printStream.println();
            }
            printStream.println();
            n4 = n5;
            n5 = Math.min(n5 + n, n3);
        }
        if (printStream.checkError()) {
            throw new IOException("DnaSequenceList.write(): I/O error");
        }
    }

    private static String padName(String string) {
        if (string == null) {
            return "<unnamed> ";
        }
        int n = string.length();
        if (n == 10) {
            return string;
        }
        if (n > 10) {
            return string.substring(0, 10);
        }
        return string + padding[n];
    }

    private void printSite(PrintStream printStream, int n, char c, boolean bl) {
        if (bl && this.isInformative[n]) {
            printStream.print("<B>");
            printStream.print(c);
            printStream.print("</B>");
        } else {
            printStream.print(c);
        }
    }

    public void truncate(int n) {
        if (n < this.mySequence.length) {
            DnaSequence[] dnaSequenceArray = new DnaSequence[n];
            System.arraycopy(this.mySequence, 0, dnaSequenceArray, 0, n);
            this.mySequence = dnaSequenceArray;
        }
    }

    public int exciseUninformativeSites() {
        int n = this.mySequence.length;
        int n2 = this.mySequence[0].length();
        this.computeInformativeSites();
        for (int i = 0; i < n; ++i) {
            byte[] byArray = this.mySequence[i].mySites;
            this.mySequence[i] = new DnaSequence(this.nInformative, this.mySequence[i].myScore, this.mySequence[i].myName);
            byte[] byArray2 = this.mySequence[i].mySites;
            int n3 = 0;
            for (int j = 0; j < n2; ++j) {
                if (!this.isInformative[j]) continue;
                byArray2[n3++] = byArray[j];
            }
        }
        this.isInformative = new boolean[this.nInformative];
        Arrays.fill(this.isInformative, true);
        return this.nChanges;
    }

    public int informativeSiteCount() {
        this.computeInformativeSites();
        return this.nInformative;
    }

    public int[] countAbsentStates() {
        int n;
        byte[] byArray;
        int n2;
        int n3 = this.mySequence.length;
        int n4 = this.mySequence[0].length();
        int[] nArray = new int[n3];
        byte[] byArray2 = new byte[n4];
        for (n2 = 0; n2 < n3; ++n2) {
            byArray = this.mySequence[n2].mySites;
            for (n = 0; n < n4; ++n) {
                int n5 = n;
                byArray2[n5] = (byte)(byArray2[n5] | byArray[n]);
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            byArray = this.mySequence[n2].mySites;
            n = 0;
            for (int i = 0; i < n4; ++i) {
                int n6 = i;
                byArray2[n6] = (byte)(byArray2[n6] & ~byArray[i]);
                n += DnaSequence.state2bitCount[byArray2[i]];
            }
            nArray[n2] = n;
        }
        return nArray;
    }

    public DnaSequenceTree toTree(int[] nArray) {
        int n = this.mySequence.length;
        DnaSequenceTree dnaSequenceTree = new DnaSequenceTree(2 * n - 1);
        for (int i = 0; i < n; ++i) {
            dnaSequenceTree.add(nArray[i], this.mySequence[i]);
        }
        return dnaSequenceTree;
    }

    @Override
    public Iterator<DnaSequence> iterator() {
        return new Iterator<DnaSequence>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < DnaSequenceList.this.mySequence.length;
            }

            @Override
            public DnaSequence next() {
                return DnaSequenceList.this.mySequence[this.i++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void computeInformativeSites() {
        if (this.isInformative != null) {
            return;
        }
        int n = this.mySequence.length;
        int n2 = this.mySequence[0].length();
        this.isInformative = new boolean[n2];
        this.nInformative = 0;
        this.nChanges = 0;
        int[] nArray = new int[16];
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4;
            Arrays.fill(nArray, 0);
            for (n4 = 0; n4 < n; ++n4) {
                byte by = this.mySequence[n4].mySites[i];
                nArray[by] = nArray[by] + 1;
            }
            n4 = 0;
            for (n3 = 0; n3 < 16; ++n3) {
                if (nArray[n3] < 2) continue;
                ++n4;
            }
            if (n4 >= 2) {
                this.isInformative[i] = true;
                ++this.nInformative;
                continue;
            }
            this.isInformative[i] = false;
            for (n3 = 0; n3 < 16; ++n3) {
                if (nArray[n3] <= 0) continue;
                ++this.nChanges;
            }
            --this.nChanges;
        }
    }
}

