/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.timing;

import edu.rit.mp.DoubleBuf;
import edu.rit.pj.Comm;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Date;

public class TimeSendDouble {
    private static final DecimalFormat FMT3 = new DecimalFormat("0.00E0");
    static Comm world;
    static int size;
    static int rank;
    static int reps;
    static int numn;
    static int[] n;

    private TimeSendDouble() {
    }

    public static void main(String[] stringArray) throws Exception {
        block9: {
            int n;
            block8: {
                Comm.init(stringArray);
                world = Comm.world();
                size = world.size();
                rank = world.rank();
                if (stringArray.length < 2) {
                    TimeSendDouble.usage();
                }
                reps = Integer.parseInt(stringArray[0]);
                numn = stringArray.length - 1;
                TimeSendDouble.n = new int[numn];
                for (n = 0; n < numn; ++n) {
                    TimeSendDouble.n[n] = Integer.parseInt(stringArray[n + 1]);
                }
                if (rank != 0) break block8;
                System.out.println("java -Dpj.np=2 edu.rit.clu.timing.TimeSendDouble " + reps);
                System.out.println(new Date());
                System.out.println("n\ttime1\ttime2\tSend time (sec)");
                for (n = 0; n < numn; ++n) {
                    int n2 = TimeSendDouble.n[n];
                    double[] dArray = new double[n2];
                    DoubleBuf doubleBuf = DoubleBuf.buffer(dArray);
                    long l = -System.currentTimeMillis();
                    for (int i = 0; i < reps; ++i) {
                        TimeSendDouble.fill(n2, dArray, doubleBuf);
                    }
                    l += System.currentTimeMillis();
                    long l2 = -System.currentTimeMillis();
                    for (int i = 0; i < reps; ++i) {
                        TimeSendDouble.fillSendReceive(n2, dArray, doubleBuf);
                    }
                    double d = (double)((l2 += System.currentTimeMillis()) - l) / (double)reps / 2000.0;
                    System.out.print(n2);
                    System.out.print('\t');
                    System.out.print(l);
                    System.out.print('\t');
                    System.out.print(l2);
                    System.out.print('\t');
                    System.out.print(FMT3.format(d));
                    System.out.println();
                }
                break block9;
            }
            if (rank != 1) break block9;
            for (n = 0; n < numn; ++n) {
                int n3;
                int n4 = TimeSendDouble.n[n];
                double[] dArray = new double[n4];
                DoubleBuf doubleBuf = DoubleBuf.buffer(dArray);
                for (n3 = 0; n3 < reps; ++n3) {
                    TimeSendDouble.fill(n4, dArray, doubleBuf);
                }
                for (n3 = 0; n3 < reps; ++n3) {
                    TimeSendDouble.fillReceiveSend(n4, dArray, doubleBuf);
                }
            }
        }
    }

    private static void fill(int n, double[] dArray, DoubleBuf doubleBuf) {
        for (int i = 0; i < n; ++i) {
            dArray[i] = i;
        }
    }

    private static void fillSendReceive(int n, double[] dArray, DoubleBuf doubleBuf) throws IOException {
        for (int i = 0; i < n; ++i) {
            dArray[i] = i;
        }
        world.send(1, doubleBuf);
        world.receive(1, doubleBuf);
    }

    private static void fillReceiveSend(int n, double[] dArray, DoubleBuf doubleBuf) throws IOException {
        for (int i = 0; i < n; ++i) {
            dArray[i] = i;
        }
        world.receive(0, doubleBuf);
        world.send(0, doubleBuf);
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.np=2 edu.rit.clu.timing.TimeSendDouble <reps> <n1> [<n2> ...]");
        System.err.println("<reps> = Number of repetitions for each value of <n>");
        System.err.println("<n1> = First value of <n>");
        System.err.println("<n2> = Second value of <n> . . .");
        System.exit(1);
    }
}

