/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.fractal;

import edu.rit.pj.Comm;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;

public class MSHistogramSeq {
    static int width;
    static int height;
    static double xcenter;
    static double ycenter;
    static double resolution;
    static int maxiter;
    static File outfile;
    static int xoffset;
    static int yoffset;
    static int[] histogram;

    private MSHistogramSeq() {
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        Comm.init(stringArray);
        long l = System.currentTimeMillis();
        if (stringArray.length != 7) {
            MSHistogramSeq.usage();
        }
        width = Integer.parseInt(stringArray[0]);
        height = Integer.parseInt(stringArray[1]);
        xcenter = Double.parseDouble(stringArray[2]);
        ycenter = Double.parseDouble(stringArray[3]);
        resolution = Double.parseDouble(stringArray[4]);
        maxiter = Integer.parseInt(stringArray[5]);
        outfile = new File(stringArray[6]);
        xoffset = -(width - 1) / 2;
        yoffset = (height - 1) / 2;
        histogram = new int[maxiter + 1];
        long l2 = System.currentTimeMillis();
        for (int i = 0; i < height; ++i) {
            double d = ycenter + (double)(yoffset - i) / resolution;
            for (n = 0; n < width; ++n) {
                int n2;
                double d2 = xcenter + (double)(xoffset + n) / resolution;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = 0.0;
                double d7 = 0.0;
                for (n2 = 0; n2 < maxiter && d7 <= 4.0; ++n2) {
                    d5 = d3 * d3 - d4 * d4 + d2;
                    d6 = 2.0 * d3 * d4 + d;
                    d7 = d5 * d5 + d6 * d6;
                    d3 = d5;
                    d4 = d6;
                }
                int n3 = n2;
                histogram[n3] = histogram[n3] + 1;
            }
        }
        long l3 = System.currentTimeMillis();
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(outfile)));
        for (n = 0; n <= maxiter; ++n) {
            printWriter.print(n);
            printWriter.print('\t');
            printWriter.print(histogram[n]);
            printWriter.println();
        }
        printWriter.close();
        long l4 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec pre");
        System.out.println(l3 - l2 + " msec calc");
        System.out.println(l4 - l3 + " msec post");
        System.out.println(l4 - l + " msec total");
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.clu.fractal.MSHistogramSeq <width> <height> <xcenter> <ycenter> <resolution> <maxiter> <outfile>");
        System.err.println("<width> = Image width (pixels)");
        System.err.println("<height> = Image height (pixels)");
        System.err.println("<xcenter> = X coordinate of center point");
        System.err.println("<ycenter> = Y coordinate of center point");
        System.err.println("<resolution> = Pixels per unit");
        System.err.println("<maxiter> = Maximum number of iterations");
        System.err.println("<outfile> = Output file name");
        System.exit(1);
    }
}

