/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.antimatter;

import edu.rit.clu.antimatter.TrapFrame;
import edu.rit.clu.antimatter.TrapPanel;
import edu.rit.util.Random;
import edu.rit.vector.Vector2D;

public class AntiprotonAni {
    static final double QP = 3.0;
    static final double B = 3.0;
    static long seed;
    static double R;
    static double dt;
    static int steps;
    static int N;
    static Vector2D[] a;
    static Vector2D[] v;
    static Vector2D[] p;
    static Vector2D totalMV;

    private AntiprotonAni() {
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 5) {
            AntiprotonAni.usage();
        }
        seed = Long.parseLong(stringArray[0]);
        R = Double.parseDouble(stringArray[1]);
        dt = Double.parseDouble(stringArray[2]);
        steps = Integer.parseInt(stringArray[3]);
        N = Integer.parseInt(stringArray[4]);
        double d = 0.5 * dt * dt;
        double d2 = 9.0;
        double d3 = 9.0;
        Vector2D vector2D = new Vector2D();
        Random random = Random.getInstance(seed);
        a = new Vector2D[N];
        v = new Vector2D[N];
        p = new Vector2D[N];
        for (int i = 0; i < N; ++i) {
            AntiprotonAni.a[i] = new Vector2D();
            AntiprotonAni.v[i] = new Vector2D();
            AntiprotonAni.p[i] = new Vector2D(random.nextDouble() * R / 2.0 + R / 4.0, random.nextDouble() * R / 2.0 + R / 4.0);
        }
        totalMV = new Vector2D();
        TrapFrame trapFrame = new TrapFrame("AntiprotonAni", p, R);
        TrapPanel trapPanel = trapFrame.getTrapPanel();
        trapFrame.setDefaultCloseOperation(3);
        trapFrame.setVisible(true);
        block1: while (true) {
            int n;
            totalMV.clear();
            for (n = 0; n < N; ++n) {
                totalMV.add(v[n]);
            }
            trapFrame.setTotalMomentum(totalMV.mag());
            trapPanel.step();
            n = 0;
            while (true) {
                Vector2D vector2D2;
                Vector2D vector2D3;
                int n2;
                if (n >= steps) continue block1;
                for (n2 = 0; n2 < N; ++n2) {
                    double d4;
                    int n3;
                    vector2D3 = a[n2];
                    vector2D2 = p[n2];
                    for (n3 = 0; n3 < n2; ++n3) {
                        vector2D.assign(vector2D2);
                        vector2D.sub(p[n3]);
                        d4 = vector2D.sqrMag();
                        vector2D.mul(d2 / (d4 * Math.sqrt(d4)));
                        vector2D3.add(vector2D);
                    }
                    for (n3 = n2 + 1; n3 < N; ++n3) {
                        vector2D.assign(vector2D2);
                        vector2D.sub(p[n3]);
                        d4 = vector2D.sqrMag();
                        vector2D.mul(d2 / (d4 * Math.sqrt(d4)));
                        vector2D3.add(vector2D);
                    }
                }
                for (n2 = 0; n2 < N; ++n2) {
                    vector2D3 = a[n2];
                    vector2D2 = v[n2];
                    Vector2D vector2D4 = p[n2];
                    vector2D.assign(vector2D2).mul(d3).rotate270();
                    vector2D3.add(vector2D);
                    vector2D.assign(vector2D2);
                    vector2D4.add(vector2D.mul(dt));
                    vector2D.assign(vector2D3);
                    vector2D4.add(vector2D.mul(d));
                    vector2D.assign(vector2D3);
                    vector2D2.add(vector2D.mul(dt));
                    vector2D3.clear();
                }
                ++n;
            }
            break;
        }
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.clu.antimatter.AntiprotonAni <seed> <R> <dt> <steps> <N>");
        System.err.println("<seed> = Random seed for initial antiproton positions");
        System.err.println("<R> = Side of square for initial antiproton positions");
        System.err.println("<dt> = Time step size");
        System.err.println("<steps> = Number of time steps between snapshots");
        System.err.println("<N> = Number of antiprotons");
        System.exit(1);
    }
}

