## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(cache = TRUE, autodep = TRUE, cache.lazy = FALSE)

## ---- eval=FALSE--------------------------------------------------------------
#  if(!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("SpatialExperiment")

## ----message = FALSE, warning = FALSE-----------------------------------------
library(SpatialExperiment)

## -----------------------------------------------------------------------------
cd <- DataFrame(x=1:26, y=1:26, z=letters)
mat <- matrix(nrow=26, ncol=26)

spe <- SpatialExperiment(assay=mat, 
    spatialData=cd, 
    spatialCoordsNames=c("x", "y"))

head(spatialCoords(spe))
spatialCoordsNames(spe)
head(spatialData(spe))
spatialDataNames(spe)
head(colData(spe))

## -----------------------------------------------------------------------------
spatialData(spe, spatialCoords=TRUE)

## -----------------------------------------------------------------------------
cd <- DataFrame(x=1:26, y=1:26, z=letters)
mat <- matrix(nrow=26, ncol=26)

spe <- SpatialExperiment(
  assay=mat, colData=cd, spatialCoordsNames=c("x", "y"), spatialDataNames="z")

head(spatialData(spe))
head(spatialCoords(spe))
head(colData(spe))

## -----------------------------------------------------------------------------
y <- diag(n <- 10)
mat <- matrix(0, n, m <- 2)

spe <- SpatialExperiment(assays = y, spatialCoords = mat)

## -----------------------------------------------------------------------------
mat <- as.matrix(cd[,1:2])
colnames(mat) <- c("ecs","uai")
spad <- DataFrame(a=1:26, b=1:26, z=letters)
asy <- matrix(nrow=26, ncol=26)
spe <- SpatialExperiment(assays = asy, spatialCoords = mat, 
    spatialData=spad, colData=cd)

head(spatialData(spe))
head(spatialCoords(spe))
head(colData(spe))

## -----------------------------------------------------------------------------
spe1 <- spe2 <- spe
spe3 <- cbind(spe1, spe2)
unique(spe3$sample_id)

## -----------------------------------------------------------------------------
# make sample identifiers unique
spe1 <- spe2 <- spe
spe1$sample_id <- paste(spe1$sample_id, "sample1", sep = ".")
spe2$sample_id <- paste(spe2$sample_id, "sample2", sep = ".")

# combine into single object
spe3 <- cbind(spe1, spe2)

spe3

## -----------------------------------------------------------------------------
spe3[, colData(spe)$sample_id=="sample1.sample1"]

## ---- error=TRUE--------------------------------------------------------------
new <- spe3$sample_id; 
new[1] <- "sample1.sample2"
spe3$sample_id <- new
new[1] <- "third.one.of.two"
spe3$sample_id <- new

## -----------------------------------------------------------------------------
dir <- system.file(
   file.path("extdata", "10xVisium", "section1"),
   package = "SpatialExperiment")

# read in counts
fnm <- file.path(dir, "raw_feature_bc_matrix")
sce <- DropletUtils::read10xCounts(fnm)

# read in image data
img <- readImgData(
    path = file.path(dir, "spatial"),
    sample_id="foo")

# read in spatial coordinates
fnm <- file.path(dir, "spatial", "tissue_positions_list.csv")
xyz <- read.csv(fnm, header = FALSE,
    col.names = c(
        "barcode", "in_tissue", "array_row", "array_col",
        "pxl_row_in_fullres", "pxl_col_in_fullres"))

# construct observation & feature metadata
rd <- S4Vectors::DataFrame(
    symbol = rowData(sce)$Symbol)

# construct 'SpatialExperiment'
(spe <- SpatialExperiment(
    assays = list(counts = assay(sce)),
    colData = colData(sce), rowData = rd, imgData = img,
    spatialData=DataFrame(xyz),
    spatialCoordsNames=c("pxl_col_in_fullres", "pxl_row_in_fullres"),
    sample_id="foo"))

## -----------------------------------------------------------------------------
dir <- system.file(
    file.path("extdata", "10xVisium"),
    package = "SpatialExperiment")

sample_ids <- c("section1", "section2")
samples <- file.path(dir, sample_ids)

(spe <- read10xVisium(samples, sample_ids,
    type = "sparse", data = "raw",
    images = "lowres", load = FALSE))

## ----message = FALSE, warning = FALSE-----------------------------------------
# sample xy-coordinates in [0,1]
x <- runif(n)
y <- runif(n)
# assign each molecule to some gene-cell pair
gs <- paste0("gene", seq(ng))
cs <- paste0("cell", seq(nc))
gene <- sample(gs, n, TRUE)
cell <- sample(cs, n, TRUE)
# construct data.frame of molecule coodinates
df <- data.frame(gene, cell, x, y)
head(df)

## ----message = FALSE, warning = FALSE-----------------------------------------
# (assure gene & cell are factor so that
# missing observations aren't dropped)
df$gene <- factor(df$gene, gs)
df$cell <- factor(df$cell, cs)
# construct BumpyMatrix
library(BumpyMatrix)

mol <- splitAsBumpyMatrix(
    df[, c("x", "y")], 
    row = gs, col = cs)

## ----message = FALSE, warning = FALSE-----------------------------------------
# get count matrix
y <- with(df, table(gene, cell))
y <- as.matrix(unclass(y))
y[1:5, 1:5]
# construct SpatialExperiment
spe <- SpatialExperiment(
    assays = list(
        counts = y, 
        molecules = mol))
spe

## ----message = FALSE, warning = FALSE-----------------------------------------
molecules(spe)

## ----tidy=TRUE----------------------------------------------------------------
sessionInfo()

