## ---- eval=FALSE--------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly=TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("SCArray")

## -----------------------------------------------------------------------------
suppressPackageStartupMessages(library(SCArray))
suppressPackageStartupMessages(library(SingleCellExperiment))

# load a SingleCellExperiment object
fn <- system.file("extdata", "LaMannoBrainSub.rds", package="SCArray")
sce <- readRDS(fn)

# convert to a GDS file
scConvGDS(sce, "test.gds")

# list data structure in the GDS file
(f <- scOpen("test.gds")); scClose(f)

## -----------------------------------------------------------------------------
library(Matrix)

cnt <- matrix(0, nrow=4, ncol=8)
set.seed(100); cnt[sample.int(length(cnt), 8)] <- rpois(8, 4)
(cnt <- as(cnt, "dgCMatrix"))

# convert to a GDS file
scConvGDS(cnt, "test.gds")

## -----------------------------------------------------------------------------
# a GDS file in the SCArray package
(fn <- system.file("extdata", "LaMannoBrainData.gds", package="SCArray"))
# load a SingleCellExperiment object from the file
sce <- scExperiment(fn)
sce

# it is a DelayedMatrix (the whole matrix is not loaded)
assays(sce)$counts

# column data
colData(sce)
# row data
rowData(sce)

## -----------------------------------------------------------------------------
cnt <- assays(sce)$counts
logcnt <- log2(cnt + 1)
assays(sce)$logcounts <- logcnt
logcnt

## -----------------------------------------------------------------------------
suppressPackageStartupMessages(library(DelayedMatrixStats))

col_mean <- DelayedMatrixStats::colMeans2(logcnt)
str(col_mean)
row_mean <- DelayedMatrixStats::rowMeans2(logcnt)
str(row_mean)

## -----------------------------------------------------------------------------
suppressPackageStartupMessages(library(scater))

# run umap analysis
sce <- runUMAP(sce)

## ----fig.width=4,fig.height=3-------------------------------------------------
plotReducedDim(sce, dimred="UMAP")

## -----------------------------------------------------------------------------
# print version information about R, the OS and attached or loaded packages
sessionInfo()

## ----echo=FALSE---------------------------------------------------------------
unlink("test.gds", force=TRUE)

