/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.reference;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import net.sf.picard.reference.FastaSequenceFile;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import net.sf.picard.reference.ReferenceSequenceFile;

public class ReferenceSequenceFileFactory {
    public static final Set<String> FASTA_EXTENSIONS = new HashSet<String>(){
        {
            this.add(".fasta");
            this.add(".fasta.gz");
            this.add(".fa");
            this.add(".fa.gz");
            this.add(".txt");
            this.add(".txt.gz");
        }
    };

    public static ReferenceSequenceFile getReferenceSequenceFile(File file) {
        return ReferenceSequenceFileFactory.getReferenceSequenceFile(file, true);
    }

    public static ReferenceSequenceFile getReferenceSequenceFile(File file, boolean truncateNamesAtWhitespace) {
        String name = file.getName();
        for (String ext : FASTA_EXTENSIONS) {
            if (!name.endsWith(ext)) continue;
            if (truncateNamesAtWhitespace && IndexedFastaSequenceFile.canCreateIndexedFastaReader(file)) {
                return new IndexedFastaSequenceFile(file);
            }
            return new FastaSequenceFile(file, truncateNamesAtWhitespace);
        }
        throw new IllegalArgumentException("File is not a supported reference file type: " + file.getAbsolutePath());
    }
}

