## ----style, echo = FALSE, results = 'asis', message=FALSE---------------------
BiocStyle::markdown()

## ----env, echo=FALSE, message=FALSE-------------------------------------------
suppressPackageStartupMessages(library("AnnotationHub"))
suppressPackageStartupMessages(library("ProteomicsAnnotationHubData"))
suppressPackageStartupMessages(library("mzR"))

## ----ahinit-------------------------------------------------------------------
library("AnnotationHub")
ah <- AnnotationHub()
ah

## ----provider-----------------------------------------------------------------
query(ah, "PRIDE")

## ----title--------------------------------------------------------------------
query(ah, "PXD000001")

## ----ah49008------------------------------------------------------------------
ah["AH49008"]

## ----rawmsdata----------------------------------------------------------------
library("mzR")
rw <- ah[["AH49008"]]
rw

## ----msdataplot---------------------------------------------------------------
plot(peaks(rw, 1), type = "h", xlab = "M/Z", ylab = "Intensity")

## ----availablepahd------------------------------------------------------------
library("ProteomicsAnnotationHubData")
availableProteomicsAnnotationHubData

## ---- echo=FALSE--------------------------------------------------------------
cat(readLines(dir(system.file("extdata", package = "ProteomicsAnnotationHubData"), full.names = TRUE, pattern = "PXD000001.dcf"))[10:30], sep = "\n")

## -----------------------------------------------------------------------------
writePahdTemplate()

## ----PXD000001.dcf, echo=FALSE------------------------------------------------
f <- list.files(system.file("extdata", package = "ProteomicsAnnotationHubData"),
                full.names = TRUE, pattern = "PXD000001.dcf")
cat(readLines(f)[10:30], sep = "\n")

## ----providers, echo=FALSE----------------------------------------------------
tab <- do.call(rbind, ProteomicsAnnotationHubData:::ProteomicsAnnotationHubDataProviders)
knitr::kable(tab, row.names = FALSE)

## ----tags, echo=FALSE---------------------------------------------------------
ProteomicsAnnotationHubData:::ProteomicsAnnotationHubDataTags

## ----PXD000001.R, echo=FALSE--------------------------------------------------
f <- list.files(system.file("scripts", package = "ProteomicsAnnotationHubData"),
                full.names = TRUE, pattern = "PXD000001.R")
cat(readLines(f)[1:4], sep = "\n")

## ---- eval=FALSE--------------------------------------------------------------
#  setClass("mzRpwizResource", contains="AnnotationHubResource")
#  setMethod(".get1", "mzRpwizResource",
#      function(x, ...)
#  {
#      .require("mzR")
#      yy <- cache(.hub(x))
#      mzR::openMSfile(yy, backend = "pwiz")
#  })

## ---- eval=FALSE--------------------------------------------------------------
#  setClass("mzRidentResource", contains="AnnotationHubResource")
#  setMethod(".get1", "mzRidentResource",
#      function(x, ...)
#  {
#      .require("mzR")
#      yy <- cache(.hub(x))
#      mzR::openIDfile(yy)
#  })

## ---- eval=FALSE--------------------------------------------------------------
#  setClass("MSnSetResource", contains="RdaResource")
#  setMethod(".get1", "MSnSetResource",
#      function(x, ...)
#  {
#      .require("MSnbase")
#      callNextMethod(x, ...)
#  })

## ---- eval=FALSE--------------------------------------------------------------
#  setClass("AAStringSetResource", contains="AnnotationHubResource")
#  setMethod(".get1", "AAStringSetResource",
#       function(x, ...)
#  {
#      .require("Biostrings")
#      yy <- cache(.hub(x))
#      Biostrings::readAAStringSet(yy)
#  })

