## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE, eval = FALSE, 
                      warning = FALSE, error = FALSE)

## -----------------------------------------------------------------------------
#  p1 <- GRanges("1", IRanges(c(1, 4, 7), width=2))
#  p2 <- GRanges("1", IRanges(c(2, 5), width=3))
#  ol_min <- findOverlapsOfPeaks(p1, p2, connectedPeaks="min")
#  ## the counts will be the minimal peaks involved in that group of
#  ## connected peaks, so you get 2.
#  ol_merge <- findOverlapsOfPeaks(p1, p2, connectedPeaks="merge")
#  ## the counts will be 1 for each group of connected peaks
#  ol_min$venn_cnt
#  ol_merge$venn_cnt

## -----------------------------------------------------------------------------
#  library(ChIPpeakAnno)
#  bed <- system.file("extdata", "MACS_output.bed", package="ChIPpeakAnno")
#  gr1 <- toGRanges(bed, format="BED", header=FALSE)
#  gff <- system.file("extdata", "GFF_peaks.gff", package="ChIPpeakAnno")
#  gr2 <- toGRanges(gff, format="GFF", header=FALSE, skip=3)
#  ol <- findOverlapsOfPeaks(gr1, gr2)
#  peakNames <- ol$peaklist[['gr1///gr2']]$peakNames
#  library(reshape2)
#  peakNames1 <- melt(peakNames, value.name="merged.peak.id")
#  peakNames1 <- cbind(peakNames1[, 1], do.call(rbind, strsplit(as.character(peakNames1[, 3]), "__")))
#  colnames(peakNames1) <- c("merged.peak.id", "group", "peakName")
#  head(peakNames1)
#  gr1.subset <- gr1[peakNames1[peakNames1[, "group"] %in% "gr1", "peakName"]]
#  gr2.subset <- gr2[peakNames1[peakNames1[, "group"] %in% "gr2", "peakName"]]

## -----------------------------------------------------------------------------
#  all.peaks <- ol$all.peaks
#  gr1.renamed <- all.peaks$gr1
#  gr2.renamed <- all.peaks$gr2
#  peakNames <- melt(ol$peaklist[['gr1///gr2']]$peakNames, value.name="merged.peak.id")
#  gr1.sub <- gr1.renamed[peakNames[grepl("^gr1", peakNames[, 3]), 3]]
#  gr2.sub <- gr2.renamed[peakNames[grepl("^gr2", peakNames[, 3]), 3]]

