## ----style, echo = FALSE, results = 'asis', eval=TRUE-------------------------
options(width=80, max.print=1000)
knitr::opts_chunk$set(
    eval=as.logical(Sys.getenv("KNITR_EVAL", "TRUE")),
    cache=as.logical(Sys.getenv("KNITR_CACHE", "TRUE")), 
    tidy.opts=list(width.cutoff=60), 
    tidy=TRUE,
    eval = FALSE)
# shiny::tagList(rmarkdown::html_dependency_font_awesome())

## ----setup, echo=FALSE, messages=FALSE, warnings=FALSE, eval=TRUE-------------
    suppressPackageStartupMessages(library(systemPipeShiny))

## ----sps-css, results = 'asis', echo=FALSE, eval=TRUE-------------------------
cat("<style>")
cat(readLines(system.file("app/www/css/sps.css", package = "systemPipeShiny")),sep = "\n")
cat("</style>")

## ----logo, echo=FALSE, out.width='50%', fig.align='center', eval=TRUE---------
knitr::include_graphics(path = "../inst/app/www/img/sps.png")

## ---- eval=FALSE--------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly=TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("systemPipeShiny")
#  
#  # or use "pak"
#  if (!requireNamespace("pak", quietly=TRUE))
#      install.packages("pak", repos = "https://r-lib.github.io/p/pak/dev/")
#  pak::pkg_install("systemPipeShiny")
#  

## ----sps_load_package, eval=TRUE----------------------------------------------
library(systemPipeShiny)

## ----spsinit, eval=FALSE------------------------------------------------------
#  spsInit()

## ----spsinit_temp, eval=TRUE--------------------------------------------------
sps_tmp_dir <- tempdir()
spsInit(app_path = sps_tmp_dir, change_wd = FALSE, project_name = "SPSProject")
sps_dir <- file.path(sps_tmp_dir, "SPSProject")

## ---- eval=FALSE--------------------------------------------------------------
#  shiny::runApp()

## ----sessionInfo, eval=TRUE---------------------------------------------------
sessionInfo()

