## ----message=FALSE, warning=FALSE, include=FALSE------------------------------
library(sesame)
library(dplyr)
options(rmarkdown.html_vignette.check_title = FALSE)

## ---- eval=FALSE--------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly=TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("sesame")

## ---- eval=FALSE--------------------------------------------------------------
#  BiocManager::install('zwdzwd/sesameData')
#  BiocManager::install('zwdzwd/sesame')

## ----message = FALSE, warning = FALSE-----------------------------------------
idat_dir <- system.file("extdata/", package = "sesameData")
betas <- openSesame(idat_dir)

## ----message = FALSE, warning = FALSE, eval = FALSE---------------------------
#  betas <- do.call(cbind, lapply(searchIDATprefixes(idat_dir), function(pfx) {
#      pfx %>%
#          readIDATpair %>%
#          noob %>%
#          dyeBiasCorrTypeINorm %>%
#          qualityMask %>%
#          detectionMask %>%
#          getBetas
#  }))

## ----eval = FALSE-------------------------------------------------------------
#  openSesame(idat_dir, 'custom_array_name', manifest_file)

## ---- echo = FALSE, message = FALSE-------------------------------------------
library(sesameData)
library(sesame)
sset <- sesameDataGet('EPIC.1.LNCaP')$sset

## -----------------------------------------------------------------------------
sset

## -----------------------------------------------------------------------------
head(II(sset))

## -----------------------------------------------------------------------------
head(ctl(sset))

## -----------------------------------------------------------------------------
ssets <- lapply(
    searchIDATprefixes(system.file("extdata/", package = "sesameData")),
    readIDATpair)

## -----------------------------------------------------------------------------
sset <- sesameDataGet('EPIC.1.LNCaP')$sset
sset.nb <- noob(sset)
sset.nb <- noobsb(sset)

## -----------------------------------------------------------------------------
sset.TypeICorrected <- inferTypeIChannel(sset)

## -----------------------------------------------------------------------------
library(sesame)
sset.dbLinear <- dyeBiasCorr(sset)
qqplot(
    slot(sset.dbLinear, 'IR'), slot(sset.dbLinear, 'IG'),
    xlab='Type-I Red Signal', ylab='Type-I Grn Signal',
    main='Linear Correction', cex=0.5)
abline(0,1,lty='dashed')

## -----------------------------------------------------------------------------
sset.dbNonlinear <- dyeBiasCorrTypeINorm(sset)

## -----------------------------------------------------------------------------
qqplot(
    slot(sset.dbNonlinear, 'IR'), slot(sset.dbNonlinear, 'IG'),
    xlab='Type-I Red Signal', ylab='Type-I Grn Signal',
    main='Nonlinear Correction', cex=0.5)
abline(0,1,lty='dashed')

## -----------------------------------------------------------------------------
betas <- getBetas(sset)
head(betas)

## -----------------------------------------------------------------------------
betas <- getBetas(sset, sum.TypeI = TRUE)

## -----------------------------------------------------------------------------
extraSNPAFs <- getAFTypeIbySumAlleles(sset)

## -----------------------------------------------------------------------------
inferSex(sset)
inferSexKaryotypes(sset)

## -----------------------------------------------------------------------------
inferEthnicity(sset)

## -----------------------------------------------------------------------------
betas <- sesameDataGet('HM450.1.TCGA.PAAD')$betas
predictAgeHorvath353(betas)

## -----------------------------------------------------------------------------
meanIntensity(sset)

## -----------------------------------------------------------------------------
bisConversionControl(sset)

## ---- message=FALSE, fig.width=6, fig.height=5--------------------------------
betas <- sesameDataGet('HM450.10.TCGA.PAAD.normal')
visualizeGene('DNMT1', betas, platform='HM450')

## ---- message=FALSE, fig.width=6, fig.height=5--------------------------------
visualizeRegion(
    'chr19',10260000,10380000, betas, platform='HM450',
    show.probeNames = FALSE)

## ---- message=FALSE, fig.width=6----------------------------------------------
visualizeProbes(c("cg02382400", "cg03738669"), betas, platform='HM450')

## ---- message=FALSE, fig.width=6----------------------------------------------
ssets.normal <- sesameDataGet('EPIC.5.normal')
segs <- cnSegmentation(sset, ssets.normal)

## ---- message=FALSE, fig.width=6----------------------------------------------
visualizeSegments(segs)

## ---- message=FALSE-----------------------------------------------------------
betas.tissue <- sesameDataGet('HM450.1.TCGA.PAAD')$betas
estimateLeukocyte(betas.tissue)

