## ----message=FALSE, warning=FALSE, include=FALSE------------------------------
library(sesame)

## ---- eval=FALSE--------------------------------------------------------------
#  dest_dir = tempdir()
#  res_grn = sesameDataDownload("3999492009_R01C01_Grn.idat", dest_dir=dest_dir)
#  res_red = sesameDataDownload("3999492009_R01C01_Red.idat", dest_dir=dest_dir)

## ---- eval=FALSE--------------------------------------------------------------
#  
#  deIdentify(res_grn$dest_file, sprintf("%s/deidentified_Grn.idat", dest_dir))
#  deIdentify(res_red$dest_file, sprintf("%s/deidentified_Red.idat", dest_dir))
#  
#  betas1 = getBetas(readIDATpair(sprintf("%s/3999492009_R01C01", dest_dir)))
#  betas2 = getBetas(readIDATpair(sprintf("%s/deidentified", dest_dir)))
#  
#  ## before deIdentify, the rs values will all be different
#  head(betas1[grep('rs',names(betas1))])
#  ## after deIdentify, all rs values will be 0.5
#  head(betas2[grep('rs',names(betas2))])

## ---- eval=FALSE--------------------------------------------------------------
#  
#  my_secret <- 13412084
#  set.seed(my_secret)
#  
#  deIdentify(res_grn$dest_file,
#      sprintf("%s/deidentified_Grn.idat", dest_dir), randomize=TRUE)
#  
#  my_secret <- 13412084
#  set.seed(my_secret)
#  deIdentify(res_red$dest_file,
#      sprintf("%s/deidentified_Red.idat", dest_dir), randomize=TRUE)
#  
#  betas1 = getBetas(readIDATpair(sprintf("%s/3999492009_R01C01", dest_dir)))
#  betas2 = getBetas(readIDATpair(sprintf("%s/deidentified", dest_dir)))
#  
#  ## before deIdentify, the rs values will all be different
#  head(betas1[grep('rs',names(betas1))])
#  ## after deIdentify, all rs values will be scrambled
#  head(betas2[grep('rs',names(betas2))])
#  

## ---- eval=FALSE--------------------------------------------------------------
#  
#  my_secret <- 13412084
#  set.seed(my_secret)
#  
#  reIdentify(sprintf("%s/deidentified_Grn.idat", dest_dir),
#      sprintf("%s/reidentified_Grn.idat", dest_dir))
#  
#  my_secret <- 13412084
#  set.seed(my_secret)
#  reIdentify(sprintf("%s/deidentified_Red.idat", dest_dir),
#      sprintf("%s/reidentified_Red.idat", dest_dir))
#  
#  betas1 = getBetas(readIDATpair(sprintf("%s/3999492009_R01C01", dest_dir)))
#  betas2 = getBetas(readIDATpair(sprintf("%s/reidentified", dest_dir)))
#  
#  ## before reIdentify, the values are different
#  head(betas1[grep('rs',names(betas1))])
#  ## after reIdentify, the values are restored, the same as betas 1
#  head(betas2[grep('rs',names(betas2))])
#  

