## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>"
)
library(ggplot2)
theme_set(theme_classic())

## ----setup, message=FALSE, eval=FALSE-----------------------------------------
#  library(Seurat)
#  library(schex)

## ----load, eval=FALSE---------------------------------------------------------
#  cbmc.rna <- as.sparse(read.csv(file =
#      "../new functions/data/GSE100866_CBMC_8K_13AB_10X-RNA_umi.csv.gz",
#      sep = ",", header = TRUE, row.names = 1))
#  
#  cbmc.rna <- CollapseSpeciesExpressionMatrix(cbmc.rna)
#  
#  cbmc.adt <- as.sparse(read.csv(file =
#      "../new functions/data/GSE100866_CBMC_8K_13AB_10X-ADT_umi.csv.gz",
#      sep = ",", header = TRUE, row.names = 1))
#  
#  cbmc.adt <- cbmc.adt[setdiff(rownames(x = cbmc.adt),
#        c("CCR5", "CCR7", "CD10")), ]

## ----preprocess-gene, eval=FALSE----------------------------------------------
#  cbmc <- CreateSeuratObject(counts = cbmc.rna)
#  
#  cbmc <- NormalizeData(cbmc)
#  cbmc <- FindVariableFeatures(cbmc)
#  cbmc <- ScaleData(cbmc)

## ----cluster-gene, eval=FALSE-------------------------------------------------
#  cbmc <- RunPCA(cbmc, verbose = FALSE)
#  cbmc <- RunTSNE(cbmc, dims = 1:25, method = "FIt-SNE")

## ----preprocess-protein, eval=FALSE-------------------------------------------
#  cbmc[["ADT"]] <- CreateAssayObject(counts = cbmc.adt)
#  
#  cbmc <- NormalizeData(cbmc, assay = "ADT", normalization.method = "CLR")
#  cbmc <- ScaleData(cbmc, assay = "ADT")

## ----calc-hexbin, eval=FALSE--------------------------------------------------
#  cbmc <- make_hexbin(cbmc, nbins = 25,
#      dimension_reduction = "tsne", use_dims=c(1,2))

## ----plot-density, fig.height=7, fig.width=7, eval=FALSE----------------------
#  plot_hexbin_density(cbmc)

## ----plot-feature, fig.height=7, fig.width=7, eval=FALSE----------------------
#  plot_hexbin_feature(cbmc, mod="ADT", type="scale.data", feature="CD14",
#      action="mean", xlab="TSNE1", ylab="TSNE2",
#      title=paste0("Mean of protein expression of CD14"))

## ----plot-interact, fig.height=7, fig.width=7, message=FALSE, warning=FALSE, eval=FALSE----
#  plot_hexbin_interact(cbmc, type=c("scale.data", "scale.data"),
#      mod=c("RNA", "ADT"), feature=c("CD14", "CD14"), interact="corr_spearman",
#      ylab="TSNE2", xlab="TSNE1",
#      title="Interaction protein and gene expression CD14") +
#      scale_fill_gradient2(midpoint=0, low="blue", mid="white",
#                       high="red", space ="Lab")

## ----protein-pca, message=FALSE, warning=FALSE, eval=FALSE--------------------
#  DefaultAssay(cbmc) <- "ADT"
#  cbmc <- RunPCA(cbmc, features = rownames(cbmc), reduction.name = "pca_adt",
#      reduction.key = "pca_adt_", verbose = FALSE)
#  cbmc <- make_hexbin(cbmc, nbins = 25,
#      dimension_reduction = "pca_adt", use_dims=c(1,2))

## ----plot-feature-a, fig.height=7, fig.width=7, eval=FALSE--------------------
#  plot_hexbin_feature(cbmc, mod="ADT", type="scale.data", feature="CD14",
#      action="mean", xlab="TSNE1", ylab="TSNE2",
#      title=paste0("Mean of protein expression of CD14"))

