/*
 * Decompiled with CFR 0.152.
 */
package de.proteinms.xtandemparser.parser;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.PeptideAssumption;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.io.identifications.IdfileReader;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.waiting.WaitingHandler;
import de.proteinms.xtandemparser.interfaces.Modification;
import de.proteinms.xtandemparser.xtandem.Domain;
import de.proteinms.xtandemparser.xtandem.ModificationMap;
import de.proteinms.xtandemparser.xtandem.PeptideMap;
import de.proteinms.xtandemparser.xtandem.XTandemFile;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class XTandemIdfileReader
extends ExperimentObject
implements IdfileReader {
    private XTandemFile xTandemFile = null;
    private ModificationMap modificationMap;
    private PeptideMap peptideMap;

    public XTandemIdfileReader() {
    }

    public XTandemIdfileReader(File aFile) throws SAXException, ParserConfigurationException {
        this.xTandemFile = new XTandemFile(aFile.getPath(), true);
        this.peptideMap = this.xTandemFile.getPeptideMap();
        this.modificationMap = this.xTandemFile.getModificationMap();
    }

    @Override
    public String getExtension() {
        return "t.xml";
    }

    public String getFileName() {
        File tempFile = new File(this.xTandemFile.getFileName());
        return tempFile.getName();
    }

    @Override
    public HashSet<SpectrumMatch> getAllSpectrumMatches(WaitingHandler waitingHandler) throws IOException, IllegalArgumentException, Exception {
        HashSet<SpectrumMatch> foundPeptides = new HashSet<SpectrumMatch>();
        if (waitingHandler != null) {
            waitingHandler.setMaxSecondaryProgressCounter(this.xTandemFile.getSpectraNumber());
        }
        HashMap<Integer, String> idToSpectrumTitleMap = this.xTandemFile.getXTandemParser().getIdToSpectrumMap();
        for (String id : this.peptideMap.getSpectrumAndPeptideMap().keySet()) {
            Integer spectrumNumber = new Integer(id.substring(1));
            String tempTitle = idToSpectrumTitleMap.get(spectrumNumber);
            String spectrumName = this.fixMgfTitle(tempTitle);
            if (spectrumName.indexOf("RTINSECONDS=") != -1) {
                spectrumName = spectrumName.substring(0, spectrumName.indexOf("RTINSECONDS="));
            }
            spectrumName = spectrumName.trim();
            ArrayList<de.proteinms.xtandemparser.xtandem.Peptide> spectrumPeptides = this.peptideMap.getAllPeptides(spectrumNumber);
            if (spectrumPeptides.size() > 0) {
                String tempFile = this.xTandemFile.getInputParameters().getSpectrumPath();
                String filename = Util.getFileName(tempFile);
                Integer parsedCharge = new Integer(this.xTandemFile.getXTandemParser().getRawSpectrumMap().get("z" + spectrumNumber));
                Charge charge = new Charge(1, parsedCharge);
                String spectrumKey = Spectrum.getSpectrumKey(filename, spectrumName);
                SpectrumMatch currentMatch = new SpectrumMatch(spectrumKey);
                currentMatch.setSpectrumNumber(spectrumNumber);
                HashMap hitMap = new HashMap();
                for (de.proteinms.xtandemparser.xtandem.Peptide peptide : spectrumPeptides) {
                    for (Domain domain : peptide.getDomains()) {
                        if (!hitMap.containsKey(domain.getDomainExpect())) {
                            hitMap.put(domain.getDomainExpect(), new ArrayList());
                        }
                        ((ArrayList)hitMap.get(domain.getDomainExpect())).add(domain);
                    }
                }
                ArrayList eValues = new ArrayList(hitMap.keySet());
                Collections.sort(eValues);
                int rank = 1;
                for (Double eValue : eValues) {
                    int rankIncrease = 0;
                    for (Domain domain : (ArrayList)hitMap.get(eValue)) {
                        PeptideAssumption newAssumption = this.getPeptideAssumption(domain, charge.value, rank);
                        boolean found = false;
                        for (SpectrumIdentificationAssumption loadedAssumption : currentMatch.getAllAssumptions()) {
                            PeptideAssumption peptideAssumption = (PeptideAssumption)loadedAssumption;
                            if (!peptideAssumption.getPeptide().isSameSequenceAndModificationStatus(newAssumption.getPeptide(), AminoAcidPattern.MatchingType.string, Double.NaN) || !peptideAssumption.getPeptide().sameModificationsAs(newAssumption.getPeptide())) continue;
                            found = true;
                        }
                        if (found) continue;
                        ++rankIncrease;
                        currentMatch.addHit(2, newAssumption);
                    }
                    rank += rankIncrease;
                }
                foundPeptides.add(currentMatch);
            }
            if (waitingHandler == null) continue;
            if (waitingHandler.isRunCanceled()) break;
            waitingHandler.increaseSecondaryProgressCounter();
        }
        return foundPeptides;
    }

    private PeptideAssumption getPeptideAssumption(Domain domain, int charge, int rank) {
        String sequence = domain.getDomainSequence();
        ArrayList<ModificationMatch> foundModifications = new ArrayList<ModificationMatch>();
        ArrayList<Modification> foundVariableModifications = this.modificationMap.getVariableModifications(domain.getDomainKey());
        for (Modification currentModification : foundVariableModifications) {
            int location = new Integer(currentModification.getLocation()) - domain.getDomainStart() + 1;
            foundModifications.add(new ModificationMatch(currentModification.getName(), true, location));
        }
        Peptide peptide = new Peptide(sequence, foundModifications);
        return new PeptideAssumption(peptide, rank, 2, new Charge(1, charge), domain.getDomainExpect(), this.getFileName());
    }

    private String fixMgfTitle(String spectrumTitle) {
        try {
            spectrumTitle = URLDecoder.decode(spectrumTitle, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("An exception was thrown when trying to decode an mgf tile!");
            e.printStackTrace();
        }
        return spectrumTitle;
    }

    @Override
    public void close() throws IOException {
        this.xTandemFile = null;
    }
}

