/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.preferences;

import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.psm_scoring.PsmScores;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class ProcessingPreferences
implements Serializable {
    static final long serialVersionUID = -5883143685674607162L;
    private boolean aScore = false;
    private double proteinFDR = 1.0;
    private double peptideFDR = 1.0;
    private double psmFDR = 1.0;
    private Double proteinConfidenceMwPlots = 95.0;
    private HashMap<Integer, ArrayList<Integer>> spectrumMatchingScores = null;

    public ProcessingPreferences() {
        this.initializeAlgorithmScores();
    }

    public boolean isAScoreCalculated() {
        return this.aScore;
    }

    public void estimateAScore(boolean shouldEstimateAScore) {
        this.aScore = shouldEstimateAScore;
    }

    public double getPeptideFDR() {
        return this.peptideFDR;
    }

    public void setPeptideFDR(double peptideFDR) {
        this.peptideFDR = peptideFDR;
    }

    public double getProteinFDR() {
        return this.proteinFDR;
    }

    public void setProteinFDR(double proteinFDR) {
        this.proteinFDR = proteinFDR;
    }

    public double getPsmFDR() {
        return this.psmFDR;
    }

    public void setPsmFDR(double psmFDR) {
        this.psmFDR = psmFDR;
    }

    public Double getProteinConfidenceMwPlots() {
        if (this.proteinConfidenceMwPlots == null) {
            return 95.0;
        }
        return this.proteinConfidenceMwPlots;
    }

    public void setProteinConfidenceMwPlots(Double proteinConfidenceMwPlots) {
        this.proteinConfidenceMwPlots = proteinConfidenceMwPlots;
    }

    public void initializeAlgorithmScores() {
        this.spectrumMatchingScores = new HashMap(Advocate.values().length);
        for (Advocate advocate : Advocate.values()) {
            ArrayList<Integer> scores = new ArrayList<Integer>();
            scores.add(PsmScores.native_score.index);
            if (advocate.getType() == Advocate.AdvocateType.sequencing_algorithm || advocate.getType() == Advocate.AdvocateType.spectral_library || advocate.getType() == Advocate.AdvocateType.unknown) {
                scores.add(PsmScores.precursor_accuracy.index);
                scores.add(PsmScores.ms2_mz_fidelity.index);
                scores.add(PsmScores.intensity.index);
                scores.add(PsmScores.complementarity.index);
            }
            this.spectrumMatchingScores.put(advocate.getIndex(), scores);
        }
    }

    public void setScoresForAlgorithm(int advocateIndex, ArrayList<Integer> scores) {
        if (this.spectrumMatchingScores == null) {
            this.spectrumMatchingScores = new HashMap();
        }
        this.spectrumMatchingScores.put(advocateIndex, scores);
    }

    public ArrayList<Integer> getScores(int advocateIndex) {
        if (this.spectrumMatchingScores == null) {
            return null;
        }
        return this.spectrumMatchingScores.get(advocateIndex);
    }

    public boolean isScoringNeeded(int advocate) {
        ArrayList<Integer> scores;
        if (this.spectrumMatchingScores != null && !this.spectrumMatchingScores.isEmpty() && (scores = this.spectrumMatchingScores.get(advocate)) != null && !scores.isEmpty()) {
            for (int scoreIndex : scores) {
                if (scoreIndex == PsmScores.native_score.index) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isScoringNeeded(ArrayList<Integer> advocates) {
        if (this.spectrumMatchingScores != null && !this.spectrumMatchingScores.isEmpty()) {
            for (Integer advocate : advocates) {
                if (!this.isScoringNeeded(advocate)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isTargetDecoyNeededForPsmScoring(ArrayList<Integer> advocates) {
        if (this.spectrumMatchingScores != null && !this.spectrumMatchingScores.isEmpty()) {
            for (Integer advocate : advocates) {
                ArrayList<Integer> scores = this.spectrumMatchingScores.get(advocate);
                if (scores == null || scores.isEmpty()) continue;
                int nScores = 0;
                for (int scoreIndex : scores) {
                    if (scoreIndex == PsmScores.native_score.index) continue;
                    if (nScores == 1) {
                        return true;
                    }
                    ++nScores;
                }
            }
        }
        return false;
    }
}

