/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.searchsettings.algorithm_settings;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.identification.identification_parameters.MsgfParameters;
import com.compomics.util.gui.GuiUtilities;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class MsgfSettingsDialog
extends JDialog {
    private MsgfParameters msgfParameters;
    private boolean cancelled = false;
    private JComboBox additionalOutputCmb;
    private JLabel additionalOutputlLabel;
    private JPanel advancedSearchSettingsPanel;
    private JLabel advancedSettingsWarningLabel;
    private JPanel backgroundPanel;
    private JButton closeButton;
    private JComboBox decoyDatabaseCmb;
    private JLabel decoyDatabaseLabel;
    private JComboBox fragmentationMethodCmb;
    private JLabel fragmentationMethodLabel;
    private JTextField highIsotopeErrorRangeTxt;
    private JComboBox instrumentCmb;
    private JLabel instrumentLabel;
    private JLabel isotopeErrorRangeDividerLabel;
    private JLabel isotopeErrorRangeLabel;
    private JTextField lowIsotopeErrorRangeTxt;
    private JTextField maxPepLengthTxt;
    private JLabel maxPtmsLabel;
    private JTextField maxPtmsTxt;
    private JTextField minPepLengthTxt;
    private JLabel numberMatchesLabel;
    private JTextField numberMatchesTxt;
    private JLabel numberTerminiLabel;
    private JButton okButton;
    private JButton openDialogHelpJButton;
    private JLabel peptideLengthDividerLabel;
    private JLabel peptideLengthLabel;
    private JComboBox protocolCmb;
    private JLabel protocolLabel;
    private JComboBox terminiCmb;

    public MsgfSettingsDialog(Frame parent, MsgfParameters msgfParameters) {
        super(parent, true);
        this.msgfParameters = msgfParameters;
        this.initComponents();
        this.setUpGUI();
        this.fillGUI();
        this.validateInput(false);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void setUpGUI() {
        this.decoyDatabaseCmb.setRenderer(new AlignedListCellRenderer(0));
        this.instrumentCmb.setRenderer(new AlignedListCellRenderer(0));
        this.fragmentationMethodCmb.setRenderer(new AlignedListCellRenderer(0));
        this.protocolCmb.setRenderer(new AlignedListCellRenderer(0));
        this.additionalOutputCmb.setRenderer(new AlignedListCellRenderer(0));
        this.terminiCmb.setRenderer(new AlignedListCellRenderer(0));
    }

    private void fillGUI() {
        if (this.msgfParameters.searchDecoyDatabase()) {
            this.decoyDatabaseCmb.setSelectedIndex(0);
        } else {
            this.decoyDatabaseCmb.setSelectedIndex(1);
        }
        this.instrumentCmb.setSelectedIndex(this.msgfParameters.getInstrumentID());
        this.fragmentationMethodCmb.setSelectedIndex(this.msgfParameters.getFragmentationType());
        this.protocolCmb.setSelectedIndex(this.msgfParameters.getProtocol());
        if (this.msgfParameters.getMinPeptideLength() != null) {
            this.minPepLengthTxt.setText(this.msgfParameters.getMinPeptideLength() + "");
        }
        if (this.msgfParameters.getMaxPeptideLength() != null) {
            this.maxPepLengthTxt.setText(this.msgfParameters.getMaxPeptideLength() + "");
        }
        if (this.msgfParameters.getNumberOfSpectrumMarches() != null) {
            this.numberMatchesTxt.setText(this.msgfParameters.getNumberOfSpectrumMarches() + "");
        }
        if (this.msgfParameters.isAdditionalOutput()) {
            this.additionalOutputCmb.setSelectedIndex(0);
        } else {
            this.additionalOutputCmb.setSelectedIndex(1);
        }
        if (this.msgfParameters.getLowerIsotopeErrorRange() != null) {
            this.lowIsotopeErrorRangeTxt.setText(this.msgfParameters.getLowerIsotopeErrorRange() + "");
        }
        if (this.msgfParameters.getUpperIsotopeErrorRange() != null) {
            this.highIsotopeErrorRangeTxt.setText(this.msgfParameters.getUpperIsotopeErrorRange() + "");
        }
        if (this.msgfParameters.getNumberTolerableTermini() != null) {
            this.terminiCmb.setSelectedIndex(this.msgfParameters.getNumberTolerableTermini());
        }
        if (this.msgfParameters.getNumberOfPtmsPerPeptide() != null) {
            this.maxPtmsTxt.setText(this.msgfParameters.getNumberOfPtmsPerPeptide() + "");
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public MsgfParameters getInput() {
        MsgfParameters result = new MsgfParameters();
        result.setSearchDecoyDatabase(this.decoyDatabaseCmb.getSelectedIndex() == 0);
        result.setInstrumentID(this.instrumentCmb.getSelectedIndex());
        result.setFragmentationType(this.fragmentationMethodCmb.getSelectedIndex());
        result.setProtocol(this.protocolCmb.getSelectedIndex());
        String input = this.minPepLengthTxt.getText().trim();
        if (!input.equals("")) {
            result.setMinPeptideLength(new Integer(input));
        }
        if (!(input = this.maxPepLengthTxt.getText().trim()).equals("")) {
            result.setMaxPeptideLength(new Integer(input));
        }
        if (!(input = this.numberMatchesTxt.getText().trim()).equals("")) {
            result.setNumberOfSpectrumMarches(new Integer(input));
        }
        result.setAdditionalOutput(this.additionalOutputCmb.getSelectedIndex() == 0);
        input = this.lowIsotopeErrorRangeTxt.getText().trim();
        if (!input.equals("")) {
            result.setLowerIsotopeErrorRange(new Integer(input));
        }
        if (!(input = this.highIsotopeErrorRangeTxt.getText().trim()).equals("")) {
            result.setUpperIsotopeErrorRange(new Integer(input));
        }
        result.setNumberTolerableTermini(this.terminiCmb.getSelectedIndex());
        input = this.maxPtmsTxt.getText().trim();
        if (!input.equals("")) {
            result.setNumberOfPtmsPerPeptide(new Integer(input));
        }
        return result;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.advancedSearchSettingsPanel = new JPanel();
        this.instrumentCmb = new JComboBox();
        this.decoyDatabaseCmb = new JComboBox();
        this.decoyDatabaseLabel = new JLabel();
        this.instrumentLabel = new JLabel();
        this.fragmentationMethodLabel = new JLabel();
        this.fragmentationMethodCmb = new JComboBox();
        this.protocolLabel = new JLabel();
        this.protocolCmb = new JComboBox();
        this.minPepLengthTxt = new JTextField();
        this.peptideLengthDividerLabel = new JLabel();
        this.maxPepLengthTxt = new JTextField();
        this.peptideLengthLabel = new JLabel();
        this.numberMatchesLabel = new JLabel();
        this.numberMatchesTxt = new JTextField();
        this.additionalOutputlLabel = new JLabel();
        this.additionalOutputCmb = new JComboBox();
        this.isotopeErrorRangeLabel = new JLabel();
        this.lowIsotopeErrorRangeTxt = new JTextField();
        this.highIsotopeErrorRangeTxt = new JTextField();
        this.isotopeErrorRangeDividerLabel = new JLabel();
        this.numberTerminiLabel = new JLabel();
        this.maxPtmsLabel = new JLabel();
        this.maxPtmsTxt = new JTextField();
        this.terminiCmb = new JComboBox();
        this.okButton = new JButton();
        this.closeButton = new JButton();
        this.openDialogHelpJButton = new JButton();
        this.advancedSettingsWarningLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Advanced MS-GF+ Settings");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.advancedSearchSettingsPanel.setBorder(BorderFactory.createTitledBorder("Search Settings"));
        this.advancedSearchSettingsPanel.setOpaque(false);
        this.instrumentCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Low-res LCQ/LTQ", "Orbitrap/FTICR", "TOF", "Q-Exactive"}));
        this.decoyDatabaseCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.decoyDatabaseCmb.setSelectedIndex(1);
        this.decoyDatabaseLabel.setText("Search Decoy Database");
        this.instrumentLabel.setText("MS/MS Detector");
        this.fragmentationMethodLabel.setText("Fragmentation Method");
        this.fragmentationMethodCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Automatic", "CID", "ETD", "HCD"}));
        this.protocolLabel.setText("Protocol");
        this.protocolCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Automatic", "Phosphorylation", "iTRAQ", "iTRAQPhospho", "TMT", "Standard"}));
        this.minPepLengthTxt.setHorizontalAlignment(0);
        this.minPepLengthTxt.setText("6");
        this.minPepLengthTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MsgfSettingsDialog.this.minPepLengthTxtKeyReleased(evt);
            }
        });
        this.peptideLengthDividerLabel.setHorizontalAlignment(0);
        this.peptideLengthDividerLabel.setText("-");
        this.maxPepLengthTxt.setHorizontalAlignment(0);
        this.maxPepLengthTxt.setText("40");
        this.maxPepLengthTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MsgfSettingsDialog.this.maxPepLengthTxtKeyReleased(evt);
            }
        });
        this.peptideLengthLabel.setText("Peptide Length (min - max)");
        this.numberMatchesLabel.setText("Number of Spectrum Matches");
        this.numberMatchesTxt.setHorizontalAlignment(0);
        this.numberMatchesTxt.setText("1");
        this.numberMatchesTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MsgfSettingsDialog.this.numberMatchesTxtKeyReleased(evt);
            }
        });
        this.additionalOutputlLabel.setText("Additional Output");
        this.additionalOutputCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.additionalOutputCmb.setSelectedIndex(1);
        this.isotopeErrorRangeLabel.setText("Isotope Error Range");
        this.lowIsotopeErrorRangeTxt.setHorizontalAlignment(0);
        this.lowIsotopeErrorRangeTxt.setText("0");
        this.lowIsotopeErrorRangeTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MsgfSettingsDialog.this.lowIsotopeErrorRangeTxtKeyReleased(evt);
            }
        });
        this.highIsotopeErrorRangeTxt.setHorizontalAlignment(0);
        this.highIsotopeErrorRangeTxt.setText("1");
        this.highIsotopeErrorRangeTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MsgfSettingsDialog.this.highIsotopeErrorRangeTxtKeyReleased(evt);
            }
        });
        this.isotopeErrorRangeDividerLabel.setHorizontalAlignment(0);
        this.isotopeErrorRangeDividerLabel.setText("-");
        this.numberTerminiLabel.setText("Enzymatic Terminals");
        this.maxPtmsLabel.setText("Max Variable PTMs per Peptide");
        this.maxPtmsTxt.setHorizontalAlignment(0);
        this.maxPtmsTxt.setText("2");
        this.maxPtmsTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MsgfSettingsDialog.this.maxPtmsTxtKeyReleased(evt);
            }
        });
        this.terminiCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"None Required", "At Least One", "Both"}));
        this.terminiCmb.setSelectedIndex(2);
        GroupLayout advancedSearchSettingsPanelLayout = new GroupLayout(this.advancedSearchSettingsPanel);
        this.advancedSearchSettingsPanel.setLayout(advancedSearchSettingsPanelLayout);
        advancedSearchSettingsPanelLayout.setHorizontalGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.instrumentLabel, -2, 200, -2).addComponent(this.decoyDatabaseLabel, -2, 200, -2).addComponent(this.fragmentationMethodLabel, -2, 200, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fragmentationMethodCmb, 0, -1, Short.MAX_VALUE).addComponent(this.instrumentCmb, 0, -1, Short.MAX_VALUE).addComponent(this.decoyDatabaseCmb, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE))).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.protocolLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.protocolCmb, 0, -1, Short.MAX_VALUE)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.numberMatchesLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.numberMatchesTxt)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.peptideLengthLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minPepLengthTxt, -2, 71, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.peptideLengthDividerLabel, -2, 27, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxPepLengthTxt, -2, 77, -2)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.additionalOutputlLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.additionalOutputCmb, 0, -1, Short.MAX_VALUE)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.isotopeErrorRangeLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lowIsotopeErrorRangeTxt, -2, 76, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.isotopeErrorRangeDividerLabel, -2, 11, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.highIsotopeErrorRangeTxt, -2, 76, -2)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.numberTerminiLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.terminiCmb, 0, -1, Short.MAX_VALUE)).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addComponent(this.maxPtmsLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxPtmsTxt))).addContainerGap()));
        advancedSearchSettingsPanelLayout.linkSize(0, this.highIsotopeErrorRangeTxt, this.lowIsotopeErrorRangeTxt, this.maxPepLengthTxt, this.minPepLengthTxt);
        advancedSearchSettingsPanelLayout.setVerticalGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.decoyDatabaseLabel).addComponent(this.decoyDatabaseCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.instrumentCmb, -2, -1, -2).addComponent(this.instrumentLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fragmentationMethodCmb, -2, -1, -2).addComponent(this.fragmentationMethodLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.protocolCmb, -2, -1, -2).addComponent(this.protocolLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numberTerminiLabel).addComponent(this.terminiCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minPepLengthTxt, -2, -1, -2).addComponent(this.maxPepLengthTxt, -2, -1, -2).addComponent(this.peptideLengthDividerLabel).addComponent(this.peptideLengthLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxPtmsLabel).addComponent(this.maxPtmsTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lowIsotopeErrorRangeTxt, -2, -1, -2).addComponent(this.highIsotopeErrorRangeTxt, -2, -1, -2).addComponent(this.isotopeErrorRangeDividerLabel).addComponent(this.isotopeErrorRangeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numberMatchesLabel).addComponent(this.numberMatchesTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.additionalOutputlLabel).addComponent(this.additionalOutputCmb, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MsgfSettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MsgfSettingsDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.openDialogHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.openDialogHelpJButton.setToolTipText("Help");
        this.openDialogHelpJButton.setBorder(null);
        this.openDialogHelpJButton.setBorderPainted(false);
        this.openDialogHelpJButton.setContentAreaFilled(false);
        this.openDialogHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                MsgfSettingsDialog.this.openDialogHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                MsgfSettingsDialog.this.openDialogHelpJButtonMouseExited(evt);
            }
        });
        this.openDialogHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MsgfSettingsDialog.this.openDialogHelpJButtonActionPerformed(evt);
            }
        });
        this.advancedSettingsWarningLabel.setText("Click to open the MS-GF+ help page.");
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.advancedSearchSettingsPanel, -1, -1, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.openDialogHelpJButton).addGap(18, 18, 18).addComponent(this.advancedSettingsWarningLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.advancedSearchSettingsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.openDialogHelpJButton).addComponent(this.advancedSettingsWarningLabel).addComponent(this.okButton).addComponent(this.closeButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.cancelled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput(true)) {
            this.dispose();
        }
    }

    private void openDialogHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void openDialogHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void openDialogHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://bix-lab.ucsd.edu/pages/viewpage.action?pageId=13533355");
        this.setCursor(new Cursor(0));
    }

    private void minPepLengthTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxPepLengthTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void numberMatchesTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void lowIsotopeErrorRangeTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void highIsotopeErrorRangeTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxPtmsTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    public boolean validateInput(boolean showMessage) {
        boolean valid = true;
        valid = GuiUtilities.validateIntegerInput(this, this.peptideLengthLabel, this.minPepLengthTxt, "minimum peptide length", "Peptide Length Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.peptideLengthLabel, this.maxPepLengthTxt, "maximum peptide length", "Peptide Length Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.numberMatchesLabel, this.numberMatchesTxt, "number of spectrum matches", "Number Spectrum Matches Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.isotopeErrorRangeLabel, this.lowIsotopeErrorRangeTxt, "lower isotope range", "Isotope Range Error", false, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.isotopeErrorRangeLabel, this.highIsotopeErrorRangeTxt, "upper isotope range", "Isotope Range Error", false, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.maxPtmsLabel, this.maxPtmsTxt, "max number of PTMs per peptide", "Peptide PTM Error", true, showMessage, valid);
        try {
            int lowValue = Integer.parseInt(this.lowIsotopeErrorRangeTxt.getText().trim());
            int highValue = Integer.parseInt(this.highIsotopeErrorRangeTxt.getText().trim());
            if (lowValue > highValue) {
                if (showMessage && valid) {
                    JOptionPane.showMessageDialog(this, "The lower range value has to be smaller than the upper range value.", "Isotope Range Error", 2);
                }
                valid = false;
                this.isotopeErrorRangeLabel.setForeground(Color.RED);
                this.isotopeErrorRangeLabel.setToolTipText("Please select a valid range (upper < higher))");
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.okButton.setEnabled(valid);
        return valid;
    }
}

