/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.error_handlers.notification;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class NotesDialog
extends JDialog {
    private JPanel backgroundPanel;
    private JEditorPane notesEditorPane;
    private JScrollPane notesScrollPane;
    private JButton okButton;

    public NotesDialog(Frame parent, boolean modal, ArrayList<String> notes) {
        super(parent, modal);
        this.initComponents();
        String allNotes = "";
        if (notes.size() > 0) {
            for (String note : notes) {
                allNotes = allNotes + note + "<br><br>";
            }
        } else {
            allNotes = "(no current notes)";
        }
        this.notesEditorPane.setText("<html>" + allNotes + "</html>");
        this.notesEditorPane.setCaretPosition(0);
        this.notesScrollPane.getViewport().setOpaque(false);
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.okButton = new JButton();
        this.notesScrollPane = new JScrollPane();
        this.notesEditorPane = new JEditorPane();
        this.setDefaultCloseOperation(2);
        this.setUndecorated(true);
        this.setPreferredSize(new Dimension(300, 300));
        this.backgroundPanel.setBackground(new Color(255, 255, 255));
        this.backgroundPanel.setBorder(BorderFactory.createEtchedBorder());
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.notesScrollPane.setBorder(null);
        this.notesScrollPane.setOpaque(false);
        this.notesEditorPane.setEditable(false);
        this.notesEditorPane.setBorder(null);
        this.notesEditorPane.setContentType("text/html");
        this.notesEditorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                NotesDialog.this.notesEditorPaneHyperlinkUpdate(evt);
            }
        });
        this.notesScrollPane.setViewportView(this.notesEditorPane);
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.notesScrollPane).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(0, 329, Short.MAX_VALUE).addComponent(this.okButton))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.notesScrollPane, -1, 250, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton).addGap(6, 6, 6)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void notesEditorPaneHyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType().toString().equalsIgnoreCase(HyperlinkEvent.EventType.ENTERED.toString())) {
            this.setCursor(new Cursor(12));
        } else if (evt.getEventType().toString().equalsIgnoreCase(HyperlinkEvent.EventType.EXITED.toString())) {
            this.setCursor(new Cursor(0));
        } else if (evt.getEventType().toString().equalsIgnoreCase(HyperlinkEvent.EventType.ACTIVATED.toString())) {
            if (evt.getDescription().startsWith("#")) {
                this.notesEditorPane.scrollToReference(evt.getDescription());
            } else {
                this.setCursor(new Cursor(3));
                BareBonesBrowserLaunch.openURL(evt.getDescription());
                this.setCursor(new Cursor(0));
            }
        }
    }
}

