/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.Atom;
import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.protein.Header;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class Protein
extends ExperimentObject {
    static final long serialVersionUID = 1987224639519365761L;
    private String accession;
    private boolean decoy;
    private String sequence;
    private Header.DatabaseType databaseType;

    public Protein() {
    }

    public Protein(String accession, boolean isDecoy) {
        this.accession = accession;
        this.decoy = isDecoy;
    }

    public Protein(String accession, String sequence, boolean isDecoy) {
        this.accession = accession;
        this.sequence = sequence;
        this.decoy = isDecoy;
    }

    public Protein(String accession, Header.DatabaseType databaseType, String sequence, boolean isDecoy) {
        this.accession = accession;
        this.databaseType = databaseType;
        this.sequence = sequence;
        this.decoy = isDecoy;
    }

    public boolean isDecoy() {
        return this.decoy;
    }

    public String getAccession() {
        return this.accession;
    }

    public Header.DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public String getSequence() {
        return this.sequence;
    }

    public boolean isSameAs(Protein anotherProtein) {
        return this.accession.equals(anotherProtein.getAccession());
    }

    public String getProteinKey() {
        return this.accession;
    }

    public int getLength() {
        return this.sequence.length();
    }

    public int getObservableLength(Enzyme enzyme, double pepMaxLength) {
        int length = 0;
        int tempLength = 1;
        for (int i = 0; i < this.sequence.length() - 1; ++i) {
            if (enzyme.isCleavageSite(this.sequence.charAt(i), this.sequence.charAt(i + 1))) {
                if ((double)tempLength <= pepMaxLength) {
                    length += tempLength;
                }
                tempLength = 0;
            }
            ++tempLength;
        }
        if ((double)tempLength < pepMaxLength) {
            length += tempLength;
        }
        return length;
    }

    public int getNCleavageSites(Enzyme enzyme) {
        int nCleavageSites = 0;
        for (int i = 0; i < this.sequence.length() - 1; ++i) {
            if (!enzyme.isCleavageSite(this.sequence.charAt(i), this.sequence.charAt(i + 1))) continue;
            ++nCleavageSites;
        }
        return nCleavageSites;
    }

    public double computeMolecularWeight() {
        double mass = Atom.H.getMonoisotopicMass();
        for (int iaa = 0; iaa < this.sequence.length(); ++iaa) {
            char aa = this.sequence.charAt(iaa);
            try {
                if (aa == '*') continue;
                AminoAcid currentAA = AminoAcid.getAminoAcid(aa);
                mass += currentAA.monoisotopicMass;
                continue;
            }
            catch (NullPointerException e) {
                if (aa == '>') {
                    throw new IllegalArgumentException("Error parsing the sequence of " + this.accession);
                }
                throw new IllegalArgumentException("Unknown amino acid: " + aa);
            }
            catch (IllegalArgumentException e) {
                if (aa == '>') {
                    throw new IllegalArgumentException("Error parsing the sequence of " + this.accession + ". Protein sequence: " + this.sequence + ".");
                }
                throw new IllegalArgumentException("Unknown amino acid: " + aa);
            }
        }
        return mass += Atom.H.getMonoisotopicMass() + Atom.O.getMonoisotopicMass();
    }

    public ArrayList<Integer> getPeptideStart(String peptideSequence, AminoAcidPattern.MatchingType matchingType, Double massTolerance) {
        AminoAcidPattern aminoAcidPattern = new AminoAcidPattern(peptideSequence);
        return aminoAcidPattern.getIndexes(this.sequence, matchingType, massTolerance);
    }

    public boolean isNTerm(String peptideSequence, AminoAcidPattern.MatchingType matchingType, Double massTolerance) {
        AminoAcidPattern aminoAcidPattern = new AminoAcidPattern(peptideSequence);
        String subSequence = this.sequence.substring(0, peptideSequence.length());
        if (aminoAcidPattern.matches(subSequence, matchingType, massTolerance)) {
            return true;
        }
        subSequence = this.sequence.substring(0, peptideSequence.length() + 1);
        AminoAcidPattern mAminoAcidPattern = new AminoAcidPattern("M");
        mAminoAcidPattern.append(aminoAcidPattern);
        return mAminoAcidPattern.matches(subSequence, matchingType, massTolerance);
    }

    public boolean isCTerm(String peptideSequence, AminoAcidPattern.MatchingType matchingType, Double massTolerance) {
        String subSequence = this.sequence.substring(this.sequence.length() - peptideSequence.length() - 1);
        AminoAcidPattern aminoAcidPattern = new AminoAcidPattern(peptideSequence);
        return aminoAcidPattern.matches(subSequence, matchingType, massTolerance);
    }

    public boolean isEnzymaticPeptide(String peptideSequence, Enzyme enzyme, AminoAcidPattern.MatchingType matchingType, Double massTolerance) throws IOException {
        HashMap<Integer, String[]> surroundingAminoAcids = this.getSurroundingAA(peptideSequence, 1, matchingType, massTolerance);
        String firstAA = peptideSequence.charAt(0) + "";
        String lastAA = peptideSequence.charAt(peptideSequence.length() - 1) + "";
        for (int index : surroundingAminoAcids.keySet()) {
            String before = surroundingAminoAcids.get(index)[0];
            String after = surroundingAminoAcids.get(index)[1];
            if (!(enzyme.isCleavageSite(before, firstAA) && enzyme.isCleavageSite(lastAA, after) || before.length() == 0 && enzyme.isCleavageSite(lastAA, after)) && (!enzyme.isCleavageSite(before, firstAA) || after.length() != 0)) continue;
            return true;
        }
        return false;
    }

    public HashMap<Integer, String[]> getSurroundingAA(String peptide, int nAA, AminoAcidPattern.MatchingType matchingType, Double massTolerance) throws IOException {
        ArrayList<Integer> startIndexes = this.getPeptideStart(peptide, matchingType, massTolerance);
        HashMap<Integer, String[]> result = new HashMap<Integer, String[]>();
        for (int startIndex : startIndexes) {
            int aa;
            result.put(startIndex, new String[2]);
            String subsequence = "";
            int stringIndex = startIndex - 1;
            for (aa = stringIndex - nAA; aa < stringIndex; ++aa) {
                if (aa < 0 || aa >= this.sequence.length()) continue;
                subsequence = subsequence + this.sequence.charAt(aa);
            }
            result.get((Object)Integer.valueOf((int)startIndex))[0] = subsequence;
            subsequence = "";
            for (aa = stringIndex + peptide.length(); aa < stringIndex + peptide.length() + nAA; ++aa) {
                if (aa < 0 || aa >= this.sequence.length()) continue;
                subsequence = subsequence + this.sequence.charAt(aa);
            }
            result.get((Object)Integer.valueOf((int)startIndex))[1] = subsequence;
        }
        return result;
    }
}

