/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.pride.CvTerm;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class EnzymeFactory {
    private HashMap<String, Enzyme> enzymes = null;
    private static EnzymeFactory instance = null;

    private EnzymeFactory() {
    }

    public static EnzymeFactory getInstance() {
        if (instance == null) {
            instance = new EnzymeFactory();
        }
        return instance;
    }

    public ArrayList<Enzyme> getEnzymes() {
        return new ArrayList<Enzyme>(this.enzymes.values());
    }

    public Enzyme getEnzyme(String enzymeName) {
        return this.enzymes.get(enzymeName);
    }

    public void addEnzyme(Enzyme enzyme) {
        this.enzymes.put(enzyme.getName(), enzyme);
    }

    public boolean enzymeLoaded(String enzyme) {
        return this.enzymes.containsKey(enzyme);
    }

    public void importEnzymes(File enzymeFile) throws XmlPullParserException, IOException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory.setNamespaceAware(true);
        XmlPullParser parser = factory.newPullParser();
        BufferedReader br = new BufferedReader(new FileReader(enzymeFile));
        parser.setInput((Reader)br);
        int type = parser.next();
        this.enzymes = new HashMap();
        while (type != 1) {
            if (type == 2 && parser.getName().equals("enzyme")) {
                this.parseEnzyme(parser);
            }
            type = parser.next();
        }
        br.close();
    }

    private void parseEnzyme(XmlPullParser aParser) throws XmlPullParserException, IOException {
        int id;
        aParser.nextTag();
        if (!aParser.getName().equals("id")) {
            throw new XmlPullParserException("Found tag '" + aParser.getName() + "' where 'id' was expected on line " + aParser.getLineNumber() + ".");
        }
        aParser.next();
        String idString = aParser.getText();
        try {
            id = Integer.parseInt(idString.trim());
        }
        catch (NumberFormatException nfe) {
            throw new XmlPullParserException("Found non-parseable text '" + idString + "' for the value of the 'id' tag on line " + aParser.getLineNumber() + ".");
        }
        int type = aParser.next();
        while (type != 2 || !aParser.getName().equals("name")) {
            type = aParser.next();
        }
        aParser.next();
        String name = aParser.getText().trim();
        type = aParser.next();
        while (type != 2 || !aParser.getName().equals("aminoAcidBefore")) {
            type = aParser.next();
        }
        aParser.next();
        String aaBefore = aParser.getText().trim();
        type = aParser.next();
        while (type != 2 || !aParser.getName().equals("restrictionBefore")) {
            type = aParser.next();
        }
        aParser.next();
        String restrictionBefore = aParser.getText().trim();
        type = aParser.next();
        while (type != 2 || !aParser.getName().equals("aminoAcidAfter")) {
            type = aParser.next();
        }
        aParser.next();
        String aaAfter = aParser.getText().trim();
        type = aParser.next();
        while (type != 2 || !aParser.getName().equals("restrictionAfter")) {
            type = aParser.next();
        }
        aParser.next();
        String restrictionAfter = aParser.getText().trim();
        type = aParser.next();
        while (type != 2 || !aParser.getName().equals("semiSpecific")) {
            type = aParser.next();
        }
        aParser.next();
        String semiSpecificAsText = aParser.getText().trim();
        boolean semiSpecific = semiSpecificAsText.equalsIgnoreCase("yes");
        this.enzymes.put(name, new Enzyme(id, name, aaBefore, restrictionBefore, aaAfter, restrictionAfter, semiSpecific));
    }

    public static Enzyme getUtilitiesEnzyme(String prideEnzymeName) {
        Enzyme tempEnzyme = null;
        if ((prideEnzymeName = prideEnzymeName.trim().toLowerCase()).equalsIgnoreCase("trypsin")) {
            tempEnzyme = EnzymeFactory.getInstance().getEnzyme("Trypsin");
        } else if (prideEnzymeName.equalsIgnoreCase("chymotrypsin")) {
            tempEnzyme = EnzymeFactory.getInstance().getEnzyme("Chymotrypsin (FYWL)");
        } else if (prideEnzymeName.equalsIgnoreCase("arg-c") || prideEnzymeName.equalsIgnoreCase("argc") || prideEnzymeName.equalsIgnoreCase("arg c")) {
            tempEnzyme = EnzymeFactory.getInstance().getEnzyme("Arg-C");
        } else if (prideEnzymeName.equalsIgnoreCase("cnbr")) {
            tempEnzyme = EnzymeFactory.getInstance().getEnzyme("CNBr");
        } else if (prideEnzymeName.equalsIgnoreCase("formic acid")) {
            tempEnzyme = EnzymeFactory.getInstance().getEnzyme("Formic Acid");
        } else if (prideEnzymeName.equalsIgnoreCase("lys-c") || prideEnzymeName.equalsIgnoreCase("lysc") || prideEnzymeName.equalsIgnoreCase("lys c")) {
            tempEnzyme = EnzymeFactory.getInstance().getEnzyme("Lys-C");
        } else if (prideEnzymeName.equalsIgnoreCase("lys-c/p") || prideEnzymeName.equalsIgnoreCase("lysc/p") || prideEnzymeName.equalsIgnoreCase("lys c/p")) {
            tempEnzyme = EnzymeFactory.getInstance().getEnzyme("Lys-C, no P rule");
        } else if (prideEnzymeName.equalsIgnoreCase("pepsin a") || prideEnzymeName.equalsIgnoreCase("pepsin")) {
            tempEnzyme = EnzymeFactory.getInstance().getEnzyme("Pepsin A");
        } else if (prideEnzymeName.equalsIgnoreCase("trypsin + cnbr")) {
            tempEnzyme = EnzymeFactory.getInstance().getEnzyme("Trypsin + CNBr");
        } else if (prideEnzymeName.equalsIgnoreCase("trypsin + chymotrypsin")) {
            tempEnzyme = EnzymeFactory.getInstance().getEnzyme("Trypsin + Chymotrypsin ((FYWLKR))");
        } else if (prideEnzymeName.equalsIgnoreCase("trypsin, no p rule")) {
            tempEnzyme = EnzymeFactory.getInstance().getEnzyme("Trypsin, no P rule");
        } else if (prideEnzymeName.equalsIgnoreCase("whole protein")) {
            tempEnzyme = EnzymeFactory.getInstance().getEnzyme("Whole Protein");
        } else if (prideEnzymeName.equalsIgnoreCase("asp-n") || prideEnzymeName.equalsIgnoreCase("aspn") || prideEnzymeName.equalsIgnoreCase("asp n")) {
            tempEnzyme = EnzymeFactory.getInstance().getEnzyme("Asp-N");
        } else if (prideEnzymeName.equalsIgnoreCase("glu-c") || prideEnzymeName.equalsIgnoreCase("gluc") || prideEnzymeName.equalsIgnoreCase("glu c")) {
            tempEnzyme = EnzymeFactory.getInstance().getEnzyme("Glu-C");
        } else if (prideEnzymeName.equalsIgnoreCase("asp-n + glu-c")) {
            tempEnzyme = EnzymeFactory.getInstance().getEnzyme("Asp-N + Glu-C");
        } else if (prideEnzymeName.equalsIgnoreCase("top-down")) {
            tempEnzyme = EnzymeFactory.getInstance().getEnzyme("Top-Down");
        } else if (prideEnzymeName.equalsIgnoreCase("semi-tryptic")) {
            tempEnzyme = EnzymeFactory.getInstance().getEnzyme("Semi-Tryptic");
        } else if (prideEnzymeName.equalsIgnoreCase("no enzyme")) {
            tempEnzyme = EnzymeFactory.getInstance().getEnzyme("No Enzyme");
        } else if (prideEnzymeName.equalsIgnoreCase("chymotrypsin, no p rule")) {
            tempEnzyme = EnzymeFactory.getInstance().getEnzyme("Chymotrypsin, no P rule (FYWL)");
        } else if (prideEnzymeName.equalsIgnoreCase("asp-n de") || prideEnzymeName.equalsIgnoreCase("aspn de") || prideEnzymeName.equalsIgnoreCase("asp n de")) {
            tempEnzyme = EnzymeFactory.getInstance().getEnzyme("Asp-N (DE)");
        } else if (prideEnzymeName.equalsIgnoreCase("glu-c de") || prideEnzymeName.equalsIgnoreCase("gluc de") || prideEnzymeName.equalsIgnoreCase("glu c de")) {
            tempEnzyme = EnzymeFactory.getInstance().getEnzyme("Glu-C (DE)");
        } else if (prideEnzymeName.equalsIgnoreCase("lys-n k") || prideEnzymeName.equalsIgnoreCase("lys-n")) {
            tempEnzyme = EnzymeFactory.getInstance().getEnzyme("Lys-N (K)");
        } else if (prideEnzymeName.equalsIgnoreCase("thermolysin")) {
            tempEnzyme = EnzymeFactory.getInstance().getEnzyme("Thermolysin, no P rule");
        } else if (prideEnzymeName.equalsIgnoreCase("semi-chymotrypsin")) {
            tempEnzyme = EnzymeFactory.getInstance().getEnzyme("Semi-Chymotrypsin (FYWL)");
        } else if (prideEnzymeName.equalsIgnoreCase("semi glu-c") || prideEnzymeName.equalsIgnoreCase("semi gluc") || prideEnzymeName.equalsIgnoreCase("semi glu c")) {
            tempEnzyme = EnzymeFactory.getInstance().getEnzyme("Semi-Glu-C");
        }
        return tempEnzyme;
    }

    public void writeMsAmandaEnzymeFile(File file) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        String toWrite = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
        bw.write(toWrite);
        bw.newLine();
        bw.write("<enzymes>");
        bw.newLine();
        for (Enzyme enzyme : this.getEnzymes()) {
            String position;
            bw.write("  <enzyme>");
            bw.newLine();
            bw.write("    <name>" + enzyme.getName() + "</name>");
            bw.newLine();
            String cleavageSite = "";
            String inhibitors = "";
            if (!enzyme.getAminoAcidBefore().isEmpty()) {
                position = "after";
                for (Character aminoAcid : enzyme.getAminoAcidBefore()) {
                    cleavageSite = cleavageSite + aminoAcid;
                }
                for (Character aminoAcid : enzyme.getRestrictionAfter()) {
                    inhibitors = inhibitors + aminoAcid;
                }
            } else {
                position = "before";
                for (Character aminoAcid : enzyme.getAminoAcidAfter()) {
                    cleavageSite = cleavageSite + aminoAcid;
                }
                for (Character aminoAcid : enzyme.getRestrictionBefore()) {
                    inhibitors = inhibitors + aminoAcid;
                }
            }
            bw.write("    <cleavage_sites>" + cleavageSite + "</cleavage_sites>");
            bw.newLine();
            if (!inhibitors.isEmpty()) {
                bw.write("    <inhibitors>" + inhibitors + "</inhibitors>");
                bw.newLine();
            }
            bw.write("    <position>" + position + "</position>");
            bw.newLine();
            bw.write("  </enzyme>");
            bw.newLine();
        }
        bw.write("</enzymes>");
        bw.flush();
        bw.close();
    }

    public static CvTerm getEnzymeCvTerm(Enzyme enzyme) {
        if (enzyme == null) {
            return null;
        }
        CvTerm cvTerm = null;
        String enzymeName = enzyme.getName();
        if (enzymeName.equalsIgnoreCase("Trypsin") || enzymeName.equalsIgnoreCase("Semi-Tryptic")) {
            cvTerm = new CvTerm("PSI-MS", "MS:1001251", enzymeName, null);
        } else if (enzymeName.equalsIgnoreCase("No Enzyme")) {
            cvTerm = new CvTerm("PSI-MS", "MS:1001091", enzymeName, null);
        } else if (enzymeName.equalsIgnoreCase("Arg-C")) {
            cvTerm = new CvTerm("PSI-MS", "MS:1001303", enzymeName, null);
        } else if (enzymeName.equalsIgnoreCase("Asp-N")) {
            cvTerm = new CvTerm("PSI-MS", "MS:1001304", enzymeName, null);
        } else if (enzymeName.equalsIgnoreCase("Asp-N_ambic")) {
            cvTerm = new CvTerm("PSI-MS", "MS:1001305", enzymeName, null);
        } else if (enzymeName.equalsIgnoreCase("Chymotrypsin (FYWL)") || enzymeName.equalsIgnoreCase("Semi-Chymotrypsin (FYWL)")) {
            cvTerm = new CvTerm("PSI-MS", "MS:1001306", enzymeName, null);
        } else if (enzymeName.equalsIgnoreCase("CNBr")) {
            cvTerm = new CvTerm("PSI-MS", "MS:1001307", enzymeName, null);
        } else if (enzymeName.equalsIgnoreCase("Formic Acid")) {
            cvTerm = new CvTerm("PSI-MS", "MS:1001308", enzymeName, null);
        } else if (enzymeName.equalsIgnoreCase("Lys-C")) {
            cvTerm = new CvTerm("PSI-MS", "MS:1001309", enzymeName, null);
        } else if (enzymeName.equalsIgnoreCase("Lys-C, no P rule")) {
            cvTerm = new CvTerm("PSI-MS", "MS:1001310", enzymeName, null);
        } else if (enzymeName.equalsIgnoreCase("Pepsin A")) {
            cvTerm = new CvTerm("PSI-MS", "MS:1001311", enzymeName, null);
        } else if (enzymeName.equalsIgnoreCase("Whole Protein") || enzymeName.equalsIgnoreCase("Top-Down")) {
            cvTerm = new CvTerm("PSI-MS", "MS:1001955", enzymeName, null);
        }
        return cvTerm;
    }
}

