/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.biology.atoms.Carbon;
import com.compomics.util.experiment.biology.atoms.Hydrogen;
import com.compomics.util.experiment.biology.atoms.Nitrogen;
import com.compomics.util.experiment.biology.atoms.Oxygen;
import com.compomics.util.experiment.biology.atoms.Phosphorus;
import com.compomics.util.experiment.biology.atoms.Sulfur;
import com.compomics.util.experiment.personalization.ExperimentObject;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class Atom
extends ExperimentObject {
    public static final Atom H = new Hydrogen();
    public static final Atom N = new Nitrogen();
    public static final Atom O = new Oxygen();
    public static final Atom C = new Carbon();
    public static final Atom S = new Sulfur();
    public static final Atom P = new Phosphorus();
    protected HashMap<Integer, Double> isotopeMap;
    protected HashMap<Integer, Double> representativeComposition;
    protected String name;
    protected String letter;

    public Double getMonoisotopicMass() {
        return this.getIsotopeMass(0);
    }

    public String getName() {
        return this.name;
    }

    public String getLetter() {
        return this.letter;
    }

    public ArrayList<Integer> getImplementedIsotopes() {
        if (this.isotopeMap != null) {
            return new ArrayList<Integer>(this.isotopeMap.keySet());
        }
        return new ArrayList<Integer>();
    }

    public Double getIsotopeMass(int isotopeNumber) {
        if (this.isotopeMap != null) {
            return this.isotopeMap.get(isotopeNumber);
        }
        return null;
    }

    public Double getDifferenceToMonoisotopic(int isotopeNumber) {
        Double isotopeMass = null;
        if (this.isotopeMap != null) {
            isotopeMass = this.isotopeMap.get(isotopeNumber);
        }
        if (isotopeMass == null) {
            throw new IllegalArgumentException("No isotope mass found for isotope " + isotopeNumber + " of atom " + this.name + ".");
        }
        return isotopeMass - this.getMonoisotopicMass();
    }
}

