/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.util.mascot;

import com.compomics.mascotdatfile.util.interfaces.QueryToPeptideMapInf;
import com.compomics.mascotdatfile.util.mascot.ModificationList;
import com.compomics.mascotdatfile.util.mascot.PeptideHit;
import com.compomics.mascotdatfile.util.mascot.ProteinHit;
import com.compomics.mascotdatfile.util.mascot.ProteinMap;
import com.compomics.mascotdatfile.util.mascot.Query;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryToPeptideMap
implements QueryToPeptideMapInf {
    private static Logger logger = Logger.getLogger(QueryToPeptideMap.class);
    private HashMap iPeptideMap = null;
    private double[] iAverageQueryThresholds = null;
    private int iNumberOfQueries = 0;

    public QueryToPeptideMap(HashMap aPeptidesSection, ProteinMap aProteinMap, int aNumberOfQueries, ModificationList aMod, double[][] aThreshold) {
        this.iNumberOfQueries = aNumberOfQueries;
        this.iPeptideMap = this.generatePeptideMap(aPeptidesSection, aProteinMap, aNumberOfQueries, aMod, aThreshold);
    }

    public QueryToPeptideMap(HashMap aPeptidesSection, HashMap aETSPeptidesSection, ProteinMap aProteinMap, int aNumberOfQueries, ModificationList aModificationList, double[][] aThresholds) {
        this.iNumberOfQueries = aNumberOfQueries;
        this.iPeptideMap = this.generatePeptideMap(aPeptidesSection, aETSPeptidesSection, aProteinMap, aNumberOfQueries, aModificationList, aThresholds);
    }

    private HashMap generatePeptideMap(HashMap aPeptidesSection, HashMap aETSPeptidesSection, ProteinMap aProteinMap, int aNumberOfQueries, ModificationList aModificationList, double[][] aThresholds) {
        HashMap lFirstDimension = new HashMap(aNumberOfQueries);
        if (aPeptidesSection != null && aETSPeptidesSection != null) {
            for (int i = 1; i <= aNumberOfQueries; ++i) {
                Vector<PeptideHit> lSecondDimension = new Vector<PeptideHit>();
                int lCount = 1;
                double[] lThreshold = this.getQueryThresholdValues(i, aThresholds, aNumberOfQueries);
                while (aPeptidesSection.get("q" + i + "_p" + lCount) != null) {
                    String lNonETS_PeptideHitString = (String)aPeptidesSection.get("q" + i + "_p" + lCount);
                    PeptideHit lNonETS_PeptideHit = null;
                    if (!lNonETS_PeptideHitString.equals("-1")) {
                        lNonETS_PeptideHit = PeptideHit.parsePeptideHit(lNonETS_PeptideHitString, aProteinMap, aModificationList, lThreshold);
                    }
                    String lETSPeptideHitString = (String)aETSPeptidesSection.get("q" + i + "_p" + lCount);
                    PeptideHit lETS_PeptideHit = null;
                    if (lETSPeptideHitString != null && !lETSPeptideHitString.equals("-1")) {
                        String lETSPeptideHitMods = (String)aETSPeptidesSection.get("q" + i + "_p" + lCount + "_et_mods");
                        lETS_PeptideHit = PeptideHit.parsePeptideHit(lETSPeptideHitString, lETSPeptideHitMods, aProteinMap, aModificationList, lThreshold);
                    }
                    if (lNonETS_PeptideHit != null || lETS_PeptideHit != null) {
                        PeptideHit lStrongestPeptideHit = null;
                        lStrongestPeptideHit = lETS_PeptideHit == null ? lNonETS_PeptideHit : (lNonETS_PeptideHit == null ? lETS_PeptideHit : (lETS_PeptideHit.getIonsScore() >= lNonETS_PeptideHit.getIonsScore() ? lETS_PeptideHit : lNonETS_PeptideHit));
                        lSecondDimension.add(lStrongestPeptideHit);
                        lStrongestPeptideHit = (PeptideHit)lSecondDimension.get(lCount - 1);
                        int lNumberOfProteinHits = lStrongestPeptideHit.getProteinHits().size();
                        for (int k = 0; k < lNumberOfProteinHits; ++k) {
                            ProteinHit lProteinHit = (ProteinHit)lStrongestPeptideHit.getProteinHits().get(k);
                            aProteinMap.addProteinSource(lProteinHit.getAccession(), i, lCount);
                        }
                    }
                    ++lCount;
                }
                if (lSecondDimension.size() == 0) {
                    lSecondDimension = null;
                }
                lFirstDimension.put("q" + i, lSecondDimension);
            }
        }
        return lFirstDimension;
    }

    private HashMap generatePeptideMap(HashMap m, ProteinMap aProteinMap, int aNumberOfQueries, ModificationList aMod, double[][] aThreshold) {
        HashMap lFirstDimension = new HashMap(aNumberOfQueries);
        if (m != null) {
            for (int i = 1; i <= aNumberOfQueries; ++i) {
                Vector<PeptideHit> lSecondDimension = new Vector<PeptideHit>();
                Pattern findMoreThanOneVariable = Pattern.compile(".*X.*X.*");
                int lCount = 1;
                int lCountBackwards = 1;
                double[] lThreshold = this.getQueryThresholdValues(i, aThreshold, aNumberOfQueries);
                while (m.get("q" + i + "_p" + lCount) != null && !m.get("q" + i + "_p" + lCount).equals("-1")) {
                    if (m.get("q" + i + "_p" + lCount + "_subst") != null) {
                        lSecondDimension.add(PeptideHit.parsePeptideHit((String)m.get("q" + i + "_p" + lCount), aProteinMap, aMod, lThreshold, (String)m.get("q" + i + "_p" + lCount + "_subst")));
                    } else {
                        lSecondDimension.add(PeptideHit.parsePeptideHit((String)m.get("q" + i + "_p" + lCount), aProteinMap, aMod, lThreshold));
                    }
                    PeptideHit lPeptideHit = (PeptideHit)lSecondDimension.get(lCount - lCountBackwards);
                    int lNumberOfProteinHits = lPeptideHit.getProteinHits().size();
                    for (int k = 0; k < lNumberOfProteinHits; ++k) {
                        ProteinHit lProteinHit = (ProteinHit)lPeptideHit.getProteinHits().get(k);
                        aProteinMap.addProteinSource(lProteinHit.getAccession(), i, lCount);
                    }
                    ++lCount;
                }
                if (lSecondDimension.size() == 0) {
                    lSecondDimension = null;
                }
                lFirstDimension.put("q" + i, lSecondDimension);
            }
        }
        return lFirstDimension;
    }

    private double[] getQueryThresholdValues(int aQueryNumber, double[][] aThreshold, int aNumberOfQueries) {
        double lIdentityThreshold = 0.0;
        double lHomologyThreshold = 0.0;
        if (aThreshold[aQueryNumber - 1][1] < 4.0) {
            if (this.iAverageQueryThresholds == null) {
                this.iAverageQueryThresholds = new double[2];
                double lSumOfHomology = 0.0;
                double lSumOfIdentity = 0.0;
                int count = 0;
                for (int i = 0; i < aNumberOfQueries; ++i) {
                    if (aThreshold[i][0] == 0.0 || aThreshold[i][1] == 0.0) {
                        ++count;
                        continue;
                    }
                    lSumOfHomology += aThreshold[i][0];
                    lSumOfIdentity += aThreshold[i][1];
                }
                this.iAverageQueryThresholds[0] = lSumOfHomology / (double)(aNumberOfQueries - count);
                this.iAverageQueryThresholds[1] = lSumOfIdentity / (double)(aNumberOfQueries - count);
            }
            lHomologyThreshold = this.iAverageQueryThresholds[0];
            lIdentityThreshold = this.iAverageQueryThresholds[1];
        } else {
            lHomologyThreshold = aThreshold[aQueryNumber - 1][0];
            lIdentityThreshold = aThreshold[aQueryNumber - 1][1];
        }
        return new double[]{lHomologyThreshold, lIdentityThreshold};
    }

    @Override
    public int getNumberOfQueries() {
        return this.iNumberOfQueries;
    }

    public HashMap getPeptideMap() {
        return this.iPeptideMap;
    }

    @Override
    public PeptideHit getPeptideHitOfOneQuery(int aQueryNumber, int aPeptideHitNumber) {
        PeptideHit ph = null;
        Vector lPeptideHits = this.getAllPeptideHits(aQueryNumber);
        if (lPeptideHits != null && aPeptideHitNumber - 1 < lPeptideHits.size() && lPeptideHits.get(aPeptideHitNumber - 1) != null) {
            ph = (PeptideHit)lPeptideHits.get(aPeptideHitNumber - 1);
        }
        return ph;
    }

    public Vector getAllPeptideHits(int aQueryNumber) {
        return (Vector)this.iPeptideMap.get("q" + aQueryNumber);
    }

    @Override
    public int getNumberOfPeptideHits(int aQueryNumber) {
        Vector v = (Vector)this.iPeptideMap.get("q" + aQueryNumber);
        int size = 0;
        if (v != null) {
            size = v.size();
        }
        return size;
    }

    public Vector getBestPeptideHits() {
        return this.getPeptideHits(1);
    }

    public Vector getPeptideHits(int aPeptideHitNumber) {
        Vector<PeptideHit> lBestPeptideHits = new Vector<PeptideHit>(this.iNumberOfQueries);
        for (int i = 1; i <= this.iNumberOfQueries; ++i) {
            lBestPeptideHits.add(this.getPeptideHitOfOneQuery(i, aPeptideHitNumber));
        }
        return lBestPeptideHits;
    }

    @Override
    public PeptideHit getPeptideHitOfOneQuery(int aQueryNumber) {
        PeptideHit ph = null;
        Vector lPeptideHits = this.getAllPeptideHits(aQueryNumber);
        if (lPeptideHits != null) {
            ph = (PeptideHit)lPeptideHits.get(0);
        }
        return ph;
    }

    public Vector getAllPeptideHitsAboveIdentityThreshold() {
        return this.getAllPeptideHitsAboveIdentityThreshold(0.05);
    }

    public Vector getAllPeptideHitsAboveIdentityThreshold(double aConfidence) {
        Vector<PeptideHit> lPeptideHitsAboveThreshold = new Vector<PeptideHit>();
        Vector lAllBestPeptideHits = this.getBestPeptideHits();
        for (int i = 0; i < lAllBestPeptideHits.size(); ++i) {
            PeptideHit temp = (PeptideHit)lAllBestPeptideHits.get(i);
            if (temp == null || !temp.scoresAboveIdentityThreshold(aConfidence)) continue;
            lPeptideHitsAboveThreshold.add(temp);
        }
        return lPeptideHitsAboveThreshold;
    }

    public Vector getPeptideHitsAboveIdentityThreshold(int aQueryNumber) {
        return this.getPeptideHitsAboveIdentityThreshold(aQueryNumber, 0.05);
    }

    public Vector getPeptideHitsAboveIdentityThreshold(int aQueryNumber, double aConfidenceInterval) {
        Vector lPeptideHits = this.getAllPeptideHits(aQueryNumber);
        Vector<PeptideHit> lResult = new Vector<PeptideHit>();
        if (lPeptideHits != null) {
            for (int i = 0; i < lPeptideHits.size(); ++i) {
                PeptideHit lPeptideHit = (PeptideHit)lPeptideHits.elementAt(i);
                if (!lPeptideHit.scoresAboveIdentityThreshold(aConfidenceInterval)) continue;
                lResult.add(lPeptideHit);
            }
        }
        return lResult;
    }

    @Override
    public List getIdentifiedQueries(double aConfidence, List<Query> aCompleteQueryList) {
        ArrayList<Query> lIdentifiedQueries = new ArrayList<Query>();
        AbstractList lTempPeptideHits = new ArrayList();
        for (int i = 0; i < aCompleteQueryList.size(); ++i) {
            int lQueryNumber = i + 1;
            lTempPeptideHits = this.getPeptideHitsAboveIdentityThreshold(lQueryNumber, aConfidence);
            if (lTempPeptideHits.size() <= 0) continue;
            lIdentifiedQueries.add(aCompleteQueryList.get(i));
        }
        return lIdentifiedQueries;
    }

    @Override
    public void buildProteinMap() {
    }
}

