/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.util.mascot;

import com.compomics.mascotdatfile.util.exception.MascotDatfileException;
import com.compomics.mascotdatfile.util.interfaces.Spectrum;
import com.compomics.mascotdatfile.util.mascot.Parameters;
import com.compomics.mascotdatfile.util.mascot.Peak;
import java.io.Serializable;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class Query
implements Spectrum,
Serializable {
    private static Logger logger = Logger.getLogger(Query.class);
    private String iTitle = null;
    private String iRetentionTimeInSeconds = null;
    private double iPrecursorMZ = 0.0;
    private String iCharge = null;
    private double iPrecursorMass = 0.0;
    private double iPrecursorIntensity = 0.0;
    private double iMinMZ = 0.0;
    private double iMaxMZ = 0.0;
    private double iMinIntensity = 0.0;
    private double iMaxIntensity = 0.0;
    private int iNumberOfPeaks = 0;
    private int iNumberUsed1 = -1;
    private Peak[] iPeakList = null;
    private int iQueryNumber = 0;
    private String iScans = null;
    private static boolean iDistillerFilenameConversion = false;
    private Parameters iParameters = null;

    public Query(HashMap aQueryMap, double aPrecursorMZ, String aCharge, double aPrecursorMass, double aPrecursorIntensity, int aQueryNumber) {
        this.parseQueryHashMap(aQueryMap, aQueryNumber);
        this.iPrecursorMZ = aPrecursorMZ;
        this.iCharge = aCharge;
        this.iPrecursorMass = aPrecursorMass;
        this.iPrecursorIntensity = aPrecursorIntensity;
    }

    public Query(HashMap aQueryMap, double aPrecursorMZ, String aCharge, double aPrecursorMass, double aPrecursorIntensity, int aQueryNumber, Parameters aParameters) {
        this.iParameters = aParameters;
        this.parseQueryHashMap(aQueryMap, aQueryNumber);
        this.iPrecursorMZ = aPrecursorMZ;
        this.iCharge = aCharge;
        this.iPrecursorMass = aPrecursorMass;
        this.iPrecursorIntensity = aPrecursorIntensity;
    }

    private void parseQueryHashMap(HashMap aQueryMap, int aQueryNumber) {
        if (aQueryMap.containsKey("Ions1")) {
            this.iMinMZ = Double.parseDouble((String)aQueryMap.get("mass_min"));
            this.iMaxMZ = Double.parseDouble((String)aQueryMap.get("mass_max"));
            this.iMinIntensity = Double.parseDouble((String)aQueryMap.get("int_min"));
            this.iMaxIntensity = Double.parseDouble((String)aQueryMap.get("int_max"));
            this.iNumberOfPeaks = Integer.parseInt((String)aQueryMap.get("num_vals"));
            this.iNumberUsed1 = Integer.parseInt((String)aQueryMap.get("num_used1"));
            this.iPeakList = this.getPeakArray(aQueryMap);
        }
        this.iQueryNumber = aQueryNumber;
        if (aQueryMap.containsKey("scans")) {
            this.iScans = (String)aQueryMap.get("scans");
        }
        if (aQueryMap.containsKey("charge")) {
            this.iCharge = (String)aQueryMap.get("charge");
        }
        this.iTitle = aQueryMap.containsKey("title") ? this.parseTitle((String)aQueryMap.get("title")) : "No title (Query " + aQueryNumber + ").";
        if (aQueryMap.containsKey("rtinseconds")) {
            this.iRetentionTimeInSeconds = (String)aQueryMap.get("rtinseconds");
        }
    }

    private String parseTitle(String aTitle) {
        String tempTitle = aTitle;
        int percentLoc = -1;
        while ((percentLoc = tempTitle.indexOf("%20")) >= 0) {
            tempTitle = tempTitle.substring(0, percentLoc) + " " + tempTitle.substring(percentLoc + 3, tempTitle.length());
        }
        int dotLoc = -1;
        while ((dotLoc = tempTitle.toLowerCase().indexOf("%2e")) >= 0) {
            tempTitle = tempTitle.substring(0, dotLoc) + "." + tempTitle.substring(dotLoc + 3, tempTitle.length());
        }
        int minusLoc = -1;
        while ((minusLoc = tempTitle.toLowerCase().indexOf("%2d")) >= 0) {
            tempTitle = tempTitle.substring(0, minusLoc) + "-" + tempTitle.substring(minusLoc + 3, tempTitle.length());
        }
        int plusLoc = -1;
        while ((plusLoc = tempTitle.toLowerCase().indexOf("%2b")) >= 0) {
            tempTitle = tempTitle.substring(0, plusLoc) + "+" + tempTitle.substring(plusLoc + 3, tempTitle.length());
        }
        int commaLoc = -1;
        while ((commaLoc = tempTitle.toLowerCase().indexOf("%2c")) >= 0) {
            tempTitle = tempTitle.substring(0, commaLoc) + "," + tempTitle.substring(commaLoc + 3, tempTitle.length());
        }
        int loconLoc = -1;
        while ((loconLoc = tempTitle.toLowerCase().indexOf("%3a")) >= 0) {
            tempTitle = tempTitle.substring(0, loconLoc) + ":" + tempTitle.substring(loconLoc + 3, tempTitle.length());
        }
        int backslashloc = -1;
        while ((backslashloc = tempTitle.toLowerCase().indexOf("%5c")) >= 0) {
            tempTitle = tempTitle.substring(0, backslashloc) + "\\" + tempTitle.substring(backslashloc + 3, tempTitle.length());
        }
        int leftBracketLoc = -1;
        while ((leftBracketLoc = tempTitle.toLowerCase().indexOf("%5b")) >= 0) {
            tempTitle = tempTitle.substring(0, leftBracketLoc) + "[" + tempTitle.substring(leftBracketLoc + 3, tempTitle.length());
        }
        int rightBracketLoc = -1;
        while ((rightBracketLoc = tempTitle.toLowerCase().indexOf("%5d")) >= 0) {
            tempTitle = tempTitle.substring(0, rightBracketLoc) + "]" + tempTitle.substring(rightBracketLoc + 3, tempTitle.length());
        }
        int leftRoundBracketLoc = -1;
        while ((leftRoundBracketLoc = tempTitle.toLowerCase().indexOf("%28")) >= 0) {
            tempTitle = tempTitle.substring(0, leftRoundBracketLoc) + "(" + tempTitle.substring(leftRoundBracketLoc + 3, tempTitle.length());
        }
        int rightRoundBracketLoc = -1;
        while ((rightRoundBracketLoc = tempTitle.toLowerCase().indexOf("%29")) >= 0) {
            tempTitle = tempTitle.substring(0, rightRoundBracketLoc) + ")" + tempTitle.substring(rightRoundBracketLoc + 3, tempTitle.length());
        }
        int equalSignLoc = -1;
        while ((equalSignLoc = tempTitle.toLowerCase().indexOf("%3d")) >= 0) {
            tempTitle = tempTitle.substring(0, equalSignLoc) + "=" + tempTitle.substring(equalSignLoc + 3, tempTitle.length());
        }
        if (iDistillerFilenameConversion) {
            tempTitle = this.processMGFTitleToFilename(tempTitle);
        }
        this.iTitle = tempTitle;
        return this.iTitle;
    }

    public double[] getMZArray() {
        double[] lMZArray = new double[this.iPeakList.length];
        for (int i = 0; i < this.iPeakList.length; ++i) {
            lMZArray[i] = this.iPeakList[i].getMZ();
        }
        return lMZArray;
    }

    public String getScans() {
        return this.iScans;
    }

    public double[] getIntensityArray() {
        double[] lIntensityArray = new double[this.iPeakList.length];
        for (int i = 0; i < this.iPeakList.length; ++i) {
            lIntensityArray[i] = this.iPeakList[i].getIntensity();
        }
        return lIntensityArray;
    }

    public String getTitle() {
        return this.iTitle;
    }

    public void setTitle(String aTitle) {
        this.iTitle = aTitle;
    }

    public String getRetentionTimeInSeconds() {
        return this.iRetentionTimeInSeconds;
    }

    public void setRetentionTimeInSeconds(String iRetentionTimeInSeconds) {
        this.iRetentionTimeInSeconds = iRetentionTimeInSeconds;
    }

    public String getChargeString() {
        return this.iCharge;
    }

    public double getPrecursorMZ() {
        return this.iPrecursorMZ;
    }

    public double getPrecursorMass() {
        return this.iPrecursorMass;
    }

    public double getPrecursorIntensity() {
        return this.iPrecursorIntensity;
    }

    public void setChargeString(String aCharge) {
        this.iCharge = aCharge;
    }

    public static void setDistillerFilenameProcessing(boolean status) {
        iDistillerFilenameConversion = status;
    }

    public double getMinMZ() {
        return this.iMinMZ;
    }

    public void setMinMZ(double aMinMZ) {
        this.iMinMZ = aMinMZ;
    }

    public double getMaxMZ() {
        return this.iMaxMZ;
    }

    public void setMaxMZ(double aMaxMZ) {
        this.iMaxMZ = aMaxMZ;
    }

    public double getMinIntensity() {
        return this.iMinIntensity;
    }

    public void setMinIntensity(double aMinIntensity) {
        this.iMinIntensity = aMinIntensity;
    }

    public double getMaxIntensity() {
        return this.iMaxIntensity;
    }

    public void setMaxIntensity(double aMaxIntensity) {
        this.iMaxIntensity = aMaxIntensity;
    }

    public int getNumberOfPeaks() {
        return this.iNumberOfPeaks;
    }

    public void setNumberOfPeaks(int aNumberOfPeaks) {
        this.iNumberOfPeaks = aNumberOfPeaks;
    }

    public int getNumberUsed1() {
        return this.iNumberUsed1;
    }

    public void setNumberUsed1(int aNumberUsed1) {
        this.iNumberUsed1 = aNumberUsed1;
    }

    private Peak[] getPeakArray(HashMap aQueryMap) {
        String lPeakList = (String)aQueryMap.get("Ions1");
        if (lPeakList != null) {
            Peak[] lPeakArray = new Peak[this.iNumberOfPeaks];
            int lCount = 0;
            StringTokenizer st = new StringTokenizer(lPeakList, ",");
            while (st.hasMoreTokens()) {
                StringTokenizer tempSt = new StringTokenizer(st.nextToken(), ":");
                if (tempSt.countTokens() != 2) {
                    throw new MascotDatfileException("The tempSt should contain just 2 elements (mass:intensity) , now it contains " + tempSt.countTokens() + "elements. ");
                }
                lPeakArray[lCount] = new Peak(Double.parseDouble(tempSt.nextToken()), Double.parseDouble(tempSt.nextToken()));
                ++lCount;
            }
            return lPeakArray;
        }
        return null;
    }

    public Peak[] getPeakList() {
        return this.iPeakList;
    }

    public String getFilename() {
        return this.iTitle;
    }

    public void setPeakList(Peak[] aPeakList) {
        this.iPeakList = aPeakList;
    }

    public int getQueryNumber() {
        return this.iQueryNumber;
    }

    public void setQueryNumber(int aQueryNumber) {
        this.iQueryNumber = aQueryNumber;
    }

    public int getNumberOfBins() {
        int lCount = 1;
        for (int i = 0; i < this.iPeakList.length && this.iPeakList[i].getMZ() < this.iPeakList[i + 1].getMZ(); ++i) {
            ++lCount;
        }
        return lCount;
    }

    private String processMGFTitleToFilename(String aTitle) {
        boolean lMultiFile = this.iParameters.isDistillerMultiFile();
        String[] lMultiFileNames = this.iParameters.getDistillerMultiFileNames();
        return Query.processMGFTitleToFilename(aTitle, lMultiFile, lMultiFileNames, this.iScans, this.iCharge);
    }

    public static String processMGFTitleToFilename(String aTitle, boolean aMutliFile, String[] aMultiFileNames, String aScans, String aCharge) {
        String lLCRun = null;
        int lCompound = -1;
        int lBeginScan = -1;
        int lEndScan = -1;
        int lSumOfScans = 1;
        int lCharge = -1;
        if (aMutliFile) {
            String lTemp = aTitle.substring(aTitle.lastIndexOf("[") + 1, aTitle.lastIndexOf("]"));
            if (lTemp.indexOf(",") > 0) {
                lTemp = lTemp.substring(0, lTemp.indexOf(","));
            }
            int lIindex = Integer.valueOf(lTemp);
            String lFileName = aMultiFileNames[lIindex];
            int lStart = lFileName.lastIndexOf("\\") + 1;
            int lEnd = lFileName.lastIndexOf(".");
            lLCRun = lFileName.substring(lStart, lEnd);
        } else {
            lLCRun = aTitle.lastIndexOf(92) == -1 || aTitle.lastIndexOf(46) == -1 ? "lcrun" : aTitle.substring(aTitle.lastIndexOf(92) + 1, aTitle.lastIndexOf(46));
        }
        if (aTitle.indexOf("TITLE=") == 0) {
            aTitle = aTitle.substring(6);
        }
        lCompound = aTitle.indexOf(58) != -1 && aTitle.substring(0, aTitle.indexOf(58)).matches("-?\\d+(\\.\\d+)?") ? Integer.valueOf(aTitle.substring(0, aTitle.indexOf(58))) : -1;
        if (aTitle.substring(aTitle.indexOf(58) + 1).trim().startsWith("Sum")) {
            if (aMutliFile) {
                lBeginScan = Integer.valueOf(aScans.substring(aScans.indexOf("=") + 1, aScans.indexOf("-")));
                lEndScan = Integer.valueOf(aScans.substring(aScans.indexOf("-") + 1));
            } else if (aScans == null) {
                lBeginScan = Integer.valueOf(aTitle.substring(aTitle.indexOf("range ") + 6, aTitle.indexOf(" (rt=")));
                lEndScan = Integer.valueOf(aTitle.substring(aTitle.indexOf(") to ") + 5, aTitle.lastIndexOf(" (rt=")));
            } else {
                lBeginScan = Integer.valueOf(aScans.substring(aScans.indexOf("=") + 1, aScans.indexOf("-")));
                lEndScan = Integer.valueOf(aScans.substring(aScans.indexOf("-") + 1));
            }
            lSumOfScans = Integer.valueOf(aTitle.substring(aTitle.indexOf("Sum of ") + 7, aTitle.lastIndexOf(" scans ")));
        } else {
            lBeginScan = aMutliFile ? Integer.valueOf(aScans.substring(aScans.indexOf("=") + 1)) : (aScans == null ? Integer.valueOf(aTitle.substring(aTitle.indexOf("Scan ") + 5, aTitle.indexOf(" (rt="))).intValue() : Integer.valueOf(aScans.substring(aScans.indexOf("=") + 1)).intValue());
        }
        lCharge = Integer.valueOf(aCharge.substring(0, 1));
        String lResult = "";
        if (lSumOfScans == 1) {
            lResult = lLCRun + "_" + lCompound + "_" + lBeginScan + "_" + lSumOfScans + "_" + lCharge + ".mgf";
        } else if (lSumOfScans > 1) {
            lResult = lLCRun + "_" + lCompound + "_" + lBeginScan + "." + lEndScan + "_" + lSumOfScans + "_" + lCharge + ".mgf";
        }
        return lResult;
    }

    public String toString() {
        String s = null;
        s = this.iQueryNumber != 0 ? "Query " + this.iQueryNumber + " from spectrum: " + this.iTitle : "Invalid QueryNumber.";
        return s;
    }
}

