/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.util.mascot;

import com.compomics.mascotdatfile.util.exception.MascotDatfileException;
import com.compomics.mascotdatfile.util.interfaces.MascotDatfileInf;
import com.compomics.mascotdatfile.util.mascot.Header;
import com.compomics.mascotdatfile.util.mascot.Masses;
import com.compomics.mascotdatfile.util.mascot.ModificationList;
import com.compomics.mascotdatfile.util.mascot.Parameters;
import com.compomics.mascotdatfile.util.mascot.PeptideToQueryMap;
import com.compomics.mascotdatfile.util.mascot.ProteinMap;
import com.compomics.mascotdatfile.util.mascot.Quantitation;
import com.compomics.mascotdatfile.util.mascot.Query;
import com.compomics.mascotdatfile.util.mascot.QueryToPeptideMap;
import com.compomics.mascotdatfile.util.mascot.iterator.QueryEnumerator;
import com.compomics.mascotdatfile.util.mascot.parser.MascotRawParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MascotDatfile
implements MascotDatfileInf {
    private static Logger logger = Logger.getLogger(MascotDatfile.class);
    private Header iHeader = null;
    private Masses iMasses = null;
    private MascotRawParser iMRP = null;
    private ModificationList iModificationList = null;
    private Parameters iParameters = null;
    private PeptideToQueryMap iPeptideToQueryMap = null;
    private ProteinMap iProteinMap = null;
    private Quantitation iQuantitation;
    private QueryToPeptideMap iQueryToPeptideMap = null;
    private QueryToPeptideMap iDecoyQueryToPeptideMap = null;
    private Vector iQueryList = null;
    private HashMap iQuerynumberToSpectrumfilename = null;
    private double[][] iThreshold = null;
    private double[][] iDecoyThreshold = null;
    private String iFileName = null;

    public MascotDatfile(String aDatFile) {
        try {
            File inputFile = new File(aDatFile);
            if (!inputFile.exists()) {
                throw new IllegalArgumentException("raw Mascot datfile from " + aDatFile + " does not exist.");
            }
            this.iMRP = new MascotRawParser(inputFile);
            this.setFileName(new File(aDatFile).getName());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public MascotDatfile(BufferedReader aReader) {
        try {
            this.iMRP = new MascotRawParser(aReader);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public MascotDatfile(BufferedReader aReader, String aFileName) {
        try {
            this.iMRP = new MascotRawParser(aReader);
            this.setFileName(aFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Header getHeaderSection() {
        if (this.iHeader == null) {
            this.iHeader = new Header(this.iMRP.getSection("header"));
        }
        return this.iHeader;
    }

    public Masses getMasses() {
        if (this.iMasses == null) {
            this.iMasses = new Masses(this.iMRP.getSection("masses"));
        }
        return this.iMasses;
    }

    public ModificationList getModificationList() {
        if (this.iModificationList == null) {
            Masses m = this.getMasses();
            if (m.getFixedModifications().size() > 0) {
                this.iModificationList = new ModificationList(m.getFixedModifications(), m.getVariableModifications());
            } else {
                Parameters p = this.getParametersSection();
                this.iModificationList = new ModificationList(m.getFixedModifications(), m.getVariableModifications(), p.getFixedModifications());
            }
        }
        return this.iModificationList;
    }

    public int getNumberOfQueries() {
        return this.getHeaderSection().getQueries();
    }

    public QueryToPeptideMap getQueryToPeptideMap() {
        if (this.iQueryToPeptideMap == null) {
            this.iQueryToPeptideMap = !this.isErrorTolerantSearch() ? new QueryToPeptideMap(this.iMRP.getSection("peptides"), this.getProteinMap(), this.getNumberOfQueries(), this.getModificationList(), this.getThresholds()) : new QueryToPeptideMap(this.iMRP.getSection("peptides"), this.iMRP.getSection("et_peptides"), this.getProteinMap(), this.getNumberOfQueries(), this.getModificationList(), this.getThresholds());
        }
        return this.iQueryToPeptideMap;
    }

    public QueryToPeptideMap getQueryToPeptideMap(Connection iConn) {
        if (this.iQueryToPeptideMap == null) {
            this.iQueryToPeptideMap = !this.isErrorTolerantSearch() ? new QueryToPeptideMap(this.iMRP.getSection("peptides"), this.getProteinMap(), this.getNumberOfQueries(), this.getModificationList(), this.getThresholds()) : new QueryToPeptideMap(this.iMRP.getSection("peptides"), this.iMRP.getSection("et_peptides"), this.getProteinMap(), this.getNumberOfQueries(), this.getModificationList(), this.getThresholds());
        }
        return this.iQueryToPeptideMap;
    }

    public QueryToPeptideMap getDecoyQueryToPeptideMap() {
        return this.getDecoyQueryToPeptideMap(true);
    }

    public QueryToPeptideMap getDecoyQueryToPeptideMap(boolean displayError) {
        if (this.iDecoyQueryToPeptideMap == null) {
            HashMap lHashMap = this.iMRP.getSection("decoy_peptides");
            if (lHashMap != null) {
                this.iDecoyQueryToPeptideMap = new QueryToPeptideMap(lHashMap, this.getProteinMap(), this.getNumberOfQueries(), this.getModificationList(), this.getThresholds());
            } else if (displayError) {
                System.err.println("No Decoy section found!!");
            }
        }
        return this.iDecoyQueryToPeptideMap;
    }

    public Vector getQueryList() {
        if (this.iQueryList == null) {
            int lNumQueries = this.iMRP.getNumberOfQueries();
            this.iQueryList = new Vector(lNumQueries);
            for (int i = 1; i < lNumQueries + 1; ++i) {
                HashMap lQuerySection = this.iMRP.getSection("query" + i);
                HashMap lSummarySection = this.iMRP.getSection("summary");
                double lPrecursorMass = Double.parseDouble((String)lSummarySection.get("qmass" + i));
                String lMzAndChargeString = (String)lSummarySection.get("qexp" + i);
                StringTokenizer st = new StringTokenizer(lMzAndChargeString, ",");
                double lPrecursorMZ = Double.parseDouble(st.nextToken());
                String lCharge = st.nextToken();
                if (st.hasMoreTokens()) {
                    throw new MascotDatfileException("There are tokens left unused!");
                }
                double lPrecursorIntensity = -1.0;
                if (lSummarySection.get("qintensity" + i) != null) {
                    lPrecursorIntensity = Double.parseDouble((String)lSummarySection.get("qintensity" + i));
                }
                this.iQueryList.add(new Query(lQuerySection, lPrecursorMZ, lCharge, lPrecursorMass, lPrecursorIntensity, i, this.getParametersSection()));
            }
        }
        return this.iQueryList;
    }

    public Iterator getQueryIterator() {
        return this.getQueryList().iterator();
    }

    public Query getQuery(int aQueryNumber) {
        return (Query)this.getQueryList().get(aQueryNumber - 1);
    }

    public QueryEnumerator getQueryEnumerator() {
        return new QueryEnumerator(this);
    }

    public Parameters getParametersSection() {
        if (this.iParameters == null) {
            this.iParameters = new Parameters(this.iMRP.getSection("parameters"));
        }
        return this.iParameters;
    }

    private boolean isErrorTolerantSearch() {
        String lErrorTolerantSearch = this.getParametersSection().getErrorTolerant();
        if (lErrorTolerantSearch != null) {
            if (lErrorTolerantSearch.equals("1")) {
                return true;
            }
            if (lErrorTolerantSearch.equals("0")) {
                return false;
            }
            throw new MascotDatfileException("Unexpected value ' " + this.iParameters.getErrorTolerant() + "' for error tolerant search parameter!!");
        }
        return false;
    }

    public PeptideToQueryMap getPeptideToQueryMap() {
        if (this.iPeptideToQueryMap == null) {
            this.iPeptideToQueryMap = new PeptideToQueryMap(this.getQueryToPeptideMap(), this.getQueryList());
        }
        return this.iPeptideToQueryMap;
    }

    public ProteinMap getProteinMap() {
        if (this.iProteinMap == null) {
            this.iProteinMap = new ProteinMap(this.iMRP.getSection("proteins"));
        }
        return this.iProteinMap;
    }

    public ProteinMap getDecoyProteinMap() {
        return this.getProteinMap();
    }

    public HashMap getSpectrumFilenameToQuerynumberMap() {
        if (this.iQuerynumberToSpectrumfilename == null) {
            this.iQuerynumberToSpectrumfilename = new HashMap();
            Vector lQueryList = this.getQueryList();
            for (int i = 0; i < lQueryList.size(); ++i) {
                Query lQuery = (Query)lQueryList.elementAt(i);
                int lQueryNumber = lQuery.getQueryNumber();
                String lQueryTitle = lQuery.getTitle();
                this.iQuerynumberToSpectrumfilename.put(lQueryTitle, new Integer(lQueryNumber));
            }
        }
        return this.iQuerynumberToSpectrumfilename;
    }

    public double[][] getThresholds() {
        if (this.iThreshold == null) {
            this.iThreshold = new double[this.getNumberOfQueries()][2];
            HashMap lSummary = this.iMRP.getSection("summary");
            for (int i = 0; i < this.getNumberOfQueries(); ++i) {
                this.iThreshold[i][0] = Double.parseDouble((String)lSummary.get("qplughole" + (i + 1)));
                this.iThreshold[i][1] = Double.parseDouble((String)lSummary.get("qmatch" + (i + 1)));
            }
        }
        return this.iThreshold;
    }

    public double[][] getDecoyThresholds() {
        if (this.iDecoyThreshold == null) {
            this.iDecoyThreshold = new double[this.getNumberOfQueries()][2];
            HashMap lSummary = this.iMRP.getSection("decoy_summary");
            if (lSummary == null) {
                for (int i = 0; i < this.getNumberOfQueries(); ++i) {
                    this.iDecoyThreshold[i][0] = Double.parseDouble((String)lSummary.get("qplughole" + (i + 1)));
                    this.iDecoyThreshold[i][1] = Double.parseDouble((String)lSummary.get("qmatch" + (i + 1)));
                }
            }
        }
        return this.iDecoyThreshold;
    }

    public String getFileName() {
        if (this.iFileName == null) {
            return "NA";
        }
        return this.iFileName;
    }

    public void setFileName(String aFileName) {
        this.iFileName = aFileName;
    }

    public void finish() {
        this.iMRP.clear();
    }

    public Quantitation getQuantitation() {
        if (this.iQuantitation == null) {
            HashMap hm = this.iMRP.getSection("quantitation");
            String lQuantitationContent = (String)hm.get("XML");
            this.iQuantitation = new Quantitation(lQuantitationContent);
        }
        return this.iQuantitation;
    }
}

