/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.research.script;

import com.compomics.mascotdatfile.util.interfaces.MascotDatfileInf;
import com.compomics.mascotdatfile.util.interfaces.QueryToPeptideMapInf;
import com.compomics.mascotdatfile.util.mascot.PeptideHit;
import com.compomics.mascotdatfile.util.mascot.Query;
import com.compomics.mascotdatfile.util.mascot.enumeration.MascotDatfileType;
import com.compomics.mascotdatfile.util.mascot.factory.MascotDatfileFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class PeptideHitParser {
    private static Logger logger = Logger.getLogger(PeptideHitParser.class);
    private File iOutput = null;
    private char iSeparator;
    private BufferedWriter writer = null;

    public static void main(String[] args) {
        if (args.length < 2) {
            PeptideHitParser.printUsage();
        } else {
            new PeptideHitParser(args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeptideHitParser(String[] lArguments) {
        try {
            int i;
            Double lAlpha = Double.parseDouble(lArguments[0]);
            ArrayList<String> lInputs = new ArrayList<String>();
            for (i = 2; i < lArguments.length; ++i) {
                String lInput = lArguments[i];
                lInputs.add(lInput);
            }
            this.iOutput = new File(lArguments[1]);
            this.writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.iOutput)));
            this.iSeparator = (char)59;
            MascotDatfileInf iMascotDatfile = null;
            for (i = 0; i < lInputs.size(); ++i) {
                String lFileName = (String)lInputs.get(i);
                File lInput = new File(lFileName);
                System.gc();
                System.out.println("Processing " + lInput);
                int lPeptideHitCounter = 0;
                int lQueryHitCounter = 0;
                iMascotDatfile = MascotDatfileFactory.create(lFileName, MascotDatfileType.INDEX);
                int lNumberOfQueries = iMascotDatfile.getHeaderSection().getQueries();
                QueryToPeptideMapInf lQueryToPeptideMap = iMascotDatfile.getQueryToPeptideMap();
                ArrayList<Object> list = null;
                for (int j = 1; j <= lNumberOfQueries; ++j) {
                    Query lQuery = iMascotDatfile.getQuery(j);
                    List<PeptideHit> lPeptideHits = lQueryToPeptideMap.getPeptideHitsAboveIdentityThreshold(j, lAlpha);
                    int lNumberOfPeptideHits = lPeptideHits.size();
                    if (lNumberOfPeptideHits > 0) {
                        ++lQueryHitCounter;
                    }
                    for (int k = 0; k < lNumberOfPeptideHits; ++k) {
                        PeptideHit lPeptideHit = lPeptideHits.get(k);
                        if (lPeptideHit == null) continue;
                        list = new ArrayList<Object>();
                        list.add(lInput.getName());
                        list.add(j);
                        list.add(lQuery.getFilename());
                        list.add(lQuery.getChargeString());
                        list.add(lPeptideHit.getSequence());
                        list.add(lPeptideHit.getModifiedSequence());
                        list.add(lPeptideHit.getIonsScore());
                        int lRank = k + 1;
                        list.add(lRank);
                        this.writeOutput(list);
                        ++lPeptideHitCounter;
                    }
                }
                iMascotDatfile.finish();
                System.out.println(String.format("Successfully parsed %d PSMs from %d (%d) Queries above alpha %f", ++lPeptideHitCounter, lQueryHitCounter, lNumberOfQueries, lAlpha));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            PeptideHitParser.printUsage();
        }
        finally {
            try {
                this.writer.flush();
                this.writer.close();
            }
            catch (IOException e) {
                System.out.println(String.format("Finished PeptideHitParser job", new Object[0]));
            }
        }
    }

    private static void printUsage() {
        System.out.println("SimpleParser arguments:\t <alpha> <output> <input 1> [<input 2> <input 3> ... <input n>]");
        System.out.println("\n\n");
        System.out.println("Arguments:");
        System.out.println("<alpha> \t alpha=0.05 reports peptide hits above 95% probability threshold");
        System.out.println("<output> \t output file");
        System.out.println("<input> \t one or more MascotDatfile input files");
        System.out.println("\n\n");
        System.out.println("Output structure:\n<MascotDatfile> <query number> <spectrum title> <charge state> <peptide> <peptide+PTM> <ionscore> <rank>");
    }

    private void writeOutput(ArrayList aList) throws IOException {
        for (int i = 0; i < aList.size(); ++i) {
            Object o = aList.get(i);
            this.writer.write(o.toString());
            this.writer.write(this.iSeparator);
        }
        this.writer.newLine();
        this.writer.flush();
    }
}

