## ----env, echo = FALSE--------------------------------------------------------
suppressPackageStartupMessages(library("BiocStyle"))
suppressPackageStartupMessages(library("Biostrings"))

## ----pxdata-------------------------------------------------------------------
library("rpx")
id <- "PXD000001"
px <- PXDataset(id)
px

## ----pxid---------------------------------------------------------------------
pxid(px)

## ----purl---------------------------------------------------------------------
pxurl(px)

## ----pxtax--------------------------------------------------------------------
pxtax(px)

## ----pxref--------------------------------------------------------------------
strwrap(pxref(px))

## ----pxfiles------------------------------------------------------------------
pxfiles(px)

## ----pxget--------------------------------------------------------------------
f <- pxget(px, "PXD000001_mztab.txt")
f

## ----pxan---------------------------------------------------------------------
pxannounced()

## ----more, warning=FALSE------------------------------------------------------
fas <- grep("fasta", pxfiles(px), value = TRUE)
fas
f <- pxget(px, fas)
f ## files available in the rpx cache

## ----example1-----------------------------------------------------------------
library("Biostrings")
readAAStringSet(f)

## ----si-----------------------------------------------------------------------
sessionInfo()

