/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.unifrac;

import edu.msu.cme.rdp.multicompare.MCSample;
import edu.msu.cme.rdp.multicompare.taxon.MCTaxon;
import edu.msu.cme.rdp.taxatree.ConcretRoot;
import edu.msu.cme.rdp.taxatree.UnifracTree;
import edu.msu.cme.rdp.taxatree.utils.NewickTreeBuilder;
import edu.msu.cme.rdp.unifrac.UnifracTaxon;
import edu.msu.cme.rdp.unifrac.UnifracTreeBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.cli.UnrecognizedOptionException;

public class Unifrac {
    private static final DecimalFormat format = new DecimalFormat("0.0000");
    private static final Options options = new Options();

    private static void printUsage() {
        new HelpFormatter().printHelp("Unifrac", options, true);
    }

    private static UnifracTree parseNewickTree(String treeFile, Map<String, UnifracTreeBuilder.UnifracSample> sampleMap) throws IOException {
        UnifracTree unifracTree = new UnifracTree();
        NewickTreeBuilder builder = new NewickTreeBuilder((ConcretRoot)unifracTree, (InputStream)new FileInputStream(treeFile), (NewickTreeBuilder.NewickTaxonFactory)new NewickTreeBuilder.NewickTaxonFactory<MCTaxon>(){

            public MCTaxon buildTaxon(int taxid, String name, float distance) {
                return new UnifracTaxon(taxid, name, "", distance);
            }
        });
        for (String seqName : sampleMap.keySet()) {
            UnifracTreeBuilder.UnifracSample sample = sampleMap.get(seqName);
            Integer taxid = builder.getTaxidByName(seqName);
            if (taxid == null) {
                System.err.println("Couldn't find " + seqName + " in the tree");
                continue;
            }
            ((UnifracTaxon)unifracTree.getChildTaxon(taxid)).addSampleCount(sample.sample, sample.count);
        }
        unifracTree.refreshInnerTaxa();
        return unifracTree;
    }

    public static void printResults(PrintStream out, UnifracTree.UnifracResult unifracResult, String label) {
        ArrayList<MCSample> labels = new ArrayList<MCSample>(unifracResult.getSamples());
        Collections.sort(labels, new Comparator<MCSample>(){

            @Override
            public int compare(MCSample o1, MCSample o2) {
                return o1.getSampleName().compareTo(o2.getSampleName());
            }
        });
        out.println(label);
        for (int i = 0; i < labels.size(); ++i) {
            for (int j = i + 1; j < labels.size(); ++j) {
                int row = unifracResult.getSamples().indexOf(labels.get(i));
                int col = unifracResult.getSamples().indexOf(labels.get(j));
                out.println(labels.get(i) + "-" + labels.get(j) + "\t" + format.format(unifracResult.getUnifracMatrix()[row][col]) + "  ");
            }
        }
    }

    private static Map<String, UnifracTreeBuilder.UnifracSample> readSampleMap(String sampleFile) throws IOException {
        HashMap<String, UnifracTreeBuilder.UnifracSample> ret = new HashMap<String, UnifracTreeBuilder.UnifracSample>();
        HashMap<String, MCSample> sampleMap = new HashMap<String, MCSample>();
        int lineno = 1;
        Scanner s = new Scanner(new File(sampleFile)).useDelimiter("\n");
        while (s.hasNext()) {
            String line = s.next().trim();
            if (line.equals("")) continue;
            String[] tokens = line.split("\\s+");
            if (tokens.length < 2) {
                throw new IOException("Failed to parse sample mapping file (lineno=" + lineno + ")");
            }
            String sampleName = tokens[1];
            String seqName = tokens[0];
            int sampleCount = 1;
            try {
                sampleCount = Integer.parseInt(tokens[2]);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!sampleMap.containsKey(sampleName)) {
                sampleMap.put(sampleName, new MCSample(sampleName));
            }
            UnifracTreeBuilder.UnifracSample unifracSample = new UnifracTreeBuilder.UnifracSample();
            unifracSample.sample = (MCSample)sampleMap.get(sampleName);
            unifracSample.count = sampleCount;
            ret.put(seqName, unifracSample);
            ++lineno;
        }
        s.close();
        return ret;
    }

    public static void main(String[] args) throws Exception {
        PosixParser parser = new PosixParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
        }
        catch (UnrecognizedOptionException e) {
            System.err.println(e.getMessage());
            Unifrac.printUsage();
            return;
        }
        UnifracTree unifracTree = null;
        PrintStream out = System.out;
        if (line.hasOption("tree") && line.hasOption("sequence-files")) {
            Unifrac.printUsage();
        } else if (!(line.hasOption("weighted") || line.hasOption("unweighted") || line.hasOption("significance"))) {
            System.err.println("Must specify at least one calculation option");
            Unifrac.printUsage();
        } else if (line.hasOption("sample-mapping")) {
            Map<String, UnifracTreeBuilder.UnifracSample> sampleMap = Unifrac.readSampleMap(line.getOptionValue("sample-mapping"));
            if (line.hasOption("tree")) {
                unifracTree = Unifrac.parseNewickTree(line.getOptionValue("tree"), sampleMap);
            }
        } else {
            if (!line.hasOption("sample-mapping")) {
                System.err.println("A sample mapping file must be provided");
            }
            Unifrac.printUsage();
        }
        if (line.hasOption("outfile")) {
            out = new PrintStream(line.getOptionValue("outfile"));
        }
        if (unifracTree != null) {
            if (line.hasOption("unweighted")) {
                Unifrac.printResults(out, unifracTree.computeUnifrac(), "Unweighted Unifrac");
                if (line.hasOption("significance")) {
                    Unifrac.printResults(out, unifracTree.computeUnifracSig(1000, false), "Unweighted Unifrac Significance");
                }
            }
            if (line.hasOption("weighted")) {
                Unifrac.printResults(out, unifracTree.computeWeightedUnifrac(), "Weighted Unifrac");
                if (line.hasOption("significance")) {
                    Unifrac.printResults(out, unifracTree.computeUnifracSig(1000, true), "Weighted Unifrac Significance");
                }
            }
        }
    }

    static {
        options.addOption("t", "tree", true, "Newick tree file to preform unifrac calculations on, must specify a sample mapping file");
        options.addOption("s", "sample-mapping", true, "Sample mapping file specifying what sample sequences are in");
        options.addOption("f", "sequence-file", true, "Comma seperated list of sequence files");
        options.addOption("u", "unweighted", false, "Perform unweighted unifrac calculation");
        options.addOption("w", "weighted", false, "Perform weighted unifrac calculation");
        options.addOption("S", "significance", false, "Compute significance with unifrac metric");
        options.addOption("o", "outfile", true, "Write results to file instead of stdout");
    }
}

