/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.io;

import edu.msu.cme.rdp.classifier.TrainingDataException;
import edu.msu.cme.rdp.classifier.utils.HierarchyVersion;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.StringTokenizer;

public class ProbIndexFileParser {
    public static HierarchyVersion createProbIndexArr(Reader r, int[] arr, HierarchyVersion version) throws IOException, TrainingDataException {
        BufferedReader reader = new BufferedReader(r);
        String line = reader.readLine();
        if (line != null) {
            HierarchyVersion thisVersion = new HierarchyVersion(line);
            int trainsetNo = thisVersion.getTrainsetNo();
            if (thisVersion.getVersion() == null) {
                throw new TrainingDataException("Error: There is no version information in the probabilityIndex file");
            }
            if (version == null) {
                version = thisVersion;
            } else if (!version.getVersion().equals(thisVersion.getVersion()) || version.getTrainsetNo() != thisVersion.getTrainsetNo()) {
                throw new TrainingDataException("Error: The version information in the probabilityIndex file is different from the version of the other training files.");
            }
        }
        while ((line = reader.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line, "\t");
            if (st.countTokens() != 2) {
                throw new TrainingDataException("\nError: " + line + " does not have exact two numbers");
            }
            try {
                int start;
                int wordIndex = Integer.parseInt(st.nextToken());
                arr[wordIndex] = start = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException e) {
                reader.close();
                throw new TrainingDataException("\nError: The value for wordIndex or start position is not a number at line : " + line);
            }
        }
        reader.close();
        return version;
    }
}

