/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.utils;

import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.SequenceReader;
import edu.msu.cme.rdp.readseq.utils.SeqUtils;
import edu.msu.cme.rdp.readseq.writers.FastaWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.io.output.NullWriter;

public class SequenceTrimmer {
    private static Sequence readRefSeq(File refSeqFile) throws IOException {
        SequenceReader reader = null;
        try {
            reader = new SequenceReader(refSeqFile);
            Object seq = reader.readNextSequence();
            Object tmp = reader.readNextSequence();
            if (tmp != null) {
                throw new IOException("Multiple sequences in refseq file");
            }
            Object e = seq;
            return e;
        }
        catch (IOException e) {
            throw new IOException("Failed to read reference sequence from " + refSeqFile + ": " + e.getMessage(), e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    public static TrimStats getStats(Sequence seq, int trimStart, int trimStop) {
        if (trimStart >= trimStop) {
            throw new IllegalArgumentException("Trim start has to come before trim end");
        }
        TrimStats ret = new TrimStats();
        int modelPos = 0;
        int seqPos = 0;
        int filled = 0;
        int alnStart = -1;
        char[] bases = seq.getSeqString().toCharArray();
        for (int index = 0; index < bases.length; ++index) {
            boolean intrim;
            char b = bases[index];
            boolean ischar = Character.isLetter(b);
            boolean isupper = ischar && Character.isUpperCase(b);
            boolean isgap = !ischar && (b == '.' || b == '~' || b == '-');
            boolean ismodel = b == '-' || isupper;
            boolean bl = intrim = modelPos >= trimStart && modelPos < trimStop;
            if (ischar) {
                ++seqPos;
                if (b == 'n' || b == 'N') {
                    ++ret.numNs;
                    if (intrim) {
                        ++ret.nsInTrim;
                    }
                }
                if (intrim) {
                    ++ret.trimmedLength;
                }
            }
            if (!ismodel) continue;
            if (modelPos == trimStart) {
                ret.seqTrimStart = seqPos;
                alnStart = index;
            }
            if (modelPos >= trimStart && modelPos < trimStop) {
                ++filled;
                if (ischar) {
                    ret.filledRatio += 1.0f;
                }
            }
            if (modelPos == trimStop) {
                ret.seqTrimStop = seqPos;
                ret.trimmedBases = Arrays.copyOfRange(bases, alnStart, index);
            }
            if (!isgap) {
                if (ret.seqStart == -1) {
                    ret.seqStart = modelPos;
                }
                ret.seqStop = modelPos;
            }
            ++modelPos;
        }
        ret.seqLength = seqPos;
        ret.modelLength = modelPos;
        ret.filledRatio /= (float)filled;
        return ret;
    }

    public static String trimMetaSeq(String seq, int trimStart, int trimStop) {
        int modelPos = 0;
        char[] bases = seq.toCharArray();
        int start = 0;
        int stop = 0;
        for (int index = 0; index < bases.length; ++index) {
            char b = bases[index];
            if (b == '.' || b == '~') continue;
            if (modelPos == trimStart) {
                start = index;
            }
            if (modelPos == trimStop) {
                stop = index;
            }
            ++modelPos;
        }
        if (stop == 0) {
            stop = bases.length;
        }
        return new String(Arrays.copyOfRange(bases, start, stop));
    }

    public static int translateCoord(int coord, Sequence seq, CoordType in, CoordType out) {
        int index;
        int modelPos = 0;
        int seqPos = 0;
        char[] bases = seq.getSeqString().toCharArray();
        for (index = 0; index < bases.length; ++index) {
            if (Character.isLetter(bases[index])) {
                ++seqPos;
            }
            if (in == CoordType.seq && seqPos == coord || in == CoordType.model && modelPos == coord || in == CoordType.alignment && index == coord) break;
            if (bases[index] != '-' && !Character.isUpperCase(bases[index])) continue;
            ++modelPos;
        }
        switch (out) {
            case seq: {
                return seqPos;
            }
            case model: {
                return modelPos;
            }
            case alignment: {
                return index;
            }
        }
        throw new IllegalArgumentException("Dunno what to do with out value " + (Object)((Object)out));
    }

    public static boolean didSeqPass(TrimStats stats, int minLength, int minTrimLength, int maxNs, int maxTrimNs, float minFilledRatio) {
        if (stats.trimmedLength <= minTrimLength) {
            return false;
        }
        if (stats.trimmedLength <= minLength) {
            return false;
        }
        if (stats.numNs > maxNs) {
            return false;
        }
        if (stats.nsInTrim > maxTrimNs) {
            return false;
        }
        return !(stats.filledRatio < minFilledRatio);
    }

    public static void writeStatsHeader(PrintWriter out) {
        out.println("#seq name\tfirst model pos\tlast model pos\tfilled ratio\ttrim seq start coord\ttrim seq end coord\tNs\tNs in trimmed seq\ttrimmed seq length\tseq length\tpassed trimming");
    }

    public static void writeStats(PrintWriter out, String seqName, TrimStats stats, boolean passed) {
        out.println(String.format("%s\t%d\t%d\t%.2f\t%d\t%d\t%d\t%d\t%d\t%d\t%b", seqName, stats.seqStart, stats.seqStop, Float.valueOf(stats.filledRatio), stats.seqTrimStart, stats.seqTrimStop, stats.numNs, stats.nsInTrim, stats.trimmedLength, stats.seqLength, passed));
    }

    public static void main(String[] args) throws IOException {
        Options options = new Options();
        options.addOption("r", "ref-seq", true, "Trim points are given as positions in a reference sequence from this file");
        options.addOption("i", "inclusive", false, "Trim points are inclusive");
        options.addOption("l", "length", true, "Minimum length of sequence after trimming");
        options.addOption("f", "filled-ratio", true, "Minimum ratio of filled model positions of sequence after trimming");
        options.addOption("o", "out", true, "Write sequences to directory (default=cwd)");
        options.addOption("s", "stats", true, "Write stats to file");
        PrintWriter statsOut = new PrintWriter((Writer)new NullWriter());
        boolean inclusive = false;
        int minLength = 0;
        int minTrimmedLength = 0;
        int maxNs = 0;
        int maxTrimNs = 0;
        int trimStart = 0;
        int trimStop = 0;
        Sequence refSeq = null;
        float minFilledRatio = 0.0f;
        int expectedModelPos = -1;
        String[] inputFiles = null;
        File outdir = new File(".");
        try {
            CommandLine line = new PosixParser().parse(options, args);
            if (line.hasOption("ref-seq")) {
                refSeq = SequenceTrimmer.readRefSeq(new File(line.getOptionValue("ref-seq")));
            }
            if (line.hasOption("inclusive")) {
                inclusive = true;
            }
            if (line.hasOption("length")) {
                minLength = Integer.valueOf(line.getOptionValue("length"));
            }
            if (line.hasOption("filled-ratio")) {
                minFilledRatio = Float.valueOf(line.getOptionValue("filled-ratio")).floatValue();
            }
            if (line.hasOption("out") && !(outdir = new File(line.getOptionValue("out"))).isDirectory()) {
                outdir = outdir.getParentFile();
                System.err.println("Output option is not a directory, using " + outdir + " instead");
            }
            if (line.hasOption("stats")) {
                statsOut = new PrintWriter(line.getOptionValue("stats"));
            }
            if ((args = line.getArgs()).length < 3) {
                throw new Exception("Unexpected number of arguments");
            }
            trimStart = Integer.parseInt(args[0]);
            trimStop = Integer.parseInt(args[1]);
            inputFiles = Arrays.copyOfRange(args, 2, args.length);
            if (refSeq != null) {
                expectedModelPos = SeqUtils.getMaskedBySeqString(refSeq.getSeqString()).length();
                trimStart = SequenceTrimmer.translateCoord(trimStart, refSeq, CoordType.seq, CoordType.model);
                trimStop = SequenceTrimmer.translateCoord(trimStop, refSeq, CoordType.seq, CoordType.model);
            }
        }
        catch (Exception e) {
            new HelpFormatter().printHelp("SequenceTrimmer <trim start> <trim stop> <aligned file> ...", options);
            System.err.println("Error: " + e.getMessage());
        }
        System.err.println("Starting sequence trimmer");
        System.err.println("*  Input files:           " + Arrays.asList(inputFiles));
        System.err.println("*  Minimum Length:        " + minLength);
        System.err.println("*  Trim point inclusive?: " + inclusive);
        System.err.println("*  Trim points:           " + trimStart + "-" + trimStop);
        System.err.println("*  Min filled ratio:      " + minFilledRatio);
        System.err.println("*  refSeq:                " + (refSeq == null ? "model" : refSeq.getSeqName() + " " + refSeq.getDesc()));
        SequenceTrimmer.writeStatsHeader(statsOut);
        for (String infile : inputFiles) {
            Object seq;
            File in = new File(infile);
            SequenceReader reader = new SequenceReader(in);
            FastaWriter seqWriter = new FastaWriter(new File(outdir, "trimmed_" + in.getName()));
            while ((seq = reader.readNextSequence()) != null) {
                if (((Sequence)seq).getSeqName().startsWith("#")) {
                    seqWriter.writeSeq(((Sequence)seq).getSeqName(), "", SequenceTrimmer.trimMetaSeq(((Sequence)seq).getSeqString(), trimStart, trimStop));
                    continue;
                }
                TrimStats stats = SequenceTrimmer.getStats(seq, trimStart, trimStop);
                boolean passed = SequenceTrimmer.didSeqPass(stats, minLength, minTrimmedLength, maxNs, maxTrimNs, minFilledRatio);
                SequenceTrimmer.writeStats(statsOut, ((Sequence)seq).getSeqName(), stats, passed);
                if (!passed) continue;
                seqWriter.writeSeq(((Sequence)seq).getSeqName(), ((Sequence)seq).getDesc(), new String(stats.trimmedBases));
            }
            reader.close();
            seqWriter.close();
        }
        statsOut.close();
    }

    public static class TrimStats {
        char[] trimmedBases;
        int seqStart = -1;
        int seqStop;
        int seqTrimStart;
        int seqTrimStop;
        int seqLength;
        int trimmedLength;
        int modelLength;
        int numNs;
        int nsInTrim;
        float filledRatio;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CoordType {
        seq,
        model,
        alignment;

    }
}

